/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.domain;

import com.suncode.plusocr.suncodeocr.domain.SuncodeOcrKey;
import com.suncode.plusocr.suncodeocr.dto.OpenAIOcrKeyDto;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OpenAIOcrKey {
    public static final List<OpenAIOcrKeyDto> basicFields = new LinkedList<OpenAIOcrKeyDto>();

    public static List<OpenAIOcrKeyDto> findKeysByNames(List<String> names) {
        return basicFields.stream().filter(field -> names.contains(field.getName())).collect(Collectors.toList());
    }

    public static Optional<OpenAIOcrKeyDto> findKeysById(String id) {
        return basicFields.stream().filter(field -> field.getId().equals(id)).findFirst();
    }

    public static void injectInvoiceId(List<OpenAIOcrKeyDto> fields, String invoiceId) {
        if (StringUtils.isBlank((CharSequence)invoiceId)) {
            return;
        }
        for (OpenAIOcrKeyDto field : fields) {
            if (!field.getPattern().contains(SuncodeOcrKey.INVOICE_INVOICE_ID.getKey())) continue;
            field.setPattern(field.getPattern().replace(SuncodeOcrKey.INVOICE_INVOICE_ID.getKey(), invoiceId));
        }
    }

    public static OpenAIOcrKeyDto createOpenAiKey(String id, String name, Type<?> type, List<String> enums, String pattern, String tableName, boolean paidField) {
        List<Object> targetEnum = enums == null ? Collections.emptyList() : enums;
        targetEnum.replaceAll(String::trim);
        return OpenAIOcrKeyDto.builder().id(id).name(name).type(OpenAIOcrKey.isNumeric(type) ? "number" : "string").format(OpenAIOcrKey.getFormat(type)).enumValues(targetEnum).pattern(pattern).targetType(type).tableName(tableName == null ? "" : tableName).descriptionKey("plusocr.suncodeocr.openai.context.desc." + name).paidField(paidField).build();
    }

    private static boolean isNumeric(Type<?> type) {
        return type == Types.INTEGER || type == Types.INTEGER_ARRAY || type == Types.FLOAT || type == Types.FLOAT_ARRAY;
    }

    private static String getFormat(Type<?> type) {
        if (type == Types.DATE || type == Types.DATE_ARRAY) {
            return "date";
        }
        if (type == Types.DATETIME || type == Types.DATETIME_ARRAY) {
            return "date-time";
        }
        return "";
    }

    static {
        basicFields.add(OpenAIOcrKey.createOpenAiKey("typ_faktury", "INVOICE_InvoiceType", Types.STRING, Arrays.asList("Zwyk\u0142a", "Korekta"), "", null, false));
        basicFields.add(OpenAIOcrKey.createOpenAiKey("numer_faktury_pierwotnej", "INVOICE_OriginalInvoiceNumber", Types.STRING, null, "^(?!" + SuncodeOcrKey.INVOICE_INVOICE_ID.getKey() + "$).+$", null, false));
        basicFields.add(OpenAIOcrKey.createOpenAiKey("sale_date", "INVOICE_SaleDate", Types.DATE, null, "", null, false));
        basicFields.add(OpenAIOcrKey.createOpenAiKey("numer_zamowienia", "INVOICE_OrderNumber", Types.STRING, null, "", null, false));
        basicFields.add(OpenAIOcrKey.createOpenAiKey("podzielona_platnosc", "INVOICE_SplitPayment", Types.STRING, Arrays.asList("Tak", "Nie"), "", null, false));
        basicFields.add(OpenAIOcrKey.createOpenAiKey("sposob_platnosci", "INVOICE_PaymentMethod", Types.STRING, Arrays.asList("Przelew", "Got\u00f3wka", "Karta", "Inna"), "", null, false));
        basicFields.add(OpenAIOcrKey.createOpenAiKey("order_number", "INVOICE_OrderNumberFromInvoiceTable", Types.STRING_ARRAY, null, "", "INVOICE_Items", false));
    }
}

