/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.scheduled_tasks;

import com.suncode.plusocr.alphamoon.domain.AlphamoonOcrData;
import com.suncode.plusocr.alphamoon.services.AlphamoonOcrDataService;
import com.suncode.plusocr.domain.OcrData;
import com.suncode.plusocr.services.OcrDataService;
import com.suncode.plusocr.utils.OcrProvider;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ScheduledTask
@Component
@ScheduledTaskScript(value="scripts/dynamic-pwe/scheduledtasks/delete-old-data.js")
public class DeleteOldData {
    private static final Logger log = LoggerFactory.getLogger(DeleteOldData.class);
    @Autowired
    private OcrDataService ocrDataService;
    @Autowired
    private AlphamoonOcrDataService alphamoonOcrDataService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusocr-delete-old-data")).name("scheduledtask.plusocr.delete-old-data")).description("scheduledtask.plusocr.delete-old-data.desc")).cancelable().parameter().id("provider").name("scheduledtask.plusocr.parameter.provider.name").description("scheduledtask.plusocr.parameter.provider.desc").type((Type)Types.STRING).defaultValue((Object)OcrProvider.SKANUJ_TO.name()).optional().create()).parameter().id("days").name("scheduledtask.plusocr.parameter.days.name").description("scheduledtask.plusocr.parameter.days.desc").type((Type)Types.INTEGER).create();
    }

    public void execute(@Param String provider, @Param Integer days) {
        block3: {
            OcrProvider ocrProvider;
            Date date;
            block2: {
                date = this.getDateShiftedByDays(days);
                ocrProvider = OcrProvider.valueOf(provider);
                if (ocrProvider != OcrProvider.SKANUJ_TO) break block2;
                List<OcrData> dataList = this.ocrDataService.getOlderThan(date);
                for (OcrData e : dataList) {
                    this.ocrDataService.delete(e.getId());
                }
                break block3;
            }
            if (ocrProvider != OcrProvider.ALPHAMOON_AI) break block3;
            List dataList = this.alphamoonOcrDataService.getOlderThan(date);
            for (AlphamoonOcrData data : dataList) {
                this.alphamoonOcrDataService.delete(data.getId());
            }
        }
    }

    private Date getDateShiftedByDays(Integer days) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -Math.abs(days));
        return cal.getTime();
    }
}

