/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.pluginconfigurationmanager.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plusocr.pluginconfigurationmanager.dto.AlphamoonConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.dto.OcrConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.dto.SkanujToConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.dto.SuncodeOcrConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.services.OcrConfigurationService;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Provides(value={OcrConfigurationService.class})
public class OcrConfigurationServiceImpl
implements OcrConfigurationService {
    public static final String DEFAULT_PCM_CONFIGURATION_FILE_ID = "config";
    private static final String SYSTEM_PARAMETER_TAG = "SYSTEM_PARAMETER:";
    private final ObjectMapper mapper = new ObjectMapper();
    private final Plugin plugin;
    private final ConfigurationFileService configurationFileService;
    private final SystemParameterService systemParameterService;

    @Autowired
    public OcrConfigurationServiceImpl(Plugin plugin, ConfigurationFileService configurationFileService, SystemParameterService systemParameterService) {
        this.plugin = plugin;
        this.configurationFileService = configurationFileService;
        this.systemParameterService = systemParameterService;
    }

    @Override
    public List<String> getConfigurationList() {
        return Arrays.asList(this.configurationFileService.getAllReadableFilesIds(this.plugin.getKey()));
    }

    @Override
    public List<SuncodeOcrConfigurationDto> getSuncodeOcrConfigurations(List<String> configurationId) {
        ArrayList<SuncodeOcrConfigurationDto> configurations = new ArrayList<SuncodeOcrConfigurationDto>();
        for (String configId : configurationId) {
            configurations.add(this.readConfigurationFile(configId).getSuncodeOcr());
        }
        return configurations;
    }

    @Override
    public OcrConfigurationDto readConfigurationFile() {
        Optional<OcrConfigurationDto> defaultOcrConfigurationDto = this.getConfigurationList().stream().filter(name -> name.equals(DEFAULT_PCM_CONFIGURATION_FILE_ID)).map(this::readConfigurationFile).findAny();
        return defaultOcrConfigurationDto.orElseGet(() -> this.getConfigurationList().stream().findFirst().map(this::readConfigurationFile).orElseThrow(RuntimeException::new));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OcrConfigurationDto readConfigurationFile(String configurationId) {
        try (InputStream stream = this.configurationFileService.readFile(this.plugin.getKey(), configurationId);){
            String configuration = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            OcrConfigurationDto ocrConfigurationDto = (OcrConfigurationDto)this.mapper.readValue(configuration, OcrConfigurationDto.class);
            SkanujToConfigurationDto skanujToConfig = ocrConfigurationDto.getSkanujTo();
            skanujToConfig.setApiUrl(this.parseValueFromPcm(skanujToConfig.getApiUrl()));
            skanujToConfig.setLogin(this.parseValueFromPcm(skanujToConfig.getLogin()));
            skanujToConfig.setPassword(this.parseValueFromPcm(skanujToConfig.getPassword()));
            skanujToConfig.setCompanyId(this.parseValueFromPcm(skanujToConfig.getCompanyId()));
            skanujToConfig.setApiKey(this.parseValueFromPcm(skanujToConfig.getApiKey()));
            AlphamoonConfigurationDto alphamoonConfig = ocrConfigurationDto.getAlphamoon();
            alphamoonConfig.setApiKey(this.parseValueFromPcm(alphamoonConfig.getApiKey()));
            SuncodeOcrConfigurationDto suncodeOcrConfiguration = ocrConfigurationDto.getSuncodeOcr();
            if (suncodeOcrConfiguration != null) {
                suncodeOcrConfiguration.setApiKey(this.parseValueFromPcm(suncodeOcrConfiguration.getApiKey()));
                suncodeOcrConfiguration.setEndpoint(this.parseValueFromPcm(suncodeOcrConfiguration.getEndpoint()));
            }
            OcrConfigurationDto ocrConfigurationDto2 = ocrConfigurationDto;
            return ocrConfigurationDto2;
        }
    }

    public String parseValueFromPcm(String parameterValue) {
        if (parameterValue.startsWith(SYSTEM_PARAMETER_TAG)) {
            String systemParameterKey = parameterValue.substring(SYSTEM_PARAMETER_TAG.length());
            SystemParameter systemParameter = this.systemParameterService.getParameter(systemParameterKey);
            if (systemParameter.getParameterType().equals((Object)ParameterType.PASSWORD)) {
                return SystemProperties.getPassword((String)systemParameterKey);
            }
            return SystemProperties.getString((String)systemParameterKey);
        }
        return parameterValue;
    }
}

