/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.utils;

import com.github.sisyphsu.dateparser.DateParser;
import java.time.Month;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class CustomDateParser {
    private static final Map<Month, Pattern> POLISH_MONTHS_PATTERNS;
    private static final Map<Month, Pattern> LITHUANIAN_MONTHS_PATTERNS;
    private static final String REMOVABLE_SYMBOLS_REGEX;
    private static final DateParser parser;
    private static final String DIGIT_LETTER_SEPARATOR_PATTERN = "(?<=\\d)(?=[a-z])|(?<=[a-z])(?=\\d)";
    private static final String SPECIAL_CHARACTERS_PATTERN = "[^A-Za-z0-9]";
    private static final String SHORT_WORDS_PATTERN = "\\b\\D{1,2}\\b";

    public static LocalDate parseDate(String input) {
        String parsedValue = StringUtils.stripAccents((String)input);
        if (parsedValue.matches(".*[a-zA-Z].*")) {
            parsedValue = parsedValue.toLowerCase(Locale.ROOT);
            parsedValue = parsedValue.replaceAll(DIGIT_LETTER_SEPARATOR_PATTERN, " ");
            parsedValue = parsedValue.replaceAll(SPECIAL_CHARACTERS_PATTERN, " ");
            parsedValue = parsedValue.replaceAll(SHORT_WORDS_PATTERN, " ");
            parsedValue = parsedValue.replaceAll(REMOVABLE_SYMBOLS_REGEX, "");
            parsedValue = CustomDateParser.translateMonth(parsedValue);
        }
        parsedValue = parsedValue.trim();
        Date parsedDate = parser.parseDate(parsedValue);
        return new LocalDate((Object)new DateTime((Object)parsedDate).toLocalDate());
    }

    private static Pattern createPattern(String ... patterns) {
        String regexPattern = Arrays.stream(patterns).map(pattern -> pattern + "[a-z]*").collect(Collectors.joining("|"));
        return Pattern.compile(regexPattern);
    }

    private static String translateMonth(String input) {
        Matcher matcher;
        Pattern pattern;
        Month month;
        for (Map.Entry<Month, Pattern> entry : POLISH_MONTHS_PATTERNS.entrySet()) {
            month = entry.getKey();
            pattern = entry.getValue();
            matcher = pattern.matcher(input);
            if (!matcher.find()) continue;
            return matcher.replaceAll(month.name());
        }
        for (Map.Entry<Month, Pattern> entry : LITHUANIAN_MONTHS_PATTERNS.entrySet()) {
            month = entry.getKey();
            pattern = entry.getValue();
            matcher = pattern.matcher(input);
            if (!matcher.find()) continue;
            return matcher.replaceAll(month.name());
        }
        return input;
    }

    private CustomDateParser() {
    }

    static {
        parser = DateParser.newBuilder().build();
        POLISH_MONTHS_PATTERNS = new EnumMap<Month, Pattern>(Month.class);
        POLISH_MONTHS_PATTERNS.put(Month.JANUARY, CustomDateParser.createPattern("sty"));
        POLISH_MONTHS_PATTERNS.put(Month.FEBRUARY, CustomDateParser.createPattern("lut"));
        POLISH_MONTHS_PATTERNS.put(Month.MARCH, CustomDateParser.createPattern("mar"));
        POLISH_MONTHS_PATTERNS.put(Month.APRIL, CustomDateParser.createPattern("kwi"));
        POLISH_MONTHS_PATTERNS.put(Month.MAY, CustomDateParser.createPattern("maj"));
        POLISH_MONTHS_PATTERNS.put(Month.JUNE, CustomDateParser.createPattern("cze"));
        POLISH_MONTHS_PATTERNS.put(Month.JULY, CustomDateParser.createPattern("lip"));
        POLISH_MONTHS_PATTERNS.put(Month.AUGUST, CustomDateParser.createPattern("sie"));
        POLISH_MONTHS_PATTERNS.put(Month.SEPTEMBER, CustomDateParser.createPattern("wrz"));
        POLISH_MONTHS_PATTERNS.put(Month.OCTOBER, CustomDateParser.createPattern("paz"));
        POLISH_MONTHS_PATTERNS.put(Month.NOVEMBER, CustomDateParser.createPattern("lis"));
        POLISH_MONTHS_PATTERNS.put(Month.DECEMBER, CustomDateParser.createPattern("gru"));
        LITHUANIAN_MONTHS_PATTERNS = new EnumMap<Month, Pattern>(Month.class);
        LITHUANIAN_MONTHS_PATTERNS.put(Month.JANUARY, CustomDateParser.createPattern("sau"));
        LITHUANIAN_MONTHS_PATTERNS.put(Month.FEBRUARY, CustomDateParser.createPattern("vas"));
        LITHUANIAN_MONTHS_PATTERNS.put(Month.MARCH, CustomDateParser.createPattern("kov"));
        LITHUANIAN_MONTHS_PATTERNS.put(Month.APRIL, CustomDateParser.createPattern("bal"));
        LITHUANIAN_MONTHS_PATTERNS.put(Month.MAY, CustomDateParser.createPattern("geg", "gerg"));
        LITHUANIAN_MONTHS_PATTERNS.put(Month.JUNE, CustomDateParser.createPattern("bir"));
        LITHUANIAN_MONTHS_PATTERNS.put(Month.JULY, CustomDateParser.createPattern("lie"));
        LITHUANIAN_MONTHS_PATTERNS.put(Month.AUGUST, CustomDateParser.createPattern("rgp", "rugp"));
        LITHUANIAN_MONTHS_PATTERNS.put(Month.SEPTEMBER, CustomDateParser.createPattern("rgs", "rugs"));
        LITHUANIAN_MONTHS_PATTERNS.put(Month.OCTOBER, CustomDateParser.createPattern("spa"));
        LITHUANIAN_MONTHS_PATTERNS.put(Month.NOVEMBER, CustomDateParser.createPattern("lap"));
        LITHUANIAN_MONTHS_PATTERNS.put(Month.DECEMBER, CustomDateParser.createPattern("grd", "gruod"));
        List<String> removableSymbols = Arrays.asList("men", "roku");
        REMOVABLE_SYMBOLS_REGEX = removableSymbols.stream().map(Pattern::quote).collect(Collectors.joining("|"));
    }
}

