/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.upgrader_tasks;

import com.suncode.upgrader.change.ChangeContext;
import com.suncode.upgrader.change.task.Task;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertLocalDatesToDates
implements Task {
    private static final Logger log = LoggerFactory.getLogger(ConvertLocalDatesToDates.class);
    private static final String TABLE_NAME = "pm_ocr_suncode_ocr_data";
    private static final String OLD_CREATED_AT_COLUMN = "created_at";
    private static final String OLD_PROCESSED_AT_COLUMN = "processed_at";
    private static final String NEW_CREATED_AT_COLUMN = "created_at_date";
    private static final String NEW_PROCESSED_AT_COLUMN = "processed_at_date";
    private static final String SELECT_QUERY = String.format("SELECT id, %s, %s FROM %s", "created_at", "processed_at", "pm_ocr_suncode_ocr_data");

    public void run() {
        block27: {
            Connection conn = ChangeContext.connection();
            if (!this.columnExists(conn, TABLE_NAME, OLD_CREATED_AT_COLUMN) || !this.columnExists(conn, TABLE_NAME, OLD_PROCESSED_AT_COLUMN)) break block27;
            try (PreparedStatement selectStatement = conn.prepareStatement(SELECT_QUERY);
                 ResultSet resultSet = selectStatement.executeQuery();){
                while (resultSet.next()) {
                    long id = resultSet.getLong("id");
                    LocalDate createdAt = this.readLocalDate(resultSet, OLD_CREATED_AT_COLUMN);
                    LocalDate processedAt = this.readLocalDate(resultSet, OLD_PROCESSED_AT_COLUMN);
                    if (createdAt == null && processedAt == null) continue;
                    this.migrateDataToNewColumns(id, createdAt, processedAt, conn);
                }
            }
        }
    }

    private LocalDate readLocalDate(ResultSet resultSet, String columnName) throws SQLException, IOException, ClassNotFoundException {
        try {
            return resultSet.getObject(columnName, LocalDate.class);
        }
        catch (AbstractMethodError | ClassCastException | SQLException ignored) {
            log.debug("Could not read value as LocalDate");
            try {
                Date date = resultSet.getDate(columnName);
                return date != null ? date.toLocalDate() : null;
            }
            catch (AbstractMethodError | ClassCastException | SQLException ignored2) {
                log.debug("Could not read value as Date");
                byte[] data = resultSet.getBytes(columnName);
                if (data != null) {
                    if (this.isSerializedObject(data)) {
                        return this.deserializeLocalDate(data);
                    }
                    String dateString = new String(data, StandardCharsets.UTF_8).trim();
                    return LocalDate.parse(dateString, DateTimeFormatter.ISO_LOCAL_DATE);
                }
                return null;
            }
        }
    }

    private LocalDate deserializeLocalDate(byte[] data) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));){
            LocalDate localDate = (LocalDate)ois.readObject();
            return localDate;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean columnExists(Connection connection, String tableName, String columnName) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String dbName = metaData.getDatabaseProductName().toLowerCase(Locale.ROOT);
            if (dbName.contains("oracle")) {
                tableName = tableName.toUpperCase(Locale.ROOT);
                columnName = columnName.toUpperCase(Locale.ROOT);
            }
            try (ResultSet columns = metaData.getColumns(null, null, tableName, columnName);){
                boolean bl = columns.next();
                return bl;
            }
        }
        catch (SQLException e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean isSerializedObject(byte[] data) {
        return data.length > 1 && data[0] == -84 && data[1] == -19;
    }

    private void migrateDataToNewColumns(long id, LocalDate createdAt, LocalDate processedAt, Connection conn) throws SQLException {
        StringBuilder sql = new StringBuilder(String.format("UPDATE %s SET ", TABLE_NAME));
        ArrayList<Comparable<java.util.Date>> params = new ArrayList<Comparable<java.util.Date>>();
        if (createdAt != null) {
            sql.append(String.format("%s = ?, ", NEW_CREATED_AT_COLUMN));
            params.add(Date.valueOf(createdAt));
        }
        if (processedAt != null) {
            sql.append(String.format("%s = ?, ", NEW_PROCESSED_AT_COLUMN));
            params.add(Date.valueOf(processedAt));
        }
        sql.setLength(sql.length() - 2);
        sql.append(" WHERE id = ?");
        params.add(Long.valueOf(id));
        try (PreparedStatement updateStatement = conn.prepareStatement(sql.toString());){
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i) instanceof Date) {
                    updateStatement.setDate(i + 1, (Date)params.get(i));
                    continue;
                }
                if (!(params.get(i) instanceof Long)) continue;
                updateStatement.setLong(i + 1, (Long)params.get(i));
            }
            updateStatement.executeUpdate();
        }
    }

    public void rollback() {
    }
}

