/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.service;

import com.azure.ai.documentintelligence.models.AnalyzeOperationDetails;
import com.azure.ai.documentintelligence.models.AnalyzeResult;
import com.azure.ai.documentintelligence.models.AnalyzedDocument;
import com.suncode.plusocr.pluginconfigurationmanager.dto.SuncodeOcrConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.services.OcrConfigurationService;
import com.suncode.plusocr.suncodeocr.db.ClassificationData;
import com.suncode.plusocr.suncodeocr.db.ResultOperationStatus;
import com.suncode.plusocr.suncodeocr.db.service.ClassificationDataService;
import com.suncode.plusocr.suncodeocr.dto.ResponseWrapper;
import com.suncode.plusocr.suncodeocr.service.ClassificationService;
import com.suncode.plusocr.suncodeocr.service.SuncodeOcrService;
import com.suncode.plusocr.utils.Utils;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.core.data.Record;
import com.suncode.pwfl.core.data.TableStore;
import com.suncode.pwfl.core.type.BasicTypes;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClassificationServiceImpl
implements ClassificationService {
    private static final Logger log = LoggerFactory.getLogger(ClassificationServiceImpl.class);
    @Autowired
    private FileService fileService;
    @Autowired
    private OcrConfigurationService configurationService;
    @Autowired
    private SuncodeOcrService ocrService;
    @Autowired
    private ClassificationDataService dataService;

    @Override
    public List<String> createRequests(String configurationId, List<Long> fileIds, boolean overwriteExisting) throws IOException {
        SuncodeOcrConfigurationDto configurationDto = this.getConfigurationDto(configurationId);
        ArrayList<Long> fileIdsToProcess = new ArrayList<Long>(fileIds);
        if (overwriteExisting) {
            this.dataService.removeExistingByFileIds(fileIds);
        } else {
            List existingFileIds = this.dataService.findByFileIds(fileIds).stream().mapToLong(ClassificationData::getFileId).boxed().collect(Collectors.toList());
            fileIdsToProcess.removeAll(existingFileIds);
        }
        Map<Long, CompletableFuture> promises = fileIdsToProcess.stream().collect(Collectors.toMap(fileId -> fileId, fileId -> this.ocrService.asyncClassifyDocument(configurationDto, this.fileService.getFile(fileId, new String[0]))));
        CompletableFuture.allOf(promises.values().toArray(new CompletableFuture[0])).join();
        ArrayList<String> createdRequests = new ArrayList<String>();
        try {
            promises.forEach((fileId, future) -> future.whenComplete((response, e) -> {
                Optional<String> requestId;
                if (e != null) {
                    log.error("No result for file ID: {}. Error: {}", fileId, (Object)e.getMessage());
                }
                if ((requestId = this.ocrService.extractOcrRequestId(response.getHeaders())).isPresent()) {
                    String fullPath = this.fileService.getFile(fileId, new String[0]).getFullPath();
                    int numberOfPages = Utils.getNumberOfPages(fullPath);
                    this.insertClassificationData((Long)fileId, requestId.get(), configurationId, numberOfPages);
                    createdRequests.add(requestId.get());
                }
            }));
        }
        catch (CompletionException e) {
            log.error("Error processing one of the requests!");
        }
        return createdRequests;
    }

    @Override
    public List<ClassificationData> processByFileIds(List<Long> fileIds, long timeout) throws InterruptedException {
        List<ClassificationData> unprocessed = this.dataService.findUnprocessedByFileIds(fileIds);
        return this.processRequestsLoop(unprocessed, timeout, null);
    }

    @Override
    public List<ClassificationData> processByRequestIds(List<String> requestIds, long timeout, long startDelay) throws InterruptedException {
        List<ClassificationData> unprocessed = this.dataService.findUnprocessedByRequestIds(requestIds);
        return this.processRequestsLoop(unprocessed, timeout, startDelay);
    }

    private List<ClassificationData> processRequestsLoop(List<ClassificationData> unprocessed, long timeout, Long startDelay) throws InterruptedException {
        if (unprocessed.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClassificationData> processed = new ArrayList<ClassificationData>();
        long startTime = System.currentTimeMillis();
        if (startDelay != null) {
            Thread.sleep(startDelay);
        }
        while (true) {
            try {
                Map<ClassificationData, CompletableFuture> promises = unprocessed.stream().collect(Collectors.toMap(request -> request, this::processRequest));
                CompletableFuture.allOf(promises.values().toArray(new CompletableFuture[0])).join();
                promises.forEach((item, future) -> future.whenComplete((response, e) -> {
                    ResultOperationStatus status;
                    if (e != null) {
                        log.error("No result for file ID: {}. Error: {}", (Object)item.getFileId(), (Object)e.getMessage());
                    }
                    if (!(status = ResultOperationStatus.valueOf(((AnalyzeOperationDetails)response.getBody()).getStatus().toString().toUpperCase(Locale.ROOT))).equals((Object)ResultOperationStatus.NOT_STARTED) && !status.equals((Object)ResultOperationStatus.RUNNING)) {
                        this.updateClassificationData((ClassificationData)item, (AnalyzeOperationDetails)response.getBody());
                        processed.add((ClassificationData)item);
                    }
                }));
            }
            catch (CompletionException e) {
                log.error("Error processing one of the requests!");
            }
            if (System.currentTimeMillis() - startTime >= timeout) {
                log.warn("Request timeout");
                break;
            }
            if (processed.size() == unprocessed.size()) {
                log.info("Response time: {}s", (Object)((System.currentTimeMillis() - startTime) / 1000L));
                break;
            }
            Thread.sleep(3000L);
        }
        return processed;
    }

    @Override
    public TableStore createTableStore(List<Long> fileId, List<ClassificationData> processedData) {
        Map<String, BasicTypes> variableTypes = this.createVariableTypes();
        List<Record> recordData = this.createRecordData(fileId, processedData);
        return TableStore.builder().variableType(variableTypes).data(recordData).build();
    }

    private CompletableFuture<ResponseWrapper<AnalyzeOperationDetails>> processRequest(ClassificationData data) {
        SuncodeOcrConfigurationDto configurationDto = this.configurationService.readConfigurationFile(data.getPcmConfig()).getSuncodeOcr();
        return this.ocrService.asyncGetClassifyDocumentResult(configurationDto, data.getOcrRequestId());
    }

    private SuncodeOcrConfigurationDto getConfigurationDto(String configurationId) throws IOException {
        return this.configurationService.readConfigurationFile(configurationId).getSuncodeOcr();
    }

    private void insertClassificationData(Long fileId, String requestId, String pcmConfig, int pageCount) {
        ClassificationData classificationData = ClassificationData.builder().fileId(fileId).ocrRequestId(requestId).pageCount(pageCount).pcmConfig(pcmConfig).createdAt(LocalDate.now()).operationStatus(ResultOperationStatus.NOT_STARTED).updatedAt(LocalDate.now()).build();
        this.dataService.save(classificationData);
    }

    private void updateClassificationData(ClassificationData request, AnalyzeOperationDetails result) {
        AnalyzeResult analyzeResult = result.getAnalyzeResult();
        Optional classifiedDocument = analyzeResult.getDocuments().stream().findFirst();
        if (!classifiedDocument.isPresent()) {
            throw new IOException("Error parsing result data");
        }
        request.setUpdatedAt(LocalDate.now());
        request.setJsonContent(result.toJsonString());
        request.setPageCountFromSuncodeOcr(analyzeResult.getPages().size());
        request.setOperationStatus(ResultOperationStatus.valueOf(result.getStatus().toString().toUpperCase(Locale.ROOT)));
        request.setResultType(((AnalyzedDocument)classifiedDocument.get()).getDocumentType());
        request.setResultConfidence(((AnalyzedDocument)classifiedDocument.get()).getConfidence());
        this.dataService.update(request);
    }

    private List<Record> createRecordData(List<Long> fileIds, List<ClassificationData> classificationData) {
        ArrayList<Record> recordData = new ArrayList<Record>();
        fileIds.forEach(id -> recordData.add(this.createRecord((Long)id, classificationData)));
        return recordData;
    }

    private Map<String, BasicTypes> createVariableTypes() {
        HashMap<String, BasicTypes> variableTypes = new HashMap<String, BasicTypes>();
        variableTypes.put("fileId", BasicTypes.INTEGER);
        variableTypes.put("json", BasicTypes.STRING);
        variableTypes.put("docType", BasicTypes.STRING);
        variableTypes.put("confidence", BasicTypes.FLOAT);
        return variableTypes;
    }

    private Record createRecord(Long id, List<ClassificationData> classificationData) {
        Optional<ClassificationData> data = classificationData.stream().filter(item -> item.getFileId().equals(id)).findAny();
        HashMap<String, Object> recordData = new HashMap<String, Object>();
        recordData.put("fileId", id);
        if (data.isPresent()) {
            recordData.put("json", data.get().getJsonContent());
            recordData.put("docType", data.get().getResultType());
            recordData.put("confidence", data.get().getResultConfidence());
        } else {
            recordData.put("json", "");
            recordData.put("docType", "");
            recordData.put("confidence", null);
        }
        return new Record(recordData);
    }
}

