/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.scheduledtask;

import com.suncode.plusocr.suncodeocr.db.ClassificationData;
import com.suncode.plusocr.suncodeocr.db.service.ClassificationDataService;
import com.suncode.plusocr.suncodeocr.service.ClassificationService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.assignment.AssignmentService;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessState;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ScheduledTask
public class GetClassificationResult {
    private static final Logger log = LoggerFactory.getLogger(GetClassificationResult.class);
    private static final String COMPONENT_ID = "plusocr.suncodeocr.scheduledtask.GetClassificationResult";
    private final AtomicLong pendingDocumentsCounter = new AtomicLong();
    private final AtomicInteger warningCounter = new AtomicInteger();
    private final AtomicInteger processedDocumentsCounter = new AtomicInteger();
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private ClassificationDataService dataService;
    @Autowired
    private ClassificationService classificationService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(COMPONENT_ID)).name(COMPONENT_ID.concat(".name"))).description(COMPONENT_ID.concat(".desc"))).parameter().id("processDefId").name(COMPONENT_ID.concat(".param.processDefId.name")).description(COMPONENT_ID.concat(".param.processFefId.desc")).type((Type)Types.STRING).create()).parameter().id("activityDefId").name(COMPONENT_ID.concat(".param.activityDefId.name")).description(COMPONENT_ID.concat(".param.activityDefId.desc")).type((Type)Types.STRING).create()).parameter().id("acceptButtonName").name(COMPONENT_ID.concat(".param.acceptButtonName.name")).description(COMPONENT_ID.concat(".param.acceptButtonName.desc")).type((Type)Types.STRING).optional().create()).parameter().id("fileIdVariableId").name(COMPONENT_ID.concat(".param.fileIdVariableId.name")).description(COMPONENT_ID.concat(".param.fileIdVariableId.desc")).type((Type)Types.STRING).create();
    }

    public String execute(@Param String processDefId, @Param String activityDefId, @Param String acceptButtonName, @Param String fileIdVariableId, org.apache.log4j.Logger taskLog) {
        this.warningCounter.set(0);
        this.pendingDocumentsCounter.set(0L);
        this.processedDocumentsCounter.set(0);
        List<Activity> openedBufferActivities = this.getOpenedActivities(processDefId, activityDefId);
        this.acceptProcessedTasks(openedBufferActivities, acceptButtonName, fileIdVariableId);
        openedBufferActivities = this.getOpenedActivities(processDefId, activityDefId);
        openedBufferActivities.forEach(bufferActivity -> {
            try {
                List<Long> fileIds = this.getFileIdListFromActivity(fileIdVariableId, (Activity)bufferActivity);
                List<Long> remainingFileIds = this.dataService.findUnprocessedByFileIds(fileIds).stream().map(ClassificationData::getFileId).collect(Collectors.toList());
                List<ClassificationData> processed = this.classificationService.processByFileIds(remainingFileIds, 300000L);
                if (processed.size() == remainingFileIds.size()) {
                    log.info("Accepting activity: {}; {} {}", new Object[]{bufferActivity.getProcessId(), activityDefId, bufferActivity.getActivityId()});
                    this.processedDocumentsCounter.getAndAdd(processed.size());
                    this.acceptTask((Activity)bufferActivity, acceptButtonName);
                    return;
                }
                this.pendingDocumentsCounter.getAndAdd(processed.size());
            }
            catch (Exception e) {
                this.warningCounter.getAndIncrement();
                this.logWarningEvent(taskLog);
                Thread.currentThread().interrupt();
            }
        });
        return String.format("%n Processed documents: %d%n Pending documents: %d%n Warnings: %d", this.processedDocumentsCounter.get(), this.pendingDocumentsCounter.get(), this.warningCounter.get());
    }

    private List<Long> getFileIdListFromActivity(String fileIdVariableId, Activity bufferActivity) {
        Map activityContext = this.activityService.getActivityContext(bufferActivity.getProcessId(), bufferActivity.getActivityId());
        return Arrays.stream(activityContext.get(fileIdVariableId).toString().split(";")).map(Long::parseLong).collect(Collectors.toList());
    }

    private void logWarningEvent(org.apache.log4j.Logger taskLog) {
        log.warn("Unexpected task interruption");
        taskLog.warn((Object)"Unexpected task interruption");
    }

    private void logActivityInfo(Activity activity) {
        log.info("Activity name: {}", (Object)activity.getName());
        log.info("Activity status: {}", (Object)activity.getState().name());
    }

    private void acceptProcessedTasks(List<Activity> openActivities, String acceptButtonName, String fileIdVariableId) {
        log.info("Accepting processed tasks...");
        for (Activity activity : openActivities) {
            this.logActivityInfo(activity);
            List<Long> fileIds = this.getFileIdListFromActivity(fileIdVariableId, activity);
            List<ClassificationData> remainingRequests = this.dataService.findUnprocessedByFileIds(fileIds);
            if (!remainingRequests.isEmpty()) continue;
            log.info("Accepting activity: {}; {} {}", new Object[]{activity.getProcessId(), activity.getActivityDefinitionId(), activity.getActivityId()});
            this.acceptTask(activity, acceptButtonName);
        }
    }

    private List<Activity> getOpenedActivities(String processDefId, String activityDefId) {
        return this.activityFinder.findActivities(processDefId, activityDefId, Arrays.asList(ActivityState.RUNNING, ActivityState.NOT_STARTED), new String[0]).stream().filter(activity -> ProcessState.isOpen((ProcessState)this.processService.getProcess(activity.getProcessId(), new String[0]).getState())).collect(Collectors.toList());
    }

    private void acceptTask(Activity activity, String acceptButtonName) {
        String processId = activity.getProcessId();
        String activityId = activity.getActivityId();
        String approveLogin = SystemProperties.getString((String)"Bufor.username");
        String buttonName = StringUtils.isBlank((CharSequence)acceptButtonName) ? activity.getName() : acceptButtonName;
        this.assignmentService.assignActivityToUser(processId, activityId, approveLogin);
        AcceptationDefinition acceptation = new AcceptationDefinition(processId, activityId, approveLogin, buttonName);
        acceptation.setIgnoreOwnerShip(Boolean.valueOf(true));
        this.activityService.acceptActivity(acceptation);
    }
}

