/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.autotask;

import com.suncode.plusocr.Categories;
import com.suncode.plusocr.suncodeocr.db.ClassificationData;
import com.suncode.plusocr.suncodeocr.db.service.ClassificationDataService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Application
public class ClassificationProcessMapping {
    private static final Logger log = LoggerFactory.getLogger(ClassificationProcessMapping.class);
    private static final String COMPONENT_ID = "plusocr.suncodeocr.autotask.ClassificationProcessMapping";
    @Autowired
    private ClassificationDataService dataService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(COMPONENT_ID)).name(COMPONENT_ID.concat(".name"))).description(COMPONENT_ID.concat(".desc"))).category(new Category[]{Categories.SCANNING})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("fileId").name(COMPONENT_ID.concat(".param.fileId.name")).description(COMPONENT_ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER_ARRAY).arrayMinLength(1).create()).parameter().id("typeVariable").name(COMPONENT_ID.concat(".param.typeVariable.name")).description(COMPONENT_ID.concat(".param.typeVariable.desc")).type((Type)Types.VARIABLE).create()).parameter().id("confidenceVariable").name(COMPONENT_ID.concat(".param.confidenceVariable.name")).description(COMPONENT_ID.concat(".param.confidenceVariable.desc")).type((Type)Types.VARIABLE).create();
    }

    public void execute(@Param Long[] fileId, @Param Variable typeVariable, @Param Variable confidenceVariable) throws AcceptanceException {
        if (fileId.length == 0) {
            return;
        }
        if (!typeVariable.isArray() || !confidenceVariable.isArray()) {
            throw new AcceptanceException("Expecting array type variables!");
        }
        String[] typesArray = new String[fileId.length];
        Double[] confidence = new Double[fileId.length];
        Map<Long, ClassificationData> processed = this.dataService.findByFileIds(Arrays.asList(fileId)).stream().collect(Collectors.toMap(ClassificationData::getFileId, data -> data));
        for (int i = 0; i < fileId.length; ++i) {
            if (processed.containsKey(fileId[i])) {
                typesArray[i] = processed.get(fileId[i]).getResultType();
                confidence[i] = processed.get(fileId[i]).getResultConfidence();
                continue;
            }
            typesArray[i] = "";
            confidence[i] = 0.0;
        }
        typeVariable.setValue((Object)typesArray);
        confidenceVariable.setValue((Object)confidence);
    }
}

