PWE.integrationComponent.registerApplication(
  "plusocr.suncodeocr.autotask.SuncodeOcrProcessMapping",
  {
    apiVersion: 2,
    buildForm: function (form) {
      const valueMappingTable = form.addTable({
        tableId: "valueMappingTable",
      });

      valueMappingTable.addField("valueVariable");
      valueMappingTable.addCombobox({
        id: "suncodeOcrKey",
        remote: {
          url: () => "plugin/com.suncode.plugin-plusocr/api/suncodeOcr/keys",
          fields: [
            {
              name: "key",
              type: "string",
            },
            {
              name: "type",
              type: "string",
            },
            {
              name: "description",
              type: "string",
            },
          ],
        },
        template: [
          {
            label: "Key",
            field: "key",
          },
          {
            label: "Type",
            field: "type",
          },
          {
            label: "Description",
            field: "description",
          },
        ],
        valueField: "key",
        displayField: "key",
        sort: [
          {
            property: "key",
            direction: "ASC",
          },
        ],
      });

      const functionMappingTable = form.addTable({
        tableId: "functionMappingTable",
      });

      functionMappingTable.addField("functionVariable");
      functionMappingTable.addField("suncodeOcrFunctionKey");

      const extraFieldsMappingTable = form.addTable({
        tableId: "extraFieldsMappingTable",
      });

      extraFieldsMappingTable.addField("extraFieldVariable");
      extraFieldsMappingTable.addField("extraFieldsKey");
      extraFieldsMappingTable.addField("extraFieldEnums");
      extraFieldsMappingTable.addField("extraFieldPattern");

      form.addField({
        id: 'forceOpenAiInvoiceLineReading',
        listeners: {
          change: function (value) {
            if (value === true) {
              form.show("openAiLineThreshold");
            } else {
              form.hide("openAiLineThreshold");
            }
          }
        }
      });
      form.addField("openAiLineThreshold");

      if (form.getValue("forceOpenAiInvoiceLineReading") === false) {
        form.hide("openAiLineThreshold");
      }
    },

    validateForm: function (api) {
      const extraFieldsKeys = api.getValue("extraFieldsKey", false);
      for (let i = 0; i < extraFieldsKeys.length; i++) {
        try {
          validateOpenAiKey(extraFieldsKeys[i]);
        } catch (e) {
          api.markError("extraFieldsKey", i);
          api.showErrorMessage(e.message);
          return false;
        }
      }
      return true;
    },
  }
);

function validateOpenAiKey(field) {
  if (!field || field.trim().length === 0) {
    throw new Error(PlusOCR.t("plusocr.suncodeocr.autotask.SuncodeOcrProcessMapping.valid.notEmpty"));
  }

  if (field.length > 50) {
    throw new Error(PlusOCR.t("plusocr.suncodeocr.autotask.SuncodeOcrProcessMapping.valid.max50characters").replace("{field}", field));
  }

  if (!/^[a-zA-Z].*$/.test(field)) {
    throw new Error(PlusOCR.t("plusocr.suncodeocr.autotask.SuncodeOcrProcessMapping.valid.letterStart").replace("{field}", field));
  }

  if (!/^[a-zA-Z][a-zA-Z0-9_]*$/.test(field)) {
    throw new Error(PlusOCR.t("plusocr.suncodeocr.autotask.SuncodeOcrProcessMapping.valid.onlyLetters").replace("{field}", field));
  }
}