PWE.integrationComponent.registerApplication("plusocr.suncodeocr.autotask.SplitDocumentByTypes", {
        apiVersion: 2,
        buildForm: function (form) {
            form.addField("fileId");
            form.addCombobox({
                id: "documentClassName",
                remote: {
                    url: "plugin/com.suncode.plugin-plusocr/api/document/classes",
                    fields: [
                        {
                            name: "name",
                            type: "string"
                        }
                    ]
                },
                valueField: "name",
                displayField: "name",
                sort: [{
                    property: "name",
                    direction: "ASC"
                }]
            });

            const typeIndexName = form.addCombobox({
                id: "typeIndexName",
                remote: {
                    url: () => "plugin/com.suncode.plugin-plusocr/api/document/indices/" + form.getValue("documentClassName"),
                    fields: [
                        {
                            name: "name",
                            type: "string"
                        }
                    ]
                },
                valueField: "name",
                displayField: "name",
                sort: [{
                    property: "name",
                    direction: "ASC"
                }]
            });

            const indicesTable = form.addTable({tableId: "indicesTable"});
            indicesTable.addCombobox({
                id: "indexName",
                remote: {
                    url: () => "plugin/com.suncode.plugin-plusocr/api/document/indices/" + form.getValue("documentClassName"),
                    fields: [
                        {
                            name: "name",
                            type: "string"
                        }
                    ]
                },
                valueField: "name",
                displayField: "name",
                sort: [{
                    property: "name",
                    direction: "ASC"
                }]
            });
            indicesTable.addField("indexValue");

            form.addField("executeDocumentClassActions");
            form.addField("processId");
            form.addField("activityId");
            form.addField("removeSourceDocument");
            form.addField("continueOnError");
        }
    }
);