const skanujToFields = [
    "nr_faktury", "sprzedawca_nazwa", "sprzedawca_nip", "sprzedawca_adres", "sprzedawca_kod", "sprzedawca_miejscowosc", "nabywca_nazwa",
    "nabywca_nip", "nabywca_adres", "nabywca_kod", "nabywca_miejscowosc", "data_sprzedazy", "data_wystawienia", "termin_platnosci",
    "sposob_platnosci", "waluta", "razem_netto", "razem_vat", "razem_brutto", "miesiac_ksiegowy", "konto_bankowe", "zaplacono", "data_wplywu",
    "czy_niekompletna_pozycja", "netto_waluta_podstawowa", "brutto_waluta_podstawowa", "vat_waluta_podstawowa", "nr_zamowienia", "kategoria",
    "category_id", "category_desc", "kurs_waluty", "korygujaca", "faktura_korygowana", "przyczyna_korekty", "description", "podzielona_platnosc",
    "pozycja_nazwa", "pozycja_ilosc", "pozycja_jednostka", "pozycja_cena", "pozycja_netto", "pozycja_brutto", "pozycja_staw_vat", "pozycja_vat"
];
const alphamoonFields = [
    "alphamoon.accountNumber", "alphamoon.bankName", "alphamoon.billingAddress", "alphamoon.billingEmail", "alphamoon.billingName",
    "alphamoon.billingVatNumber", "alphamoon.buyerEmail", "alphamoon.buyerId", "alphamoon.buyerName", "alphamoon.buyerAddress",
    "alphamoon.buyerPhone", "alphamoon.buyerVatNumber", "alphamoon.companyNumber", "alphamoon.currency", "alphamoon.deliveryDate", "alphamoon.iban",
    "alphamoon.invoiceDate", "alphamoon.invoiceNumber", "alphamoon.orderDate", "alphamoon.paymentDueDate", "alphamoon.paymentMethod",
    "alphamoon.paymentTerm", "alphamoon.purchaseOrderNumber", "alphamoon.receiverAddress", "alphamoon.receiverName", "alphamoon.receiverNip",
    "alphamoon.receiverPhone", "alphamoon.sellDate", "alphamoon.sellerAddress", "alphamoon.sellerEmail", "alphamoon.sellerName",
    "alphamoon.sellerPhone", "alphamoon.sellerVatNumber", "alphamoon.sellerWebsite", "alphamoon.sortCode", "alphamoon.swift",
    "alphamoon.totalAmount", "alphamoon.totalAmountDue", "alphamoon.totalNetAmount", "alphamoon.totalTaxAmount", "alphamoon.tableItemsUnit",
    "alphamoon.tableItemsAmount", "alphamoon.tableItemsPosition", "alphamoon.tableItemsQuantity", "alphamoon.tableItemsTaxRate",
    "alphamoon.tableItemsNetAmount", "alphamoon.tableItemsTaxAmount", "alphamoon.tableItemsUnitPrice", "alphamoon.tableItemsDescription",
    "alphamoon.tableItemsProductCode", "alphamoon.tableItemsNetUnitPrice", "alphamoon.tableItemsPurchaseOrderNumber"
];

const alphamoonAiConversionMap = new Map(Object.entries({
    "alphamoon.invoiceNumber": "nr_faktury",
    "alphamoon.sellerName": "sprzedawca_nazwa",
    "alphamoon.sellerVatNumber": "sprzedawca_nip",
    "alphamoon.sellerAddress": "sprzedawca_adres",
    "alphamoon.buyerName": "nabywca_nazwa",
    "alphamoon.buyerVatNumber": "nabywca_nip",
    "alphamoon.buyerAddress": "nabywca_adres",
    "alphamoon.sellDate": "data_sprzedazy",
    "alphamoon.invoiceDate": "data_wystawienia",
    "alphamoon.paymentDueDate": "termin_platnosci",
    "alphamoon.paymentMethod": "sposob_platnosci",
    "alphamoon.currency": "waluta",
    "alphamoon.totalNetAmount": "razem_netto",
    "alphamoon.totalTaxAmount": "razem_vat",
    "alphamoon.totalAmount": "razem_brutto",
    "alphamoon.accountNumber": "konto_bankowe",
    "alphamoon.purchaseOrderNumber": "nr_zamowienia",
    "alphamoon.tableItemsDescription": "pozycja_nazwa",
    "alphamoon.tableItemsQuantity": "pozycja_ilosc",
    "alphamoon.tableItemsUnit": "pozycja_jednostka",
    "alphamoon.tableItemsUnitPrice": "pozycja_cena",
    "alphamoon.tableItemsNetAmount": "pozycja_netto",
    "alphamoon.tableItemsAmount": "pozycja_brutto",
    "alphamoon.tableItemsTaxRate": "pozycja_staw_vat",
    "alphamoon.tableItemsTaxAmount": "pozycja_vat"
}));

PWE.integrationComponent.registerApplication('skanujto-mapping', {
    apiVersion: 2,
    buildForm: function (form) {
        form.addCombobox({
            id: "provider",
            values: [
                {id: "SKANUJ_TO", display: "Skanuj.to"},
                {id: "ALPHAMOON_AI", display: "[Deprecated] Alphamoon.ai"}
            ],
            listeners: {
                change: function (value) {
                    switchVisibility(form, value, copyButton);
                }
            }
        });

        form.addField("interrupt");

        const copyButtonText = PlusOCR.t("dpwe.copyConfigFromSkanujTo");
        form.addButton({
            text: copyButtonText,
            handler: function () {
                if (form.getValue("provider") === "ALPHAMOON_AI") {
                    copyVariables(form, alphamoonAiConversionMap);
                }
            }
        });

        // TODO: skorzystać w przyszłości z API do ukrywania przycisków, jeśli powstanie.
        const copyButton = Array.from(document.querySelectorAll('button'))
            .find(button => button.textContent === copyButtonText)
            .parentElement.closest('table');

        const parametersContainer = copyButton.parentElement;
        parametersContainer.hidden = true;

        skanujToFields.forEach(field => form.addField(field));
        alphamoonFields.forEach(field => form.addField(field));

        let alphamoonCustomFieldsMappingFieldSet = form.addFieldSet({
            id: "alphamoonCustomFieldsMappingFieldSet",
            title: PlusOCR.t("alphamoonCustomFieldsMappingFieldSet.title")
        });
        let alphamoonCustomFieldsMappingTable = alphamoonCustomFieldsMappingFieldSet.addTable({
            tableId: "alphamoonCustomFieldsMappingTable"
        });
        alphamoonCustomFieldsMappingTable.addField("alphamoon.customFieldIds");
        alphamoonCustomFieldsMappingTable.addField("alphamoon.customFieldVariables");

        switchVisibility(form, form.getValue("provider"), copyButton);
        parametersContainer.hidden = false;
    },
    validateForm: function (api) {
        let provider = api.getValue("provider");
        if (provider === "SKANUJ_TO") {
            return validateSkanujToForm(api);
        } else if (provider === "ALPHAMOON_AI") {
            return validateAlphamoonForm(api);
        }
    },
});

function checkSkanujToParams(form) {
    return skanujToFields.some(el => form.getValue(el) != null);
}

function switchVisibility(form, provider, copyButton) {
    const skanujToParamsEmpty = checkSkanujToParams(form);

    if (provider === "SKANUJ_TO") {
        copyButton.hidden = true;

        alphamoonFields.forEach(field => form.hide(field));
        skanujToFields.forEach(field => form.show(field));

        form.hide("alphamoonCustomFieldsMappingFieldSet");
    } else if (provider === "ALPHAMOON_AI") {
        copyButton.hidden = skanujToParamsEmpty;

        skanujToFields.forEach(field => form.hide(field));
        alphamoonFields.forEach(field => form.show(field));

        form.show("alphamoonCustomFieldsMappingFieldSet");
    }
}

function copyVariables(form, conversionMap) {
    conversionMap.forEach((source, target) => {
        const sourceValue = form.getValue(source);
        if (sourceValue) {
            form.setValue(target, sourceValue);
        }
    });
}

function validateSkanujToForm(api) {
    const errors = [];

    errors.push(checkField(api, 'nr_faktury', 'string'));
    errors.push(checkField(api, 'sprzedawca_nazwa', 'string'));
    errors.push(checkField(api, 'sprzedawca_nip', 'string'));
    errors.push(checkField(api, 'sprzedawca_adres', 'string'));
    errors.push(checkField(api, 'sprzedawca_kod', 'string'));
    errors.push(checkField(api, 'sprzedawca_miejscowosc', 'string'));
    errors.push(checkField(api, 'nabywca_nazwa', 'string'));
    errors.push(checkField(api, 'nabywca_nip', 'string'));
    errors.push(checkField(api, 'nabywca_adres', 'string'));
    errors.push(checkField(api, 'nabywca_kod', 'string'));
    errors.push(checkField(api, 'nabywca_miejscowosc', 'string'));
    errors.push(checkField(api, 'data_sprzedazy', 'date'));
    errors.push(checkField(api, 'data_wystawienia', 'date'));
    errors.push(checkField(api, 'termin_platnosci', 'date'));
    errors.push(checkField(api, 'sposob_platnosci', 'string'));
    errors.push(checkField(api, 'waluta', 'string'));
    errors.push(checkField(api, 'razem_netto', 'float'));
    errors.push(checkField(api, 'razem_vat', 'float'));
    errors.push(checkField(api, 'razem_brutto', 'float'));
    errors.push(checkField(api, 'miesiac_ksiegowy', 'string'));
    errors.push(checkField(api, 'konto_bankowe', 'string'));
    errors.push(checkField(api, 'zaplacono', 'string'));
    errors.push(checkField(api, 'data_wplywu', 'date'));
    errors.push(checkField(api, 'czy_niekompletna_pozycja', 'string'));
    errors.push(checkField(api, 'netto_waluta_podstawowa', 'float'));
    errors.push(checkField(api, 'brutto_waluta_podstawowa', 'float'));
    errors.push(checkField(api, 'vat_waluta_podstawowa', 'float'));
    errors.push(checkField(api, 'nr_zamowienia', 'string'));
    errors.push(checkField(api, 'kategoria', 'string'));
    errors.push(checkField(api, 'category_id', 'string'));
    errors.push(checkField(api, 'category_desc', 'string'));
    errors.push(checkField(api, 'kurs_waluty', 'float'));
    errors.push(checkField(api, 'korygujaca', 'string'));
    errors.push(checkField(api, 'faktura_korygowana', 'string'));
    errors.push(checkField(api, 'przyczyna_korekty', 'string'));
    errors.push(checkField(api, 'description', 'string'));
    errors.push(checkField(api, 'pozycja_nazwa', 'string[]'));
    errors.push(checkField(api, 'pozycja_ilosc', ['string[]', 'integer[]', 'float[]']));
    errors.push(checkField(api, 'pozycja_jednostka', 'string[]'));
    errors.push(checkField(api, 'pozycja_cena', ['string[]', 'float[]']));
    errors.push(checkField(api, 'pozycja_netto', ['string[]', 'float[]']));
    errors.push(checkField(api, 'pozycja_brutto', ['string[]', 'float[]']));
    errors.push(checkField(api, 'pozycja_staw_vat', ['string[]', 'float[]']));
    errors.push(checkField(api, 'pozycja_vat', ['string[]', 'float[]']));
    errors.push(checkField(api, 'podzielona_platnosc', 'boolean'));

    if (errors.some(isError => isError === true)) {
        api.showErrorMessage(PlusOCR.t('wrong-variable-type'))
        return false;
    }
    return true;
}

function validateAlphamoonForm(api) {
    const errors = [];

    errors.push(checkField(api, 'alphamoon.accountNumber', 'string'));
    errors.push(checkField(api, 'alphamoon.bankName', 'string'));
    errors.push(checkField(api, 'alphamoon.billingAddress', 'string'));
    errors.push(checkField(api, 'alphamoon.billingEmail', 'string'));
    errors.push(checkField(api, 'alphamoon.billingName', 'string'));
    errors.push(checkField(api, 'alphamoon.billingVatNumber', 'string'));
    errors.push(checkField(api, 'alphamoon.buyerEmail', 'string'));
    errors.push(checkField(api, 'alphamoon.buyerId', 'string'));
    errors.push(checkField(api, 'alphamoon.buyerName', 'string'));
    errors.push(checkField(api, 'alphamoon.buyerAddress', 'string'));
    errors.push(checkField(api, 'alphamoon.buyerPhone', 'string'));
    errors.push(checkField(api, 'alphamoon.buyerVatNumber', 'string'));
    errors.push(checkField(api, 'alphamoon.companyNumber', 'string'));
    errors.push(checkField(api, 'alphamoon.currency', 'string'));
    errors.push(checkField(api, 'alphamoon.deliveryDate', ['date', 'string']));
    errors.push(checkField(api, 'alphamoon.iban', 'string'));
    errors.push(checkField(api, 'alphamoon.invoiceDate', ['date', 'string']));
    errors.push(checkField(api, 'alphamoon.invoiceNumber', 'string'));
    errors.push(checkField(api, 'alphamoon.orderDate', ['date', 'string']));
    errors.push(checkField(api, 'alphamoon.paymentDueDate', ['date', 'string']));
    errors.push(checkField(api, 'alphamoon.paymentMethod', 'string'));
    errors.push(checkField(api, 'alphamoon.paymentTerm', 'string'));
    errors.push(checkField(api, 'alphamoon.purchaseOrderNumber', 'string'));
    errors.push(checkField(api, 'alphamoon.receiverAddress', 'string'));
    errors.push(checkField(api, 'alphamoon.receiverName', 'string'));
    errors.push(checkField(api, 'alphamoon.receiverNip', 'string'));
    errors.push(checkField(api, 'alphamoon.receiverPhone', 'string'));
    errors.push(checkField(api, 'alphamoon.sellDate', ['date', 'string']));
    errors.push(checkField(api, 'alphamoon.sellerAddress', 'string'));
    errors.push(checkField(api, 'alphamoon.sellerEmail', 'string'));
    errors.push(checkField(api, 'alphamoon.sellerName', 'string'));
    errors.push(checkField(api, 'alphamoon.sellerPhone', 'string'));
    errors.push(checkField(api, 'alphamoon.sellerVatNumber', 'string'));
    errors.push(checkField(api, 'alphamoon.sellerWebsite', 'string'));
    errors.push(checkField(api, 'alphamoon.sortCode', 'string'));
    errors.push(checkField(api, 'alphamoon.swift', 'string'));
    errors.push(checkField(api, 'alphamoon.totalAmount', ['float', 'string']));
    errors.push(checkField(api, 'alphamoon.totalAmountDue', ['float', 'string']));
    errors.push(checkField(api, 'alphamoon.totalNetAmount', ['float', 'string']));
    errors.push(checkField(api, 'alphamoon.totalTaxAmount', ['float', 'string']));
    errors.push(checkField(api, 'alphamoon.tableItemsUnit', 'string[]'));
    errors.push(checkField(api, 'alphamoon.tableItemsAmount', ['float[]', 'string[]']));
    errors.push(checkField(api, 'alphamoon.tableItemsPosition', ['integer[]', 'string[]']));
    errors.push(checkField(api, 'alphamoon.tableItemsQuantity', ['float[]', 'integer[]', 'string[]']));
    errors.push(checkField(api, 'alphamoon.tableItemsTaxRate', ['string[]', 'integer[]', 'float[]']));
    errors.push(checkField(api, 'alphamoon.tableItemsNetAmount', ['float[]', 'string[]']));
    errors.push(checkField(api, 'alphamoon.tableItemsTaxAmount', ['float[]', 'string[]']));
    errors.push(checkField(api, 'alphamoon.tableItemsUnitPrice', ['float[]', 'string[]']));
    errors.push(checkField(api, 'alphamoon.tableItemsDescription', 'string[]'));
    errors.push(checkField(api, 'alphamoon.tableItemsProductCode', 'string[]'));
    errors.push(checkField(api, 'alphamoon.tableItemsNetUnitPrice', ['float[]', 'string[]']));
    errors.push(checkField(api, 'alphamoon.tableItemsPurchaseOrderNumber', 'string[]'));

    if (errors.some(isError => isError === true)) {
        api.showErrorMessage(PlusOCR.t('wrong-variable-type'))
        return false;
    }
    return true;
}

var checkField = function (api, fieldId, type) {
    if (Array.isArray(type)) {
        if (type.map(t => api.getVariableType(fieldId) === t || api.getVariableType(fieldId) === null).every(b => b === false)) {
            api.markError(fieldId);
            return true;
        }
    } else {
        if (api.getVariableType(fieldId) !== type && api.getVariableType(fieldId) !== null) {
            api.markError(fieldId);
            return true;
        }
    }
    return false;
}