window.vfgFileSchema = {
    fields: [
        {
            type: "select",
            inputType: "text",
            label: "plusocr.pluginconfigurationmanager.graphicschema.field.provider.name",
            help: "plusocr.pluginconfigurationmanager.graphicschema.field.provider.desc",
            model: "provider",
            required: true,
            values: function () {
                return [
                    {id: "SKANUJ_TO", name: "Skanuj.to"},
                    {id: "ALPHAMOON_AI", name: "[Deprecated] Alphamoon.ai"},
                    {id: "SUNCODE_OCR", name: "Suncode OCR"},
                ];
            }
        },
        {
            type: "input",
            inputType: "password",
            label: "plusocr.pluginconfigurationmanager.graphicschema.field.skanujTo.apiKey.name",
            help: "plusocr.pluginconfigurationmanager.graphicschema.field.skanujTo.apiKey.desc",
            model: "skanujTo.apiKey",
            validator: "string",
            visible: (model) => checkForOcrProvider(model, "SKANUJ_TO")
        },
        {
            type: "input",
            inputType: "text",
            label: "plusocr.pluginconfigurationmanager.graphicschema.field.skanujTo.apiUrl.name",
            help: "plusocr.pluginconfigurationmanager.graphicschema.field.skanujTo.apiUrl.desc",
            model: "skanujTo.apiUrl",
            validator: "string",
            visible: (model) => checkForOcrProvider(model, "SKANUJ_TO")
        },
        {
            type: "input",
            inputType: "text",
            label: "plusocr.pluginconfigurationmanager.graphicschema.field.skanujTo.companyId.name",
            help: "plusocr.pluginconfigurationmanager.graphicschema.field.skanujTo.companyId.desc",
            model: "skanujTo.companyId",
            validator: "string",
            visible: (model) => checkForOcrProvider(model, "SKANUJ_TO")
        },
        {
            type: "input",
            inputType: "text",
            label: "plusocr.pluginconfigurationmanager.graphicschema.field.skanujTo.login.name",
            help: "plusocr.pluginconfigurationmanager.graphicschema.field.skanujTo.login.desc",
            model: "skanujTo.login",
            validator: "string",
            visible: (model) => checkForOcrProvider(model, "SKANUJ_TO")
        },
        {
            type: "input",
            inputType: "password",
            label: "plusocr.pluginconfigurationmanager.graphicschema.field.skanujTo.password.name",
            help: "plusocr.pluginconfigurationmanager.graphicschema.field.skanujTo.password.desc",
            model: "skanujTo.password",
            validator: "string",
            visible: (model) => checkForOcrProvider(model, "SKANUJ_TO")
        },
        {
            type: "input",
            inputType: "password",
            label: "plusocr.pluginconfigurationmanager.graphicschema.field.alphamoon.apiKey.name",
            help: "plusocr.pluginconfigurationmanager.graphicschema.field.alphamoon.apiKey.desc",
            model: "alphamoon.apiKey",
            validator: "string",
            visible: (model) => checkForOcrProvider(model, "ALPHAMOON_AI")
        },
        {
            type: "input",
            inputType: "password",
            label: "plusocr.pluginconfigurationmanager.graphicschema.field.suncodeOcr.apiKey.name",
            model: "suncodeOcr.apiKey",
            required: true,
            validator: "string",
            visible: (model) => checkForOcrProvider(model, "SUNCODE_OCR")
        },
        {
            type: "input",
            inputType: "text",
            label: "plusocr.pluginconfigurationmanager.graphicschema.field.suncodeOcr.endpoint.name",
            model: "suncodeOcr.endpoint",
            required: true,
            validator: "string",
            visible: (model) => checkForOcrProvider(model, "SUNCODE_OCR")
        },
        {
            type: "select",
            inputType: "text",
            label: "plusocr.pluginconfigurationmanager.graphicschema.field.suncodeOcr.modelId.name",
            model: "suncodeOcr.modelId",
            validator: "string",
            required: true,
            values: function () {
                let result = ["custom-model"];
                jQuery.ajax({
                    url: "plugin/com.suncode.plugin-plusocr/api/suncodeOcr/models",
                    async: false,
                    dataType: "json"
                }).done((data) => result.push(...data));

                return result;
            },
            visible: (model) => checkForOcrProvider(model, "SUNCODE_OCR")
        },
        {
            type: "input",
            inputType: "text",
            label: "plusocr.pluginconfigurationmanager.graphicschema.field.suncodeOcr.customModelId.name",
            model: "suncodeOcr.customModelId",
            required: (model) => checkForCustomModel(model),
            validator: "string",
            visible: (model) => checkForCustomModel(model)
        }
    ]
};

function checkForOcrProvider(model, provider) {
    return model && model.provider === provider;
}

function checkForCustomModel(model) {
    return checkForOcrProvider(model, "SUNCODE_OCR") && model.suncodeOcr.modelId === "custom-model";
}