/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.utils;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.springframework.util.Assert;

public class Utils {
    public static <T1, T2> Map<T1, T2> createMap(T1[] firstArray, T2[] secondArray) {
        Assert.isTrue((firstArray.length == secondArray.length ? 1 : 0) != 0, (String)MessageFormat.format("Arrays {0} and {1} are not equal", Arrays.toString(firstArray), Arrays.toString(secondArray)));
        return IntStream.range(0, firstArray.length).boxed().collect(HashMap::new, (map, index) -> map.put(firstArray[index], secondArray[index]), HashMap::putAll);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getNumberOfPages(String fullPath) {
        File file = new File(fullPath);
        try (PDDocument document = Loader.loadPDF((File)file);){
            int n = document.getNumberOfPages();
            return n;
        }
        catch (IOException e) {
            return 0;
        }
    }

    private Utils() {
    }
}

