/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class LoggingRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingRequestInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.traceRequest(request, body);
        ClientHttpResponse response = execution.execute(request, body);
        this.traceResponse(response);
        return response;
    }

    private void traceRequest(HttpRequest request, byte[] body) throws IOException {
        String bodyString = new String(body, StandardCharsets.UTF_8);
        if (bodyString.contains("password")) {
            bodyString = "secret";
        }
        log.debug("test");
        log.debug("===========================request begin================================================");
        log.debug("URI         : {}", (Object)request.getURI());
        log.debug("Method      : {}", (Object)request.getMethod());
        log.debug("Headers     : {}", (Object)request.getHeaders());
        log.debug("==========================request end================================================");
    }

    private void traceResponse(ClientHttpResponse response) throws IOException {
        StringBuilder inputStringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getBody(), StandardCharsets.UTF_8));
        String line = bufferedReader.readLine();
        while (line != null) {
            inputStringBuilder.append(line);
            inputStringBuilder.append('\n');
            line = bufferedReader.readLine();
        }
        log.debug("============================response begin==========================================");
        log.debug("Status code  : {}", (Object)response.getRawStatusCode());
        log.debug("Status text  : {}", (Object)response.getStatusText());
        log.debug("Headers      : {}", (Object)response.getHeaders());
        log.debug("=======================response end=================================================");
    }
}

