/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.tools;

import com.azure.ai.documentintelligence.implementation.AnalyzeOperationDetailsHelper;
import com.azure.ai.documentintelligence.models.AnalyzeOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceOperationStatus;
import com.suncode.plusocr.Categories;
import com.suncode.plusocr.alphamoon.domain.AlphamoonOcrData;
import com.suncode.plusocr.alphamoon.rest.AlphamoonService;
import com.suncode.plusocr.alphamoon.services.AlphamoonOcrDataService;
import com.suncode.plusocr.domain.OcrData;
import com.suncode.plusocr.pluginconfigurationmanager.dto.OcrConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.dto.SkanujToConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.dto.SuncodeOcrConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.services.OcrConfigurationService;
import com.suncode.plusocr.rest.SkanujToConnection;
import com.suncode.plusocr.services.OcrDataService;
import com.suncode.plusocr.suncodeocr.db.SuncodeOcrData;
import com.suncode.plusocr.suncodeocr.db.service.SuncodeOcrDataService;
import com.suncode.plusocr.suncodeocr.dto.ResponseWrapper;
import com.suncode.plusocr.suncodeocr.exception.ApiResponseFailedException;
import com.suncode.plusocr.suncodeocr.exception.UnsupportedMimeTypeException;
import com.suncode.plusocr.suncodeocr.service.SuncodeOcrService;
import com.suncode.plusocr.utils.OcrProvider;
import com.suncode.plusocr.utils.Utils;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Application
@Component
@ComponentsFormScript(value="scripts/dynamic-pwe/autotasks/document-process.js")
public class DocumentProcess {
    private static final Logger log = LoggerFactory.getLogger(DocumentProcess.class);
    @Autowired
    private SuncodeOcrService suncodeOcrService;
    @Autowired
    private SuncodeOcrDataService suncodeOcrDataService;
    @Autowired
    private AlphamoonService alphamoonService;
    @Autowired
    private AlphamoonOcrDataService alphamoonOcrDataService;
    @Autowired
    private OcrDataService ocrDataService;
    @Autowired
    private DocumentClassService docClassService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private CommentService commentService;
    @Autowired
    private OcrConfigurationService ocrConfigurationService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("skanujto-application")).name("application.skanujto")).description("application.skanujto.desc")).icon((Icon)SilkIconPack.APPLICATION_FORM)).category(new Category[]{Categories.SCANNING})).parameter().id("provider").name("application.parameter.provider.name").description("application.parameter.provider.desc").type((Type)Types.STRING).defaultValue((Object)OcrProvider.SKANUJ_TO.name()).create()).parameter().id("passed").name("application.parameter.passed.name").description("application.parameter.passed.desc").type((Type)Types.VARIABLE).create()).parameter().id("force_upload").name("application.parameter.forceUpload.name").description("application.parameter.forceUpload.desc").type((Type)Types.BOOLEAN).optional().defaultValue((Object)false).create()).parameter().id("document_classes").name("application.parameter.document_classes.name").description("application.parameter.document_classes.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("invoice_type").name("application.parameter.invoice_type.name").description("application.parameter.invoice_type.desc").type((Type)Types.INTEGER).optional().create()).parameter().id("alphamoonProcess").name("application.parameter.alphamoon.alphamoonProcess.name").description("application.parameter.alphamoon.alphamoonProcess.desc").type((Type)Types.STRING).optional().create()).parameter().id("skipMultiPageDocuments").name("application.parameter.skipMultiPageDocuments.name").description("application.parameter.skipMultiPageDocuments.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("maxNumberOfPages").name("application.parameter.maxNumberOfPages.name").description("application.parameter.maxNumberOfPages.desc").type((Type)Types.INTEGER).optional().create()).parameter().id("documentSendingOmitted").name("application.parameter.documentSendingOmitted.name").description("application.parameter.documentSendingOmitted.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("configurationId").name("application.parameter.configurationId.name").description("application.parameter.configurationId.desc").type((Type)Types.STRING).optional().create();
    }

    public void execute(ApplicationContext applicationContext, Translator translator, @Param String provider, @Param Variable passed, @Param(value="document_classes") String[] documentClasses, @Param(value="invoice_type") Integer invoiceType, @Param(value="force_upload") boolean forceUpload, @Param String alphamoonProcess, @Param(value="skipMultiPageDocuments") boolean skipMultiPageDocuments, @Param(value="maxNumberOfPages") Integer maxNumberOfPages, @Param Variable documentSendingOmitted, @Param String configurationId) throws AcceptanceException {
        String userInfo = this.getUserInfo();
        try {
            if (!EnumUtils.isValidEnum(OcrProvider.class, (String)provider)) {
                throw new AcceptanceException("Invalid OCR provider selected!");
            }
            WfDocument wfDoc = this.getDocumentToProceed(applicationContext.getActivityId(), translator, documentClasses, userInfo, applicationContext.getProcessId());
            int numberOfPages = Utils.getNumberOfPages(wfDoc.getFile().getFullPath());
            if (skipMultiPageDocuments && numberOfPages > 1) {
                log.info("The document was skipped due to having more than one page.");
                if (documentSendingOmitted != null) {
                    documentSendingOmitted.setValue((Object)true);
                }
            } else if (maxNumberOfPages != null && numberOfPages > maxNumberOfPages) {
                log.info("The document was skipped due to having more than " + maxNumberOfPages + " page.");
                if (documentSendingOmitted != null) {
                    documentSendingOmitted.setValue((Object)true);
                }
            } else {
                OcrProvider ocrProvider = OcrProvider.valueOf(provider);
                switch (ocrProvider) {
                    case ALPHAMOON_AI: {
                        this.documentProcessForAlphamoon(applicationContext, translator, passed, alphamoonProcess, wfDoc);
                        break;
                    }
                    case SKANUJ_TO: {
                        this.documentProcessForSkanujTo(applicationContext, translator, passed, invoiceType, forceUpload, wfDoc);
                        break;
                    }
                    case SUNCODE_OCR: {
                        this.documentProcessForSuncodeOcr(applicationContext, translator, passed, wfDoc, numberOfPages, configurationId);
                    }
                }
                if (documentSendingOmitted != null) {
                    documentSendingOmitted.setValue((Object)false);
                }
            }
        }
        catch (Exception e) {
            passed.setValue((Object)"error");
            this.createComment(applicationContext.getActivityId(), applicationContext.getProcessId(), translator.getMessage("application.string.error-occured") + " " + e.getMessage(), userInfo);
            log.error(e.getMessage(), (Throwable)e);
            throw new AcceptanceException((Throwable)e);
        }
    }

    private void documentProcessForSuncodeOcr(ApplicationContext applicationContext, Translator translator, Variable passed, WfDocument wfDocument, int numberOfPages, String configurationId) throws AcceptanceException {
        String activityId = applicationContext.getActivityId();
        String processId = applicationContext.getProcessId();
        try {
            SuncodeOcrConfigurationDto configurationDto = StringUtils.isBlank((CharSequence)configurationId) ? this.ocrConfigurationService.readConfigurationFile().getSuncodeOcr() : this.ocrConfigurationService.readConfigurationFile(configurationId).getSuncodeOcr();
            Optional<String> ocrRequestId = this.sendDocumentLoop(configurationDto, wfDocument.getFile());
            if (!ocrRequestId.isPresent()) {
                throw new AcceptanceException(translator.getMessage("application.error.suncodeocr.ocrRequestIdMissing"));
            }
            String ocrRequestIdValue = ocrRequestId.get();
            Optional<AnalyzeOperationDetails> immediateResult = this.fetchOcrDataLoop(configurationDto, ocrRequestIdValue, wfDocument.getFile());
            if (!immediateResult.isPresent()) {
                throw new AcceptanceException(translator.getMessage("application.error.suncodeocr.ocrRequestIdMissing"));
            }
            AnalyzeOperationDetails details = immediateResult.get();
            this.insertOcrDataRecord(details, processId, activityId, numberOfPages, configurationId);
            passed.setValue((Object)details.getResultId());
        }
        catch (ApiResponseFailedException | UnsupportedMimeTypeException | IOException e) {
            throw new AcceptanceException(String.format("Error sending document %s", wfDocument.getFile().getFileName()), (Throwable)e);
        }
    }

    @Transactional
    public void insertOcrDataRecord(AnalyzeOperationDetails details, String processId, String activityId, int pageCount, String configId) throws IOException {
        SuncodeOcrData suncodeOcrData = new SuncodeOcrData();
        suncodeOcrData.setOcrRequestId(details.getResultId());
        suncodeOcrData.setProcessId(processId);
        suncodeOcrData.setActivityId(activityId);
        suncodeOcrData.setCreatedAt(new Date());
        suncodeOcrData.setPageCount(pageCount);
        suncodeOcrData.setModelId(details.getAnalyzeResult() == null ? null : details.getAnalyzeResult().getModelId());
        suncodeOcrData.setPcmConfigId(configId);
        suncodeOcrData.setProcessed(false);
        suncodeOcrData.setDeleted(false);
        if (details.getStatus().equals((Object)DocumentIntelligenceOperationStatus.SUCCEEDED)) {
            suncodeOcrData.setOcrRequestId(details.getResultId());
            suncodeOcrData.setJsonContent(details.toJsonString());
            suncodeOcrData.setProcessed(true);
            suncodeOcrData.setProcessedAt(new Date());
            suncodeOcrData.setPageCountFromSuncodeOcr(details.getAnalyzeResult().getPages().size());
        }
        this.suncodeOcrDataService.save(suncodeOcrData);
    }

    private Optional<AnalyzeOperationDetails> fetchOcrDataLoop(SuncodeOcrConfigurationDto configurationDto, String requestId, WfFile file) throws IOException, ApiResponseFailedException, UnsupportedMimeTypeException {
        int maxTries = 3;
        int waitTimeMs = 2000;
        int currentRunNo = 0;
        try {
            while (++currentRunNo <= maxTries) {
                try {
                    Thread.sleep(waitTimeMs);
                    ResponseWrapper<AnalyzeOperationDetails> response = this.suncodeOcrService.getAnalyzeDocumentResult(configurationDto, requestId);
                    AnalyzeOperationDetails responseBody = response.getBody();
                    if (!responseBody.getStatus().equals((Object)DocumentIntelligenceOperationStatus.FAILED)) {
                        AnalyzeOperationDetailsHelper.setOperationId((AnalyzeOperationDetails)responseBody, (String)requestId);
                        return Optional.of(responseBody);
                    }
                    Optional<String> newRequestId = this.sendDocumentLoop(configurationDto, file);
                    if (!newRequestId.isPresent()) {
                        return Optional.empty();
                    }
                    requestId = newRequestId.get();
                }
                catch (ApiResponseFailedException response) {}
            }
            return Optional.empty();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
    }

    private Optional<String> sendDocumentLoop(SuncodeOcrConfigurationDto configurationDto, WfFile file) throws UnsupportedMimeTypeException, IOException {
        int maxTries = 3;
        int waitTimeMs = 3000;
        int currentRunNo = 0;
        try {
            while (++currentRunNo <= maxTries) {
                try {
                    ResponseWrapper<Void> response = this.suncodeOcrService.analyzeDocument(configurationDto, file);
                    return this.suncodeOcrService.extractOcrRequestId(response.getHeaders());
                }
                catch (ApiResponseFailedException e) {
                    Thread.sleep(waitTimeMs);
                }
            }
            return Optional.empty();
        }
        catch (InterruptedException | URISyntaxException e) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
    }

    private void documentProcessForSkanujTo(ApplicationContext applicationContext, Translator translator, Variable passed, Integer invoiceType, Boolean forceUpload, WfDocument wfDoc) throws Exception {
        String processId = applicationContext.getProcessId();
        OcrConfigurationDto ocrConfigurationDto = this.ocrConfigurationService.readConfigurationFile();
        SkanujToConfigurationDto skanujToConfig = ocrConfigurationDto.getSkanujTo();
        if (StringUtils.isBlank((CharSequence)skanujToConfig.getApiKey()) && StringUtils.isBlank((CharSequence)skanujToConfig.getPassword()) || StringUtils.isBlank((CharSequence)skanujToConfig.getApiUrl()) || StringUtils.isBlank((CharSequence)skanujToConfig.getLogin()) || StringUtils.isBlank((CharSequence)skanujToConfig.getCompanyId())) {
            throw new Exception("PlusOCR properties are not filled!");
        }
        SkanujToConnection skanujToConnection = new SkanujToConnection(ocrConfigurationDto);
        if (skanujToConnection.authorizeUser(ocrConfigurationDto)) {
            if (invoiceType == null) {
                invoiceType = -1;
            }
        } else {
            throw new AcceptanceException(translator.getMessage("application.error.auth-fail"));
        }
        String companyId = skanujToConfig.getCompanyId();
        long docId = skanujToConnection.sendDocumentToProceed(companyId, wfDoc, invoiceType, forceUpload);
        passed.setValue((Object)Long.toString(docId));
        OcrData data = new OcrData();
        data.setDocId(docId);
        data.setProcessId(processId);
        data.setActivityId(applicationContext.getActivityId());
        data.setProcessed(false);
        this.ocrDataService.save(data);
    }

    private void documentProcessForAlphamoon(ApplicationContext applicationContext, Translator translator, Variable passed, String alphamoonProcess, WfDocument wfDoc) throws AcceptanceException {
        String processId = applicationContext.getProcessId();
        Optional<String> collectionId = this.alphamoonService.sendDocumentToProceed(wfDoc, alphamoonProcess);
        if (!collectionId.isPresent()) {
            throw new AcceptanceException(translator.getMessage("application.error.alphamoon.collectionIdMissing"));
        }
        String collectionIdValue = collectionId.get();
        AlphamoonOcrData data = new AlphamoonOcrData();
        passed.setValue((Object)collectionIdValue);
        data.setCollectionId(collectionIdValue);
        data.setProcessId(processId);
        data.setActivityId(applicationContext.getActivityId());
        data.setProcessed(false);
        this.alphamoonOcrDataService.save(data);
    }

    private WfDocument getDocumentToProceed(String activityId, Translator translator, String[] documentClasses, String userInfo, String processId) throws AcceptanceException {
        ArrayList<Long> documentClassesIds = new ArrayList<Long>();
        for (String e : documentClasses) {
            documentClassesIds.add(this.docClassService.getDocumentClass(e, new String[0]).getId());
        }
        List wfDocs = this.documentFinder.getDocumentsFromProcess(processId, new String[0]);
        wfDocs.removeIf(wd -> !documentClassesIds.contains(wd.getDocumentClassId()));
        if (wfDocs.isEmpty()) {
            throw new AcceptanceException(translator.getMessage("application.error.no-doc-attached"));
        }
        WfDocument wfDoc = (WfDocument)wfDocs.get(wfDocs.size() - 1);
        if (wfDocs.size() > 1) {
            String comment = translator.getMessage("application.error.too-many-docs") + " " + wfDoc.getId();
            this.createComment(activityId, processId, comment, userInfo);
            log.info(comment);
        }
        return wfDoc;
    }

    private String getUserInfo() {
        return SystemProperties.getString((String)"Bufor.username") != null ? SystemProperties.getString((String)"Bufor.username") : "admin";
    }

    private void createComment(String activityId, String processId, String message, String username) {
        Comment comment = new Comment();
        comment.setActivityId(activityId);
        comment.setProcessId(processId);
        comment.setComment(message);
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        comment.setUserId(username);
        this.commentService.createComment(comment);
    }
}

