/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.service;

import com.azure.ai.documentintelligence.models.AnalyzeOperationDetails;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plusocr.pluginconfigurationmanager.dto.SuncodeOcrConfigurationDto;
import com.suncode.plusocr.suncodeocr.dto.OpenAIOcrKeyDto;
import com.suncode.plusocr.suncodeocr.dto.ResponseWrapper;
import com.suncode.plusocr.suncodeocr.dto.StructuredJsonData;
import com.suncode.plusocr.suncodeocr.exception.ApiResponseFailedException;
import com.suncode.plusocr.suncodeocr.exception.UnsupportedMimeTypeException;
import com.suncode.plusocr.suncodeocr.service.SuncodeOcrService;
import com.suncode.pwfl.archive.WfFile;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.tika.Tika;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SuncodeOcrServiceImpl
implements SuncodeOcrService {
    private static final Logger log = LoggerFactory.getLogger(SuncodeOcrServiceImpl.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final String DOCUMENT_CLASSIFIERS = "documentClassifiers";
    private static final String DOCUMENT_MODELS = "documentModels";
    private static final String CUSTOM_MODEL_ID = "custom-model";
    private static final String KEY_HEADER_NAME = "Ocp-Apim-Subscription-Key";
    private static final String API_VERSION = "2024-11-30";
    private static final String[] ALLOWED_MIME_TYPES = new String[]{"application/octet-stream", "application/pdf", "image/jpeg", "image/png", "image/tiff", "image/bmp", "image/heif", "text/html", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.presentationml.presentation"};
    private final OkHttpClient httpClient;
    private final Tika tika = new Tika();

    public SuncodeOcrServiceImpl() {
        this.httpClient = new OkHttpClient.Builder().readTimeout(180L, TimeUnit.SECONDS).writeTimeout(180L, TimeUnit.SECONDS).connectTimeout(180L, TimeUnit.SECONDS).build();
    }

    @Override
    public Optional<String> extractOcrRequestId(Map<String, List<String>> headers) {
        List<String> requestId = headers.get("apim-request-id");
        return requestId.stream().findFirst();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StructuredJsonData readExtraInvoiceFields(SuncodeOcrConfigurationDto configurationDto, String invoiceContent, Map<String, Object> knownInvoiceData, List<OpenAIOcrKeyDto> fieldDefinitions) {
        try {
            String apiKey = configurationDto.getApiKey();
            String endpoint = StringUtils.stripEnd((String)configurationDto.getEndpoint(), (String)"/");
            String fieldDefinitionsJson = OBJECT_MAPPER.writeValueAsString(fieldDefinitions);
            String knowDataJson = OBJECT_MAPPER.writeValueAsString(knownInvoiceData);
            FormBody.Builder formBuilder = new FormBody.Builder().add("invoiceContent", invoiceContent).add("fieldDefinitions", fieldDefinitionsJson).add("knownData", knowDataJson);
            Request request = new Request.Builder().url(endpoint + "/documentintelligence/readFieldsFromInvoiceContent").addHeader(CONTENT_TYPE_HEADER_NAME, "application/x-www-form-urlencoded").addHeader(KEY_HEADER_NAME, apiKey).post((RequestBody)formBuilder.build()).build();
            try (Response response = this.getResponse(this.httpClient, request);){
                if (!response.isSuccessful()) {
                    log.error(String.format("Response failed! Code: %s. Message: %s", response.code(), this.getErrorMessage(response)));
                    StructuredJsonData structuredJsonData2 = StructuredJsonData.builder().build();
                    return structuredJsonData2;
                }
                String jsonString = Objects.requireNonNull(response.body()).string();
                StructuredJsonData structuredJsonData = this.convertJSONToStructuredJsonData(jsonString);
                return structuredJsonData;
            }
        }
        catch (Exception e) {
            log.error("Error reading additional fields: {}", (Object)e.getMessage(), (Object)e);
            return StructuredJsonData.builder().build();
        }
    }

    private Response getResponse(OkHttpClient client, Request request) throws IOException, ApiResponseFailedException {
        Response response = client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new ApiResponseFailedException(String.format("Response failed! Code: %s. Message: %s", response.code(), this.getErrorMessage(response)));
        }
        return response;
    }

    @Override
    public StructuredJsonData convertJSONToStructuredJsonData(String jsonString) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return StructuredJsonData.builder().build();
        }
        Map stringObjectMap = (Map)OBJECT_MAPPER.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        HashMap<String, String> headerFields = new HashMap<String, String>();
        HashMap<String, List<Map<String, Object>>> tables = new HashMap<String, List<Map<String, Object>>>();
        for (Map.Entry entry : stringObjectMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                List rawList = (List)value;
                boolean validList = rawList.stream().allMatch(Map.class::isInstance);
                if (!validList) continue;
                List tableRows = (List)value;
                tables.put(key, tableRows);
                continue;
            }
            headerFields.put(key, value.toString());
        }
        return StructuredJsonData.builder().jsonRaw(jsonString).headerFields(headerFields).tables(tables).build();
    }

    @Override
    public ResponseWrapper<AnalyzeOperationDetails> getClassifyDocumentResult(SuncodeOcrConfigurationDto configurationDto, String requestId) throws ApiResponseFailedException {
        Request request = this.getResultRequest(configurationDto, DOCUMENT_CLASSIFIERS, requestId);
        return this.getResponseBody(this.httpClient, request, AnalyzeOperationDetails.class);
    }

    @Override
    public CompletableFuture<ResponseWrapper<AnalyzeOperationDetails>> asyncGetClassifyDocumentResult(SuncodeOcrConfigurationDto configurationDto, String requestId) {
        Request request = this.getResultRequest(configurationDto, DOCUMENT_CLASSIFIERS, requestId);
        return this.getAsyncResponseBody(this.httpClient, request, AnalyzeOperationDetails.class);
    }

    @Override
    public ResponseWrapper<AnalyzeOperationDetails> getAnalyzeDocumentResult(SuncodeOcrConfigurationDto configurationDto, String requestId) throws ApiResponseFailedException {
        Request request = this.getResultRequest(configurationDto, DOCUMENT_MODELS, requestId);
        return this.getResponseBody(this.httpClient, request, AnalyzeOperationDetails.class);
    }

    @Override
    public CompletableFuture<ResponseWrapper<AnalyzeOperationDetails>> asyncGetAnalyzeDocumentResult(SuncodeOcrConfigurationDto configurationDto, String requestId) {
        Request request = this.getResultRequest(configurationDto, DOCUMENT_MODELS, requestId);
        return this.getAsyncResponseBody(this.httpClient, request, AnalyzeOperationDetails.class);
    }

    @Override
    public ResponseWrapper<Void> classifyDocument(SuncodeOcrConfigurationDto configurationDto, WfFile wfFile, String split) throws UnsupportedMimeTypeException, ApiResponseFailedException, IOException, URISyntaxException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("api-version", API_VERSION);
        queryParams.put("split", split);
        Request request = this.getAnalyzeRequest(configurationDto, DOCUMENT_CLASSIFIERS, wfFile, queryParams);
        return this.getResponseHeaders(this.httpClient, request);
    }

    @Override
    public CompletableFuture<ResponseWrapper<Void>> asyncClassifyDocument(SuncodeOcrConfigurationDto configurationDto, WfFile wfFile, String split) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("api-version", API_VERSION);
        queryParams.put("split", split);
        Request request = this.getAnalyzeRequest(configurationDto, DOCUMENT_CLASSIFIERS, wfFile, queryParams);
        return this.getAsyncResponseHeaders(this.httpClient, request);
    }

    @Override
    public ResponseWrapper<Void> analyzeDocument(SuncodeOcrConfigurationDto configurationDto, WfFile wfFile) throws UnsupportedMimeTypeException, IOException, ApiResponseFailedException, URISyntaxException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("api-version", API_VERSION);
        Request request = this.getAnalyzeRequest(configurationDto, DOCUMENT_MODELS, wfFile, queryParams);
        return this.getResponseHeaders(this.httpClient, request);
    }

    @Override
    public CompletableFuture<ResponseWrapper<Void>> asyncAnalyzeDocument(SuncodeOcrConfigurationDto configurationDto, WfFile wfFile) throws UnsupportedMimeTypeException, IOException, URISyntaxException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("api-version", API_VERSION);
        Request request = this.getAnalyzeRequest(configurationDto, DOCUMENT_MODELS, wfFile, queryParams);
        return this.getAsyncResponseHeaders(this.httpClient, request);
    }

    @Override
    public String getModelId(SuncodeOcrConfigurationDto configurationDto) {
        return CUSTOM_MODEL_ID.equals(configurationDto.getModelId()) ? configurationDto.getCustomModelId() : configurationDto.getModelId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseWrapper<Void> getResponseHeaders(OkHttpClient client, Request request) throws ApiResponseFailedException {
        try (Response response = client.newCall(request).execute();){
            if (response.isSuccessful()) {
                ResponseWrapper<Object> responseWrapper = ResponseWrapper.builder().status(response.code()).headers(response.headers().toMultimap()).message(response.message()).body(null).build();
                return responseWrapper;
            }
            throw new ApiResponseFailedException(response.code(), this.getErrorMessage(response));
        }
        catch (IOException e) {
            throw new ApiResponseFailedException(500, e.getMessage());
        }
    }

    private CompletableFuture<ResponseWrapper<Void>> getAsyncResponseHeaders(OkHttpClient client, Request request) {
        final CompletableFuture<ResponseWrapper<Void>> future = new CompletableFuture<ResponseWrapper<Void>>();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    if (response.isSuccessful()) {
                        ResponseWrapper<Object> responseWrapper = ResponseWrapper.builder().status(response.code()).headers(response.headers().toMultimap()).message(response.message()).body(null).build();
                        future.complete(responseWrapper);
                    } else {
                        future.completeExceptionally(new ApiResponseFailedException(response.code(), SuncodeOcrServiceImpl.this.getErrorMessage(response)));
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ApiResponseFailedException(500, e.getMessage()));
                }
                finally {
                    response.close();
                }
            }
        });
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> ResponseWrapper<T> getResponseBody(OkHttpClient client, Request request, Class<T> clazz) throws ApiResponseFailedException {
        try (Response response = client.newCall(request).execute();){
            if (response.isSuccessful()) {
                ResponseWrapper<Object> responseWrapper = ResponseWrapper.builder().status(response.code()).headers(response.headers().toMultimap()).message(response.message()).body(BinaryData.fromString((String)Objects.requireNonNull(response.body()).string()).toObject(clazz)).build();
                return responseWrapper;
            }
            throw new ApiResponseFailedException(response.code(), this.getErrorMessage(response));
        }
        catch (IOException e) {
            throw new ApiResponseFailedException(500, e.getMessage());
        }
    }

    private <T> CompletableFuture<ResponseWrapper<T>> getAsyncResponseBody(OkHttpClient client, Request request, final Class<T> clazz) {
        final CompletableFuture<ResponseWrapper<T>> future = new CompletableFuture<ResponseWrapper<T>>();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    if (response.isSuccessful()) {
                        ResponseWrapper<Object> responseWrapper = ResponseWrapper.builder().status(response.code()).headers(response.headers().toMultimap()).message(response.message()).body(BinaryData.fromString((String)Objects.requireNonNull(response.body()).string()).toObject(clazz)).build();
                        future.complete(responseWrapper);
                    } else {
                        future.completeExceptionally(new ApiResponseFailedException(response.code(), SuncodeOcrServiceImpl.this.getErrorMessage(response)));
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ApiResponseFailedException(500, e.getMessage()));
                }
                finally {
                    response.close();
                }
            }
        });
        return future;
    }

    private String getMimeType(WfFile wfFile) throws IOException, UnsupportedMimeTypeException {
        File file = Paths.get(wfFile.getFullPath(), new String[0]).toFile();
        String mimeType = this.tika.detect(file);
        if (mimeType.equalsIgnoreCase("application/x-httpresponse")) {
            mimeType = "application/pdf";
        }
        String finalMimeType = mimeType;
        if (Arrays.stream(ALLOWED_MIME_TYPES).noneMatch(type -> type.equalsIgnoreCase(finalMimeType))) {
            throw new UnsupportedMimeTypeException(String.format("Unsupported MIME type: %s (%s)", mimeType, wfFile.getFileName()));
        }
        return mimeType;
    }

    private Request getAnalyzeRequest(SuncodeOcrConfigurationDto configurationDto, String analyzeOperator, WfFile wfFile, Map<String, String> queryParams) throws IOException, UnsupportedMimeTypeException, URISyntaxException {
        String apiKey = configurationDto.getApiKey();
        String modelId = this.getModelId(configurationDto);
        String baseEndpoint = StringUtils.stripEnd((String)configurationDto.getEndpoint(), (String)"/");
        String mimeType = this.getMimeType(wfFile);
        File file = new File(wfFile.getFullPath());
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((File)file, (MediaType)MediaType.parse((String)mimeType))).build();
        URIBuilder uriBuilder = new URIBuilder(baseEndpoint);
        String path = "/documentintelligence/{analyzeOperator}/{modelId}:analyze".replace("{analyzeOperator}", analyzeOperator).replace("{modelId}", modelId);
        uriBuilder.setPath(uriBuilder.getPath() + path);
        queryParams.forEach((arg_0, arg_1) -> ((URIBuilder)uriBuilder).addParameter(arg_0, arg_1));
        return new Request.Builder().url(uriBuilder.build().toString()).addHeader(CONTENT_TYPE_HEADER_NAME, "application/json").addHeader(KEY_HEADER_NAME, apiKey).post((RequestBody)requestBody).build();
    }

    private Request getResultRequest(SuncodeOcrConfigurationDto configurationDto, String resultOperator, String requestId) {
        String apiKey = configurationDto.getApiKey();
        String modelId = this.getModelId(configurationDto);
        String endpoint = StringUtils.stripEnd((String)configurationDto.getEndpoint(), (String)"/");
        return new Request.Builder().url(endpoint + "/documentintelligence/" + resultOperator + "/" + modelId + "/analyzeResults/" + requestId + "?api-version=" + API_VERSION).addHeader(CONTENT_TYPE_HEADER_NAME, "application/json").addHeader(KEY_HEADER_NAME, apiKey).get().build();
    }

    private String getErrorMessage(Response response) throws IOException {
        String message = response.message();
        ResponseBody body = response.body();
        if (body != null) {
            message = body.string();
        }
        return message;
    }
}

