/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.db.service;

import com.suncode.plusocr.suncodeocr.dao.ClassificationDataDao;
import com.suncode.plusocr.suncodeocr.db.ClassificationData;
import com.suncode.plusocr.suncodeocr.db.ResultOperationStatus;
import com.suncode.plusocr.suncodeocr.db.service.ClassificationDataService;
import com.suncode.pwfl.support.hibernate.criterion.Conjunction;
import com.suncode.pwfl.support.hibernate.criterion.Criterion;
import com.suncode.pwfl.support.hibernate.criterion.Disjunction;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ClassificationDataServiceImpl
extends EditableServiceImpl<ClassificationData, Long, ClassificationDataDao>
implements ClassificationDataService {
    private static final Logger log = LoggerFactory.getLogger(ClassificationDataServiceImpl.class);

    @Autowired
    public void setDao(ClassificationDataDao dao) {
        this.dao = dao;
    }

    @Override
    public List<ClassificationData> findByFileIds(List<Long> fileIds) {
        HibernateCriteria criteria = HibernateCriteria.forClass(ClassificationData.class);
        criteria.add(Restrictions.in((String)"fileId", fileIds));
        return ((ClassificationDataDao)this.dao).findByCriteria(criteria);
    }

    @Override
    public List<ClassificationData> findProcessedByFileId(List<Long> fileIds) {
        HibernateCriteria criteria = HibernateCriteria.forClass(ClassificationData.class);
        criteria.add(Restrictions.in((String)"fileId", fileIds));
        Conjunction statusCondition = Restrictions.conjunction();
        statusCondition.add(Restrictions.ne((String)"operationStatus", (Object)((Object)ResultOperationStatus.NOT_STARTED)));
        statusCondition.add(Restrictions.ne((String)"operationStatus", (Object)((Object)ResultOperationStatus.RUNNING)));
        criteria.add((Criterion)statusCondition);
        return ((ClassificationDataDao)this.dao).findByCriteria(criteria);
    }

    @Override
    public List<ClassificationData> findUnprocessedByFileIds(List<Long> fileIds) {
        HibernateCriteria criteria = HibernateCriteria.forClass(ClassificationData.class);
        criteria.add(Restrictions.in((String)"fileId", fileIds));
        Disjunction statusCondition = Restrictions.disjunction();
        statusCondition.add(Restrictions.eq((String)"operationStatus", (Object)((Object)ResultOperationStatus.NOT_STARTED)));
        statusCondition.add(Restrictions.eq((String)"operationStatus", (Object)((Object)ResultOperationStatus.RUNNING)));
        criteria.add((Criterion)statusCondition);
        return ((ClassificationDataDao)this.dao).findByCriteria(criteria);
    }

    @Override
    public List<ClassificationData> findUnprocessedByRequestIds(List<String> requestIds) {
        HibernateCriteria criteria = HibernateCriteria.forClass(ClassificationData.class);
        criteria.add(Restrictions.in((String)"ocrRequestId", requestIds));
        Disjunction statusCondition = Restrictions.disjunction();
        statusCondition.add(Restrictions.eq((String)"operationStatus", (Object)((Object)ResultOperationStatus.NOT_STARTED)));
        statusCondition.add(Restrictions.eq((String)"operationStatus", (Object)((Object)ResultOperationStatus.RUNNING)));
        criteria.add((Criterion)statusCondition);
        return ((ClassificationDataDao)this.dao).findByCriteria(criteria);
    }

    @Override
    public void removeExistingByFileIds(List<Long> fileIds) {
        List<ClassificationData> existingData = this.findByFileIds(fileIds);
        existingData.forEach(data -> ((ClassificationDataDao)this.dao).delete(data));
    }

    @Override
    public List<ClassificationData> findByFileId(Long fileId) {
        HibernateCriteria criteria = HibernateCriteria.forClass(ClassificationData.class);
        criteria.add(Restrictions.eq((String)"fileId", (Object)fileId));
        return ((ClassificationDataDao)this.dao).findByCriteria(criteria);
    }
}

