/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.db;

import com.suncode.plusocr.suncodeocr.db.ClassificationDataItem;
import com.suncode.plusocr.suncodeocr.db.ResultOperationStatus;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="pm_ocr_suncode_ocr_classification_data")
@SequenceGenerator(name="pm_ocr_suncode_ocr_classification_data_seq", sequenceName="pm_ocr_suncode_ocr_classification_data_seq")
public class ClassificationData {
    public static final String TABLE_NAME = "pm_ocr_suncode_ocr_classification_data";
    public static final String SEQUENCE_NAME = "pm_ocr_suncode_ocr_classification_data_seq";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_ocr_suncode_ocr_classification_data_seq")
    private Long id;
    @Column(name="ocr_request_id")
    private String ocrRequestId;
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    private ResultOperationStatus operationStatus;
    @Column(name="created_at")
    private LocalDate createdAt;
    @Column(name="updated_at")
    private LocalDate updatedAt;
    @Column(name="file_id")
    private Long fileId;
    @Lob
    @Column(name="content")
    private String jsonContent;
    @Column(name="page_count")
    private Integer pageCount;
    @Column(name="page_count_from_suncode_ocr")
    private Integer pageCountFromSuncodeOcr;
    @Column(name="pcm_config")
    private String pcmConfig;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="classificationData")
    private List<ClassificationDataItem> classificationDataItems = new ArrayList<ClassificationDataItem>();

    public static ClassificationDataBuilder builder() {
        return new ClassificationDataBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getOcrRequestId() {
        return this.ocrRequestId;
    }

    public ResultOperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    public LocalDate getCreatedAt() {
        return this.createdAt;
    }

    public LocalDate getUpdatedAt() {
        return this.updatedAt;
    }

    public Long getFileId() {
        return this.fileId;
    }

    public String getJsonContent() {
        return this.jsonContent;
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public Integer getPageCountFromSuncodeOcr() {
        return this.pageCountFromSuncodeOcr;
    }

    public String getPcmConfig() {
        return this.pcmConfig;
    }

    public List<ClassificationDataItem> getClassificationDataItems() {
        return this.classificationDataItems;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOcrRequestId(String ocrRequestId) {
        this.ocrRequestId = ocrRequestId;
    }

    public void setOperationStatus(ResultOperationStatus operationStatus) {
        this.operationStatus = operationStatus;
    }

    public void setCreatedAt(LocalDate createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDate updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public void setJsonContent(String jsonContent) {
        this.jsonContent = jsonContent;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public void setPageCountFromSuncodeOcr(Integer pageCountFromSuncodeOcr) {
        this.pageCountFromSuncodeOcr = pageCountFromSuncodeOcr;
    }

    public void setPcmConfig(String pcmConfig) {
        this.pcmConfig = pcmConfig;
    }

    public void setClassificationDataItems(List<ClassificationDataItem> classificationDataItems) {
        this.classificationDataItems = classificationDataItems;
    }

    public ClassificationData() {
    }

    public ClassificationData(Long id, String ocrRequestId, ResultOperationStatus operationStatus, LocalDate createdAt, LocalDate updatedAt, Long fileId, String jsonContent, Integer pageCount, Integer pageCountFromSuncodeOcr, String pcmConfig, List<ClassificationDataItem> classificationDataItems) {
        this.id = id;
        this.ocrRequestId = ocrRequestId;
        this.operationStatus = operationStatus;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.fileId = fileId;
        this.jsonContent = jsonContent;
        this.pageCount = pageCount;
        this.pageCountFromSuncodeOcr = pageCountFromSuncodeOcr;
        this.pcmConfig = pcmConfig;
        this.classificationDataItems = classificationDataItems;
    }

    public static class ClassificationDataBuilder {
        private Long id;
        private String ocrRequestId;
        private ResultOperationStatus operationStatus;
        private LocalDate createdAt;
        private LocalDate updatedAt;
        private Long fileId;
        private String jsonContent;
        private Integer pageCount;
        private Integer pageCountFromSuncodeOcr;
        private String pcmConfig;
        private List<ClassificationDataItem> classificationDataItems;

        ClassificationDataBuilder() {
        }

        public ClassificationDataBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ClassificationDataBuilder ocrRequestId(String ocrRequestId) {
            this.ocrRequestId = ocrRequestId;
            return this;
        }

        public ClassificationDataBuilder operationStatus(ResultOperationStatus operationStatus) {
            this.operationStatus = operationStatus;
            return this;
        }

        public ClassificationDataBuilder createdAt(LocalDate createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public ClassificationDataBuilder updatedAt(LocalDate updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ClassificationDataBuilder fileId(Long fileId) {
            this.fileId = fileId;
            return this;
        }

        public ClassificationDataBuilder jsonContent(String jsonContent) {
            this.jsonContent = jsonContent;
            return this;
        }

        public ClassificationDataBuilder pageCount(Integer pageCount) {
            this.pageCount = pageCount;
            return this;
        }

        public ClassificationDataBuilder pageCountFromSuncodeOcr(Integer pageCountFromSuncodeOcr) {
            this.pageCountFromSuncodeOcr = pageCountFromSuncodeOcr;
            return this;
        }

        public ClassificationDataBuilder pcmConfig(String pcmConfig) {
            this.pcmConfig = pcmConfig;
            return this;
        }

        public ClassificationDataBuilder classificationDataItems(List<ClassificationDataItem> classificationDataItems) {
            this.classificationDataItems = classificationDataItems;
            return this;
        }

        public ClassificationData build() {
            return new ClassificationData(this.id, this.ocrRequestId, this.operationStatus, this.createdAt, this.updatedAt, this.fileId, this.jsonContent, this.pageCount, this.pageCountFromSuncodeOcr, this.pcmConfig, this.classificationDataItems);
        }

        public String toString() {
            return "ClassificationData.ClassificationDataBuilder(id=" + this.id + ", ocrRequestId=" + this.ocrRequestId + ", operationStatus=" + (Object)((Object)this.operationStatus) + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", fileId=" + this.fileId + ", jsonContent=" + this.jsonContent + ", pageCount=" + this.pageCount + ", pageCountFromSuncodeOcr=" + this.pageCountFromSuncodeOcr + ", pcmConfig=" + this.pcmConfig + ", classificationDataItems=" + this.classificationDataItems + ")";
        }
    }
}

