/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.controller;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Sorter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/document"})
public class SuncodeOcrDocumentController {
    private static final Logger log = LoggerFactory.getLogger(SuncodeOcrDocumentController.class);
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentClassIndexFinder indexFinder;

    @RequestMapping(value={"classes"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentClasses(@RequestParam(required=false) String query, @RequestParam Integer start, @RequestParam Integer limit) {
        List classes = this.documentClassService.getAll(new String[0]).stream().filter(documentClass -> StringUtils.isBlank((CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)documentClass.getName(), (CharSequence)query)).map(documentClass -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", documentClass.getName());
            return map;
        }).collect(Collectors.toList());
        return this.getSublist(classes, start, limit);
    }

    @RequestMapping(value={"indices/{className}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentClassIndexes(@PathVariable(value="className") String className, @RequestParam(required=false) String query, @RequestParam Integer start, @RequestParam Integer limit) {
        DocumentClass documentClass = this.documentClassService.getDocumentClass(className, new String[0]);
        if (documentClass == null) {
            return new CountedResult();
        }
        Long documentClassId = documentClass.getId();
        List indices = this.indexFinder.findByDocumentClass(documentClassId, new Sorter("name")).stream().filter(index -> StringUtils.isBlank((CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)index.getName(), (CharSequence)query)).map(index -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", index.getName());
            return map;
        }).collect(Collectors.toList());
        return this.getSublist(indices, start, limit);
    }

    private <T> CountedResult<T> getSublist(List<T> data, int start, int limit) {
        int to = Math.min(start + limit, data.size());
        return new CountedResult((long)data.size(), data.subList(start, to));
    }
}

