/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.controller;

import com.suncode.plusocr.suncodeocr.db.service.ClassificationDataService;
import com.suncode.plusocr.suncodeocr.domain.OcrKey;
import com.suncode.plusocr.suncodeocr.domain.OpenAIOcrKey;
import com.suncode.plusocr.suncodeocr.domain.SuncodeOcrKey;
import com.suncode.plusocr.suncodeocr.domain.SuncodeOcrModel;
import com.suncode.plusocr.suncodeocr.dto.ClassifyDocumentsRequestDto;
import com.suncode.plusocr.suncodeocr.dto.OpenAIOcrKeyDto;
import com.suncode.plusocr.suncodeocr.service.ClassificationService;
import com.suncode.pwfl.core.data.TableStore;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/suncodeOcr"})
public class SuncodeOcrController {
    private static final Logger log = LoggerFactory.getLogger(SuncodeOcrController.class);
    private static Translator translator;
    @Autowired
    private ClassificationService classificationService;
    @Autowired
    private ClassificationDataService classificationDataService;

    @ResponseBody
    @RequestMapping(value={"models"}, method={RequestMethod.GET})
    public List<String> getSuncodeOcrModels() {
        return SuncodeOcrModel.stream().map(SuncodeOcrModel::getId).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"keys"}, method={RequestMethod.GET})
    public CountedResult<Map<String, String>> getSuncodeOcrFormKeys(@RequestParam String query, @RequestParam int start, @RequestParam int limit) {
        List<Map<String, String>> data = this.getOcrKeyList(key -> StringUtils.containsIgnoreCase((CharSequence)key.getKey(), (CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)key.getDescription(), (CharSequence)query), SuncodeOcrKey.class);
        List openAiOcrKeys = OpenAIOcrKey.basicFields.stream().map(SuncodeOcrController::mapToOcrKey).filter(map -> this.filterSuncodeOCRKeys((Map<String, String>)map, query)).collect(Collectors.toList());
        data.addAll(openAiOcrKeys);
        return this.getMapCountedResult(data, start, limit);
    }

    private boolean filterSuncodeOCRKeys(Map<String, String> map, String query) {
        return StringUtils.isBlank((CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)map.get("key"), (CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)map.get("description"), (CharSequence)query);
    }

    @ResponseBody
    @RequestMapping(value={"/classification/data"}, method={RequestMethod.POST})
    public String getClassificationData(@RequestBody ClassifyDocumentsRequestDto classifyDocumentsRequestDto) throws InterruptedException, IOException {
        TableStore tableStore = this.classificationService.processAndCreateTableStore(classifyDocumentsRequestDto);
        return tableStore.toJson();
    }

    private <T extends Enum<T>> List<Map<String, String>> getOcrKeyList(Predicate<T> queryFilter, Class<T> clazz) {
        return OcrKey.stream(clazz).filter(queryFilter).map(x$0 -> this.mapToOcrKey((OcrKey)x$0)).collect(Collectors.toList());
    }

    private Map<String, String> mapToOcrKey(OcrKey key) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("key", key.getKey());
        map.put("type", key.getType().name().toUpperCase());
        map.put("description", key.getDescription());
        return map;
    }

    private static Map<String, String> mapToOcrKey(OpenAIOcrKeyDto key) {
        if (null == translator) {
            translator = Translators.get(SuncodeOcrController.class);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("key", key.getName());
        map.put("type", key.getTargetType().name().toUpperCase());
        map.put("description", translator.getMessage(key.getDescriptionKey()));
        return map;
    }

    private CountedResult<Map<String, String>> getMapCountedResult(List<Map<String, String>> data, int from, int limit) {
        int to = Math.min(from + limit, data.size());
        return new CountedResult((long)data.size(), data.subList(from, to));
    }
}

