/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.autotask;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.suncode.plusocr.Categories;
import com.suncode.plusocr.suncodeocr.db.SuncodeOcrData;
import com.suncode.plusocr.suncodeocr.db.service.SuncodeOcrDataService;
import com.suncode.plusocr.suncodeocr.domain.OcrKey;
import com.suncode.plusocr.suncodeocr.domain.OpenAIOcrKey;
import com.suncode.plusocr.suncodeocr.domain.SuncodeOcrKey;
import com.suncode.plusocr.suncodeocr.service.OpenAIDataProcessingService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Application
@ComponentsFormScript(value="/scripts/dynamic-pwe/autotasks/suncode-ocr-process-mapping.js")
public class SuncodeOcrProcessMapping {
    private static final Logger log = LoggerFactory.getLogger(SuncodeOcrProcessMapping.class);
    private static final String COMPONENT_ID = "plusocr.suncodeocr.autotask.SuncodeOcrProcessMapping";
    @Autowired
    private SuncodeOcrDataService dataService;
    @Autowired
    private OpenAIDataProcessingService openAIDataProcessingService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(COMPONENT_ID)).name(COMPONENT_ID.concat(".name"))).description(COMPONENT_ID.concat(".desc"))).category(new Category[]{Categories.SCANNING})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("interrupt").name(COMPONENT_ID.concat(".param.interrupt.name")).description(COMPONENT_ID.concat(".param.interrupt.name")).type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("valueVariable").name(COMPONENT_ID.concat(".param.valueVariable.name")).description(COMPONENT_ID.concat(".param.valueVariable.desc")).type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("suncodeOcrKey").name(COMPONENT_ID.concat(".param.suncodeOcrKey.name")).description(COMPONENT_ID.concat(".param.suncodeOcrKey.desc")).type((Type)Types.STRING_ARRAY).create()).parameter().id("functionVariable").name(COMPONENT_ID.concat(".param.functionVariable.name")).description(COMPONENT_ID.concat(".param.functionVariable.desc")).type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("suncodeOcrFunctionKey").name(COMPONENT_ID.concat(".param.suncodeOcrFunctionKey.name")).description(COMPONENT_ID.concat(".param.suncodeOcrFunctionKey.desc")).type((Type)Types.FUNCTION_ARRAY).optional().create()).parameter().id("extraFieldVariable").name(COMPONENT_ID.concat(".param.extraFieldVariable.name")).description(COMPONENT_ID.concat(".param.extraFieldVariable.desc")).type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("extraFieldsKey").name(COMPONENT_ID.concat(".param.extraFieldsKey.name")).description(COMPONENT_ID.concat(".param.extraFieldsKey.desc")).type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("extraFieldEnums").name(COMPONENT_ID.concat(".param.extraFieldEnums.name")).description(COMPONENT_ID.concat(".param.extraFieldEnums.desc")).type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("extraFieldPattern").name(COMPONENT_ID.concat(".param.extraFieldPattern.name")).description(COMPONENT_ID.concat(".param.extraFieldPattern.desc")).type((Type)Types.FUNCTION_ARRAY).optional().create()).parameter().id("forceOpenAiInvoiceLineReading").name(COMPONENT_ID.concat(".param.forceOpenAiInvoiceLineReading.name")).description(COMPONENT_ID.concat(".param.forceOpenAiInvoiceLineReading.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("openAiLineThreshold").name(COMPONENT_ID.concat(".param.openAiLineThreshold.name")).description(COMPONENT_ID.concat(".param.openAiLineThreshold.desc")).type((Type)Types.INTEGER).defaultValue((Object)30).create();
        this.addContextVariables(builder);
    }

    private void addContextVariables(ApplicationDefinitionBuilder builder) {
        OcrKey.stream(SuncodeOcrKey.class).forEach(suncodeOcrKey -> builder.contextVariable().id(suncodeOcrKey.getKey()).name(suncodeOcrKey.getKey()).description(suncodeOcrKey.getDescriptionKey()).type(suncodeOcrKey.getType()).create());
        OpenAIOcrKey.basicFields.stream().forEach(openAIOcrKey -> builder.contextVariable().id(openAIOcrKey.getId()).name(openAIOcrKey.getName()).description(openAIOcrKey.getDescriptionKey()).type(openAIOcrKey.getTargetType()).create());
    }

    public void execute(ApplicationContext applicationContext, ContextVariables contextVariables, @Param Boolean interrupt, @PairedParam(key="valueVariable", value="suncodeOcrKey") Map<Variable, String> valueParams, @PairedParam(key="functionVariable", value="suncodeOcrFunctionKey") Map<Variable, FunctionCall> functionParams, @Param Variable[] extraFieldVariable, @Param String[] extraFieldsKey, @Param String[] extraFieldEnums, @Param FunctionCall[] extraFieldPattern, @Param Boolean forceOpenAiInvoiceLineReading, @Param Integer openAiLineThreshold) throws AcceptanceException {
        try {
            Assert.isTrue((boolean)this.areSameLength(extraFieldVariable, extraFieldsKey, extraFieldEnums, extraFieldPattern), (String)"Incorrect array length (extraFieldVariable, extraFieldsKey, extraFieldEnums, extraFieldPattern)");
            SuncodeOcrData suncodeOcrData = (SuncodeOcrData)this.dataService.get(applicationContext.getProcessId());
            if (suncodeOcrData == null) {
                return;
            }
            String jsonContent = suncodeOcrData.getJsonContent();
            if (StringUtils.isBlank((CharSequence)jsonContent)) {
                return;
            }
            DocumentContext documentContext = JsonPath.parse((String)jsonContent);
            Map<String, Object> extractedOcrData = this.extractOcrData(documentContext, interrupt);
            Map<String, Object> openAiData = this.openAIDataProcessingService.processOpenAiData(documentContext, new ArrayList<String>(valueParams.values()), extraFieldsKey, extraFieldVariable, extraFieldEnums, extraFieldPattern, extractedOcrData, suncodeOcrData, functionParams, forceOpenAiInvoiceLineReading, openAiLineThreshold);
            extractedOcrData.putAll(openAiData);
            this.setContextVariables(contextVariables, extractedOcrData);
            valueParams.forEach((variable, suncodeOcrKey) -> variable.setValue(extractedOcrData.get(suncodeOcrKey)));
            functionParams.forEach((variable, suncodeOcrFunctionKey) -> variable.setValue(suncodeOcrFunctionKey.call()));
            IntStream.range(0, extraFieldVariable.length).forEach(i -> extraFieldVariable[i].setValue(openAiData.getOrDefault(extraFieldsKey[i], extraFieldVariable[i].getType().defaultValue())));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new AcceptanceException((Throwable)e);
        }
    }

    private Map<String, Object> extractOcrData(DocumentContext documentContext, Boolean interrupt) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        OcrKey.stream(SuncodeOcrKey.class).forEach(suncodeOcrKey -> {
            block2: {
                try {
                    data.put(suncodeOcrKey.getKey(), suncodeOcrKey.getValue(documentContext));
                }
                catch (Exception e) {
                    log.warn("Problem reading key! Key: {}", (Object)suncodeOcrKey.getKey());
                    log.warn(e.getMessage());
                    if (!Boolean.TRUE.equals(interrupt)) break block2;
                    throw e;
                }
            }
        });
        return data;
    }

    private void setContextVariables(ContextVariables contextVariables, Map<String, Object> data) {
        OcrKey.stream(SuncodeOcrKey.class).forEach(suncodeOcrKey -> {
            Object value = data.get(suncodeOcrKey.getKey());
            try {
                contextVariables.set(suncodeOcrKey.getKey(), value == null ? suncodeOcrKey.getType().defaultValue() : value);
            }
            catch (Exception e) {
                log.error("Error setting context variable value! Variable: '{}'. Value: {} ", (Object)suncodeOcrKey.getKey(), value);
                log.error(e.getMessage());
            }
        });
        OpenAIOcrKey.basicFields.stream().forEach(openAIOcrKey -> {
            Object value = data.get(openAIOcrKey.getName());
            try {
                contextVariables.set(openAIOcrKey.getId(), value == null ? openAIOcrKey.getTargetType().defaultValue() : value);
            }
            catch (Exception e) {
                log.error("Error setting context variable value! Variable: '{}'. Value: {} ", (Object)openAIOcrKey.getId(), value);
                log.error(e.getMessage());
            }
        });
    }

    private boolean areSameLength(Object[] ... arrays) {
        return Stream.of(arrays).allMatch(array -> ((Object[])array).length == arrays[0].length);
    }
}

