/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.autotask;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plusocr.Categories;
import com.suncode.plusocr.suncodeocr.service.ClassificationService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Application
@ComponentsFormScript(value="/scripts/dynamic-pwe/autotasks/split-document-by-types.js")
public class SplitDocumentByTypes {
    private static final Logger log = LoggerFactory.getLogger(SplitDocumentByTypes.class);
    private static final String COMPONENT_ID = "plusocr.suncodeocr.autotask.SplitDocumentByTypes";
    private static final int MAX_THREADS = 4;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private ClassificationService classificationService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(COMPONENT_ID)).name(COMPONENT_ID.concat(".name"))).description(COMPONENT_ID.concat(".desc"))).category(new Category[]{Categories.SCANNING})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("fileId").name(COMPONENT_ID.concat(".param.fileId.name")).description(COMPONENT_ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER).create()).parameter().id("documentClassName").name(COMPONENT_ID.concat(".param.documentClassName.name")).description(COMPONENT_ID.concat(".param.documentClassName.desc")).type((Type)Types.STRING).create()).parameter().id("typeIndexName").name(COMPONENT_ID.concat(".param.typeIndexName.name")).description(COMPONENT_ID.concat(".param.typeIndexName.desc")).type((Type)Types.STRING).create()).parameter().id("indexName").name(COMPONENT_ID.concat(".param.indexName.name")).type((Type)Types.STRING_ARRAY).create()).parameter().id("indexValue").name(COMPONENT_ID.concat(".param.indexValue.name")).type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("executeDocumentClassActions").name(COMPONENT_ID.concat(".param.executeDocumentClassActions.name")).description(COMPONENT_ID.concat(".param.executeDocumentClassActions.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("processId").name(COMPONENT_ID.concat(".param.processId.name")).description(COMPONENT_ID.concat(".param.processId.desc")).type((Type)Types.STRING).optional().create()).parameter().id("activityId").name(COMPONENT_ID.concat(".param.activityId.name")).description(COMPONENT_ID.concat(".param.activityId.desc")).type((Type)Types.STRING).optional().create()).parameter().id("removeSourceDocument").name(COMPONENT_ID.concat(".param.removeSourceDocument.name")).description(COMPONENT_ID.concat(".param.removeSourceDocument.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("continueOnError").name(COMPONENT_ID.concat(".param.continueOnError.name")).description(COMPONENT_ID.concat(".param.continueOnError.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create();
    }

    public void execute(@Param Long fileId, @Param String documentClassName, @Param String typeIndexName, @PairedParam(key="indexName", value="indexValue") Map<String, Variable> indexMappings, @Param Boolean executeDocumentClassActions, @Param String processId, @Param String activityId, @Param Boolean removeSourceDocument, @Param Boolean continueOnError) throws AcceptanceException {
        DocumentClass documentClass = this.documentClassService.getDocumentClass(documentClassName, new String[]{"indexes"});
        Assert.notNull((Object)documentClass, (String)"Document class does not exist");
        WfDocument wfDocument = this.documentService.getDocument(fileId);
        Assert.notNull((Object)wfDocument, (String)"Document does not exist");
        DocumentClassIndex typeIndex = documentClass.getIndexes().stream().filter(index -> index.getName().equals(typeIndexName)).findAny().orElseThrow(() -> new IllegalArgumentException("Type index not found"));
        List<PageRange> ranges = this.classificationService.getRanges(fileId);
        try {
            String inputFile = wfDocument.getFile().getFullPath();
            List<PdfPart> pdfParts = this.splitPdfFile(inputFile, ranges, 4);
            if (!continueOnError.booleanValue() && pdfParts.stream().anyMatch(pdfPart -> pdfPart.failed)) {
                throw new AcceptanceException("Error processing one of the pages");
            }
            Map<Long, Object> indices = this.fillIndicesMap(indexMappings, documentClass);
            pdfParts.forEach(pdfPart -> {
                indices.put(typeIndex.getId(), pdfPart.type);
                DocumentDefinition documentDefinition = this.createDocumentDefinition(documentClass.getId(), pdfPart.filename, pdfPart.bytes, processId, activityId, indices);
                this.documentService.addDocument(documentDefinition);
                if (executeDocumentClassActions.booleanValue()) {
                    this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
                }
            });
            if (removeSourceDocument.booleanValue()) {
                this.documentService.deleteDocument(wfDocument);
            }
        }
        catch (IOException e) {
            throw new AcceptanceException("Error processing file: " + e.getMessage(), (Throwable)e);
        }
    }

    private Map<Long, Object> fillIndicesMap(Map<String, Variable> indexMappings, DocumentClass documentClass) {
        return documentClass.getIndexes().stream().filter(index -> indexMappings.containsKey(index.getName())).collect(HashMap::new, (map, index) -> map.put(index.getId(), ((Variable)indexMappings.get(index.getName())).getValue()), HashMap::putAll);
    }

    private DocumentDefinition createDocumentDefinition(long documentClassId, String filename, byte[] documentBytes, String processId, String activityId, Map<Long, Object> indices) {
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setDocumentClassId(Long.valueOf(documentClassId));
        documentDefinition.setFileName(filename);
        documentDefinition.setUserName("admin");
        documentDefinition.setInputStream((InputStream)new ByteArrayInputStream(documentBytes));
        documentDefinition.setSaveAsNewVersion(false);
        if (StringUtils.isNotBlank((CharSequence)processId)) {
            documentDefinition.setProcessId(processId);
            if (StringUtils.isNotBlank((CharSequence)activityId)) {
                documentDefinition.setActivityId(activityId);
            }
        }
        documentDefinition.setIndexes(indices);
        return documentDefinition;
    }

    private List<PdfPart> splitPdfFile(String inputfilePath, List<PageRange> ranges, int maxThreads) throws IOException {
        ExecutorService executor = Executors.newFixedThreadPool(maxThreads);
        File inputFile = new File(inputfilePath);
        String inputFilename = FilenameUtils.removeExtension((String)inputFile.getName());
        List futures = IntStream.range(0, ranges.size()).mapToObj(index -> {
            PageRange range = (PageRange)ranges.get(index);
            return executor.submit(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.getAnalysis(Method.java:520)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:351)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }).collect(Collectors.toList());
        List<PdfPart> results = IntStream.range(0, futures.size()).mapToObj(index -> {
            Future future = (Future)futures.get(index);
            try {
                return (PdfPart)future.get();
            }
            catch (Exception e) {
                log.warn("Error retrieving page: {}", (Object)e.getMessage());
                return PdfPart.failed(index);
            }
        }).collect(Collectors.toList());
        executor.shutdown();
        return results;
    }

    public static class PdfPart {
        int index;
        String filename;
        byte[] bytes;
        String type;
        double confidence;
        boolean failed;

        public PdfPart(int index, String filename, byte[] bytes, String type, double confidence) {
            this.index = index;
            this.filename = filename;
            this.bytes = bytes;
            this.type = type;
            this.confidence = confidence;
            this.failed = false;
        }

        static PdfPart failed(int index) {
            PdfPart failedPart = new PdfPart(index, null, null, null, 0.0);
            failedPart.failed = true;
            return failedPart;
        }
    }

    public static class PageRange {
        int start;
        int end;
        String type;
        double confidence;

        public PageRange(int start, int end, String type, double confidence) {
            this.start = start;
            this.end = end;
            this.type = type;
            this.confidence = confidence;
        }
    }
}

