/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.autotask;

import com.suncode.plusocr.Categories;
import com.suncode.plusocr.suncodeocr.enums.SplitMode;
import com.suncode.plusocr.suncodeocr.service.ClassificationService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Application
@ComponentsFormScript(value="/scripts/dynamic-pwe/autotasks/document-classification.js")
public class DocumentClassification {
    private static final Logger log = LoggerFactory.getLogger(DocumentClassification.class);
    private static final String COMPONENT_ID = "plusocr.suncodeocr.autotask.DocumentClassification";
    @Autowired
    private ClassificationService classificationService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(COMPONENT_ID)).name(COMPONENT_ID.concat(".name"))).description(COMPONENT_ID.concat(".desc"))).category(new Category[]{Categories.SCANNING})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("fileId").name(COMPONENT_ID.concat(".param.fileId.name")).description(COMPONENT_ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER_ARRAY).arrayMinLength(1).create()).parameter().id("configurationId").name(COMPONENT_ID.concat(".param.configurationId.name")).description(COMPONENT_ID.concat(".param.configurationId.desc")).type((Type)Types.STRING).create()).parameter().id("split").name(COMPONENT_ID.concat(".param.split.name")).description(COMPONENT_ID.concat(".param.split.desc")).type((Type)Types.STRING).defaultValue((Object)SplitMode.NONE.name()).create();
    }

    public void execute(@Param Long[] fileId, @Param String configurationId, @Param String split) throws AcceptanceException {
        if (fileId.length == 0) {
            return;
        }
        try {
            SplitMode splitMode = SplitMode.valueOf(split);
            this.classificationService.createRequests(configurationId, Arrays.asList(fileId), false, splitMode);
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }
}

