/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.autotask;

import com.suncode.plusocr.Categories;
import com.suncode.plusocr.suncodeocr.db.ClassificationDataItem;
import com.suncode.plusocr.suncodeocr.db.service.ClassificationDataService;
import com.suncode.plusocr.suncodeocr.service.ClassificationService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Application
public class ClassificationProcessMapping {
    private static final Logger log = LoggerFactory.getLogger(ClassificationProcessMapping.class);
    private static final String COMPONENT_ID = "plusocr.suncodeocr.autotask.ClassificationProcessMapping";
    @Autowired
    private ClassificationDataService dataService;
    @Autowired
    private ClassificationService classificationService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(COMPONENT_ID)).name(COMPONENT_ID.concat(".name"))).description(COMPONENT_ID.concat(".desc"))).category(new Category[]{Categories.SCANNING})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("fileId").name(COMPONENT_ID.concat(".param.fileId.name")).description(COMPONENT_ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER_ARRAY).arrayMinLength(1).create()).parameter().id("typeVariable").name(COMPONENT_ID.concat(".param.typeVariable.name")).description(COMPONENT_ID.concat(".param.typeVariable.desc")).type((Type)Types.VARIABLE).create()).parameter().id("confidenceVariable").name(COMPONENT_ID.concat(".param.confidenceVariable.name")).description(COMPONENT_ID.concat(".param.confidenceVariable.desc")).type((Type)Types.VARIABLE).create();
    }

    public void execute(@Param Long[] fileId, @Param Variable typeVariable, @Param Variable confidenceVariable) throws AcceptanceException {
        if (fileId.length == 0) {
            return;
        }
        if (!typeVariable.isArray() || !confidenceVariable.isArray()) {
            throw new AcceptanceException("Expecting array type variables!");
        }
        Map<Long, ClassificationDataItem> firstPageItems = this.classificationService.getFirstPageItems(fileId);
        int length = fileId.length;
        String[] typesArray = new String[length];
        Double[] confidence = new Double[length];
        for (int i = 0; i < length; ++i) {
            ClassificationDataItem item = firstPageItems.get(fileId[i]);
            if (item != null) {
                typesArray[i] = item.getResultType();
                confidence[i] = item.getResultConfidence();
                continue;
            }
            typesArray[i] = "";
            confidence[i] = 0.0;
        }
        typeVariable.setValue((Object)typesArray);
        confidenceVariable.setValue((Object)confidence);
    }
}

