/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.servlets;

import com.suncode.plusocr.dto.DocClassInfo;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteriaExecutor;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Transactional
@Controller
@RequestMapping(value={"/doc"})
public class DocumentController {
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    HibernateCriteriaExecutor hibernateCriteriaExecutor;

    @RequestMapping(value={"docClassList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocClassInfo> getDocumentClassList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        List documentClasses = this.documentClassService.getAll(new String[0]).stream().filter(documentClass -> StringUtils.containsIgnoreCase((CharSequence)documentClass.getName(), (CharSequence)query)).sorted(Comparator.comparing(DocumentClass::getName)).collect(Collectors.toList());
        CountedResult result = new CountedResult();
        if (documentClasses.size() >= start) {
            result.setData(documentClasses.subList(start, Integer.min(start + limit, documentClasses.size())));
        } else {
            result.setData(Collections.emptyList());
        }
        result.setTotal((long)documentClasses.size());
        return this.convertDocClassToDto((CountedResult<DocumentClass>)result);
    }

    private CountedResult<DocClassInfo> convertDocClassToDto(CountedResult<DocumentClass> documentClasses) {
        List data = documentClasses.getData().stream().map(DocClassInfo::new).collect(Collectors.toList());
        return new CountedResult(documentClasses.getTotal(), data);
    }
}

