/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.services;

import com.suncode.plugin.framework.service.Provides;
import com.suncode.plusocr.domain.OcrData;
import com.suncode.plusocr.services.OcrDataDao;
import com.suncode.plusocr.services.OcrDataService;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Order;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Provides(value={OcrDataService.class})
public class OcrDataServiceImpl
implements OcrDataService {
    @Autowired
    private OcrDataDao ocrDataDao;

    @Override
    public void delete(Long id) {
        this.ocrDataDao.delete(this.ocrDataDao.get(id));
    }

    @Override
    public OcrData get(Long id) {
        return (OcrData)this.ocrDataDao.get(id);
    }

    @Override
    public OcrData get(String processId) {
        HibernateCriteria criteria = HibernateCriteria.forClass(OcrData.class);
        criteria.add(Restrictions.eq((String)"processId", (Object)processId));
        criteria.addOrder(Order.desc((String)"createdAt"));
        return (OcrData)this.ocrDataDao.findOne(criteria);
    }

    @Override
    public List<OcrData> getOlderThan(Date date) {
        HibernateCriteria criteria = HibernateCriteria.forClass(OcrData.class);
        criteria.add(Restrictions.lt((String)"createdAt", (Object)date));
        return this.ocrDataDao.findByCriteria(criteria);
    }

    @Override
    public List<OcrData> getAll() {
        return this.ocrDataDao.getAll(new String[0]);
    }

    @Override
    public List<OcrData> getUnprocessed() {
        return this.ocrDataDao.findByProperty("processed", false, 0, Integer.MAX_VALUE, new String[0]);
    }

    @Override
    public List<OcrData> getUndeleted() {
        return this.ocrDataDao.findByProperty("isDeleted", false, 0, 100, new String[0]);
    }

    @Override
    public void update(OcrData data) {
        this.ocrDataDao.update(data);
    }

    @Override
    public void save(OcrData data) {
        this.ocrDataDao.save(data);
    }
}

