/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.rest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plusocr.invoicedata.OcrResult;
import com.suncode.plusocr.pluginconfigurationmanager.dto.OcrConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.dto.SkanujToConfigurationDto;
import com.suncode.plusocr.tools.LoggingRequestInterceptor;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class SkanujToConnection {
    private static final Logger log = LoggerFactory.getLogger(SkanujToConnection.class);
    private String skanujtoUrl = "";
    private final RestTemplate restTemplate;
    private String token = null;

    public String getToken() {
        return this.token;
    }

    public SkanujToConnection(OcrConfigurationDto ocrConfigurationDto) {
        System.setProperty("http.keepAlive", "false");
        String apiUrl = ocrConfigurationDto.getSkanujTo().getApiUrl();
        if (!apiUrl.endsWith("/")) {
            apiUrl = apiUrl + "/";
        }
        this.skanujtoUrl = apiUrl;
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        simpleClientHttpRequestFactory.setConnectTimeout(30000);
        simpleClientHttpRequestFactory.setReadTimeout(30000);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)simpleClientHttpRequestFactory));
        ArrayList<LoggingRequestInterceptor> interceptors = new ArrayList<LoggingRequestInterceptor>();
        interceptors.add(new LoggingRequestInterceptor());
        this.restTemplate.setInterceptors(interceptors);
    }

    public boolean authorizeUser(OcrConfigurationDto ocrConfigurationDto) throws Exception {
        String url = this.skanujtoUrl + "auth";
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        SkanujToConfigurationDto skanujToConfiguration = ocrConfigurationDto.getSkanujTo();
        map.add((Object)"email", (Object)skanujToConfiguration.getLogin());
        String apiKey = skanujToConfiguration.getApiKey();
        if (StringUtils.isNotBlank((String)apiKey)) {
            map.add((Object)"apikey", (Object)apiKey);
        } else {
            map.add((Object)"password", (Object)skanujToConfiguration.getPassword());
        }
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)new HttpHeaders());
        String result = (String)this.restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        try {
            String json = StringEscapeUtils.unescapeJava((String)result);
            HashMap hmResult = (HashMap)mapper.readValue(json, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            log.debug("Result:" + hmResult.toString());
            int code = (Integer)hmResult.get("code");
            if (code == 10) {
                this.token = (String)hmResult.get("token");
                return true;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return false;
    }

    public int sendDocumentToProceed(String clientid, WfDocument wfDoc, int invoiceType, boolean forceUpload) throws Exception {
        int forceUploadExisted;
        String path = wfDoc.getFile().getFullPath();
        FileSystemResource file1 = new FileSystemResource(path);
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.add((Object)"mode", (Object)"upload-file");
        parts.add((Object)"source", (Object)"integracja");
        int n = forceUploadExisted = forceUpload ? 1 : 0;
        if (invoiceType != -1) {
            parts.add((Object)"extra", (Object)("{ \"type\": " + invoiceType + ", \"forceUploadExisted\": " + forceUploadExisted + " }"));
        } else {
            parts.add((Object)"extra", (Object)("{ \"forceUploadExisted\": " + forceUploadExisted + " }"));
        }
        parts.add((Object)"file", (Object)file1);
        parts.add((Object)"filename", (Object)file1.getFilename());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.add("token", this.token);
        headers.add("company_id", clientid);
        HttpEntity requestEntity = new HttpEntity((Object)parts, (MultiValueMap)headers);
        String url = this.skanujtoUrl + "document";
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        if (response != null && !((String)response.getBody()).trim().equals("")) {
            String json = (String)response.getBody();
            JSONObject obj = new JSONObject(json);
            JSONArray goodArray = (JSONArray)obj.get("good-uploads");
            JSONArray badArray = (JSONArray)obj.get("bad-uploads");
            if (!badArray.toString().equals("[]")) {
                throw new AcceptanceException("Response from skanujto: Upload failed!");
            }
            JSONObject goodElObj = (JSONObject)goodArray.get(0);
            String notice = (String)goodElObj.get("notice");
            if (!forceUpload && notice.equals("file_already_exists")) {
                throw new AcceptanceException("Response from skanujto: File already exists!");
            }
            Integer docId = (Integer)goodElObj.get("doc_id");
            log.debug("docId:" + docId);
            return docId;
        }
        return -1;
    }

    public OcrResult getOCRData(String clientid, long docId) throws Exception {
        block5: {
            JSONObject objDocumentIndexes;
            String url = this.skanujtoUrl + "document/mode/one-xt?id=" + docId;
            HttpHeaders headers = new HttpHeaders();
            headers.add("token", this.token);
            if (clientid != null) {
                headers.add("company_id", clientid);
            }
            HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response == null || ((String)response.getBody()).trim().equals("")) break block5;
            String documentIndexes = ((String)response.getBody()).replace(";", ",");
            try {
                objDocumentIndexes = new JSONObject(documentIndexes);
            }
            catch (JSONException e) {
                log.info(documentIndexes);
                return null;
            }
            log.debug("objDocumentIndexes:" + objDocumentIndexes);
            JsonFactory factory = new JsonFactory();
            ObjectMapper mapper = new ObjectMapper(factory);
            OcrResult ocrResult = (OcrResult)mapper.readValue(documentIndexes, OcrResult.class);
            ocrResult.setJson(documentIndexes);
            return ocrResult;
        }
        return null;
    }

    public boolean deleteDocument(long docId) throws Exception {
        String url = this.skanujtoUrl + "document?id=" + docId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", this.token);
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.DELETE, entity, String.class, new Object[0]);
        if (response != null && !((String)response.getBody()).trim().equals("")) {
            JsonFactory factory = new JsonFactory();
            ObjectMapper mapper = new ObjectMapper(factory);
            try {
                String json = StringEscapeUtils.unescapeJava((String)((String)response.getBody()));
                HashMap hmResult = (HashMap)mapper.readValue(json, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                log.debug("Result:" + hmResult.toString());
                int code = (Integer)hmResult.get("code");
                if (code == 10) {
                    return true;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return false;
    }
}

