/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.pluginconfigurationmanager.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.initconfiguration.InitConfigurationDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.initconfiguration.InitConfigurationProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.model.FileType;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plusocr.pluginconfigurationmanager.dto.OcrConfigurationDto;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.configuration.exception.SystemParameterNotExists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class InitConfigurationFileProvider
implements InitConfigurationProvider {
    private static final Logger log = LoggerFactory.getLogger(InitConfigurationFileProvider.class);
    private static final String INIT_CONFIGURATION_FILE_NAME = "config";
    private static final String INIT_CONFIGURATION_FILE_CONTENT_PATH = "/pluginconfigurationmanager/config/init_configuration_file.json";
    @Autowired
    private ConfigurationFileService configurationFileService;
    @Autowired
    private Plugin plugin;
    @Autowired
    private SystemParameterService systemParameterService;

    public List<InitConfigurationDto> getInitConfigurations() {
        ArrayList<InitConfigurationDto> initConfigurationDtos = new ArrayList<InitConfigurationDto>();
        if (this.areNoConfigsDefined()) {
            try {
                OcrConfigurationDto ocrConfigurationDto;
                ObjectMapper objectMapper = new ObjectMapper();
                try (InputStream initConfigStream = this.getClass().getResourceAsStream(INIT_CONFIGURATION_FILE_CONTENT_PATH);){
                    ocrConfigurationDto = (OcrConfigurationDto)objectMapper.readValue(initConfigStream, OcrConfigurationDto.class);
                }
                String skanujToCategory = "PlusOCR";
                this.copySystemParameters("ApiUrl", skanujToCategory, ocrConfigurationDto, (ocrConfigDto, parameterValue) -> ocrConfigDto.getSkanujTo().setApiUrl((String)parameterValue));
                this.copySystemParameters("Login", skanujToCategory, ocrConfigurationDto, (ocrConfigDto, parameterValue) -> ocrConfigDto.getSkanujTo().setLogin((String)parameterValue));
                this.copySystemParameters("Password", skanujToCategory, ocrConfigurationDto, (ocrConfigDto, parameterValue) -> ocrConfigDto.getSkanujTo().setPassword((String)parameterValue));
                this.copySystemParameters("CompanyId", skanujToCategory, ocrConfigurationDto, (ocrConfigDto, parameterValue) -> ocrConfigDto.getSkanujTo().setCompanyId((String)parameterValue));
                ocrConfigurationDto.getAlphamoon().setApiKey("SYSTEM_PARAMETER:PlusOCR.Alphamoon.ApiKey");
                byte[] modifiedConfigBytes = objectMapper.writeValueAsBytes((Object)ocrConfigurationDto);
                ByteArrayInputStream modifiedInputStream = new ByteArrayInputStream(modifiedConfigBytes);
                InitConfigurationDto initConfigurationDto = new InitConfigurationDto(INIT_CONFIGURATION_FILE_NAME, FileType.JSON, (InputStream)modifiedInputStream);
                initConfigurationDtos.add(initConfigurationDto);
                this.deleteSystemParameters(skanujToCategory, Arrays.asList("ApiUrl", "Login", "Password", "CompanyId"));
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return initConfigurationDtos;
    }

    private boolean areNoConfigsDefined() {
        return this.configurationFileService.getAllReadableFilesIds(this.plugin.getKey()).length == 0;
    }

    private void copySystemParameters(String parameter, String category, OcrConfigurationDto ocrConfigurationDto, BiConsumer<OcrConfigurationDto, String> biConsumer) {
        SystemParameter systemParameter = this.systemParameterService.getParameter(parameter);
        if (systemParameter != null && systemParameter.getCategory().getKey().equals(category) && StringUtils.isNotBlank((CharSequence)systemParameter.getValueString())) {
            if (systemParameter.getParameterType().equals((Object)ParameterType.PASSWORD)) {
                biConsumer.accept(ocrConfigurationDto, SystemProperties.getPassword((String)parameter));
            } else {
                biConsumer.accept(ocrConfigurationDto, systemParameter.getValueString());
            }
        }
    }

    private void deleteSystemParameters(String category, List<String> parameterIds) {
        for (String parameter : parameterIds) {
            SystemParameter systemParameter = this.systemParameterService.getParameter(parameter);
            if (systemParameter == null || !systemParameter.getCategory().getKey().equals(category)) continue;
            try {
                this.systemParameterService.delete(systemParameter.getKey());
            }
            catch (SystemParameterNotExists e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

