/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.alphamoon.services;

import com.suncode.plusocr.alphamoon.domain.AlphamoonOcrData;
import com.suncode.plusocr.alphamoon.services.AlphamoonOcrDataDao;
import com.suncode.plusocr.alphamoon.services.AlphamoonOcrDataService;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Order;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AlphamoonOcrDataServiceImpl
implements AlphamoonOcrDataService {
    @Autowired
    private AlphamoonOcrDataDao ocrDataDao;

    @Override
    public AlphamoonOcrData get(Long id) {
        return (AlphamoonOcrData)this.ocrDataDao.get(id);
    }

    @Override
    public AlphamoonOcrData get(String processId) {
        HibernateCriteria criteria = HibernateCriteria.forClass(AlphamoonOcrData.class);
        criteria.add(Restrictions.eq((String)"processId", (Object)processId));
        criteria.addOrder(Order.desc((String)"createdAt"));
        return (AlphamoonOcrData)this.ocrDataDao.findOne(criteria);
    }

    @Override
    public List<AlphamoonOcrData> getUnprocessed() {
        return this.ocrDataDao.findByProperty("processed", false, 0, Integer.MAX_VALUE, new String[0]);
    }

    @Override
    public List<AlphamoonOcrData> getOlderThan(Date date) {
        HibernateCriteria criteria = HibernateCriteria.forClass(AlphamoonOcrData.class);
        criteria.add(Restrictions.lt((String)"createdAt", (Object)date));
        return this.ocrDataDao.findByCriteria(criteria);
    }

    @Override
    public List<AlphamoonOcrData> getUndeleted() {
        return this.ocrDataDao.findByProperty("isDeleted", false, 0, 100, new String[0]);
    }

    @Override
    public void setProcessed(AlphamoonOcrData data, boolean value) {
        data.setProcessed(value);
    }

    @Override
    public void setDeleted(AlphamoonOcrData data, boolean value) {
        data.setIsDeleted(value);
    }

    @Override
    public void update(AlphamoonOcrData data) {
        this.ocrDataDao.update(data);
    }

    @Override
    public void save(AlphamoonOcrData data) {
        this.ocrDataDao.save(data);
    }

    @Override
    public void delete(Long id) {
        this.ocrDataDao.delete(this.ocrDataDao.get(id));
    }
}

