PWE.integrationComponent.registerApplication("skanujto-application", {
    apiVersion: 2,
    buildForm: function (form) {
        form.addCombobox({
            id: "provider",
            values: [
                {id: "SKANUJ_TO", display: "Skanuj.to"},
                {id: "ALPHAMOON_AI", display: "[Deprecated] Alphamoon.ai"},
                {id: "SUNCODE_OCR", display: "Suncode OCR"},
            ],
            listeners: {
                change: function (value) {
                    if (value === "ALPHAMOON_AI") {
                        form.hide("force_upload");
                        form.hide("configurationId");
                        form.setNotEmpty("force_upload", false);
                        form.hide("invoice_type");
                        form.show("alphamoonProcess")
                        form.setNotEmpty("alphamoonProcess", true);
                    } else if (value === "SUNCODE_OCR") {
                        form.hide("force_upload");
                        form.show("configurationId");
                        form.setNotEmpty("force_upload", false);
                        form.hide("invoice_type");
                        form.hide("alphamoonProcess")
                        form.setNotEmpty("alphamoonProcess", false);
                    } else {
                        form.hide("alphamoonProcess")
                        form.hide("configurationId")
                        form.setNotEmpty("alphamoonProcess", false);
                        form.show("force_upload");
                        form.setNotEmpty("force_upload", true);
                        form.show("invoice_type");
                    }
                }
            }
        });

        form.addField("configurationId");

        const provider = form.getValue("provider");

        form.addField("passed");
        form.addField("force_upload");
        form.addCombobox({
            id: "document_classes",
            remote: {
                url: "plugin/com.suncode.plugin-plusocr/doc/docClassList",
                fields: [
                    {
                        name: "docClassId",
                        type: "string"
                    },
                    {
                        name: "docClassName",
                        type: "string"
                    },
                    {
                        name: "docClassDesc",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: PlusOCR.t("dpwe-doc-class.name"),
                    field: "docClassName"
                },
                {
                    label: PlusOCR.t("dpwe-doc-class.desc"),
                    field: "docClassDesc"
                },
                {
                    label: PlusOCR.t("dpwe-doc-class.id"),
                    field: "docClassId"
                }
            ],
            valueField: "docClassName",
            displayField: "docClassName",
            sort: [{
                property: "docClassName",
                direction: "ASC"
            }]
        });
        form.addField("invoice_type");
        form.addCombobox({
            id: "alphamoonProcess",
            remote: {
                url: "plugin/com.suncode.plugin-plusocr/alphamoon/processes",
                fields: [
                    {
                        name: "id",
                        type: "string"
                    },
                    {
                        name: "name",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: PlusOCR.t("dpwe.alphamoon.alphamoonProcess.name"),
                    field: "name"
                },
                {
                    label: PlusOCR.t("dpwe.alphamoon.alphamoonProcess.id"),
                    field: "id"
                }
            ],
            valueField: "id",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }]
        });

        if (provider === "SKANUJ_TO") {
            form.hide("alphamoonProcess")
            form.hide("configurationId")
            form.setNotEmpty("force_upload", true);
        } else if (provider === "ALPHAMOON_AI") {
            form.hide("force_upload");
            form.hide("configurationId");
            form.hide("invoice_type");
        } else if (provider === "SUNCODE_OCR") {
            form.hide("force_upload");
            form.hide("invoice_type");
            form.hide("alphamoonProcess")
            form.setNotEmpty("force_upload", false);
        }

        form.addField({
            id: 'skipMultiPageDocuments',
            listeners: {
                change: function (value) {
                    if (value === true) {
                        form.resetValue("maxNumberOfPages");
                        form.hide("maxNumberOfPages");
                    } else {
                        form.show("maxNumberOfPages");
                    }
                }
            }
        });
        form.addField("maxNumberOfPages");
        form.addField("documentSendingOmitted");

        if (form.getValue("skipMultiPageDocuments") === true) {
            form.hide("maxNumberOfPages");
        }
    },

    validateForm: function (api) {
        if (api.getVariableType('documentSendingOmitted') != null && api.getVariableType('documentSendingOmitted') !== 'boolean') {
            api.showErrorMessage(PlusOCR.t('form-valid-boolean'));
            api.markError('documentSendingOmitted')
            return false;
        }
        return true;
    }
});