/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.alphamoon.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Strings;
import com.suncode.plusocr.alphamoon.dto.AlphamoonItemsTableDto;
import com.suncode.plusocr.alphamoon.dto.AlphamoonOcrResultDto;
import com.suncode.plusocr.alphamoon.dto.AlphamoonProcessDto;
import com.suncode.plusocr.alphamoon.dto.response.AlphamoonDocumentDto;
import com.suncode.plusocr.alphamoon.dto.response.AlphamoonExtractedDataFieldDto;
import com.suncode.plusocr.alphamoon.dto.response.AlphamoonExtractedTableDto;
import com.suncode.plusocr.alphamoon.dto.response.AlphamoonRootResponseDto;
import com.suncode.plusocr.alphamoon.dto.response.AlphamoonTableRowDto;
import com.suncode.plusocr.alphamoon.rest.AlphamoonException;
import com.suncode.plusocr.alphamoon.rest.AlphamoonService;
import com.suncode.plusocr.pluginconfigurationmanager.dto.OcrConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.services.OcrConfigurationService;
import com.suncode.pwfl.archive.WfDocument;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.util.Base64Util;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlphamoonServiceImpl
implements AlphamoonService {
    private static final Logger log = LoggerFactory.getLogger(AlphamoonServiceImpl.class);
    private static final String API_URL = "https://workspace.alphamoon.ai/api/v0.3";
    private static final String BASIC = "Basic ";
    private final ObjectMapper objectMapper;
    private final OkHttpClient httpClient;
    private final OcrConfigurationService ocrConfigurationService;

    @Autowired
    public AlphamoonServiceImpl(OcrConfigurationService ocrConfigurationService) {
        this.ocrConfigurationService = ocrConfigurationService;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.httpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<String> sendDocumentToProceed(WfDocument wfDocument, String alphamoonProcessId) {
        try {
            File file = new File(wfDocument.getFile().getFullPath());
            MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((File)file, (MediaType)MediaType.parse((String)"application/octet-stream"))).build();
            Request request = new Request.Builder().url("https://workspace.alphamoon.ai/api/v0.3/processes/" + alphamoonProcessId + "/files/binary").addHeader("Authorization", BASIC + this.getEncodedApiKey()).addHeader("Content-Type", "application/json").post((RequestBody)requestBody).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful()) {
                    String jsonString = Objects.requireNonNull(response.body()).string();
                    JSONObject jsonObject = new JSONObject(jsonString);
                    Optional<String> optional = Optional.ofNullable(jsonObject.getString("collectionId"));
                    return optional;
                }
                throw new AlphamoonException(this.buildExceptionMessage(response));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AlphamoonProcessDto> getProcesses() {
        try {
            Request request = new Request.Builder().url("https://workspace.alphamoon.ai/api/v0.3/processes").addHeader("Authorization", BASIC + this.getEncodedApiKey()).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful()) {
                    String jsonString = Objects.requireNonNull(response.body()).string();
                    JSONObject jsonObject = new JSONObject(jsonString);
                    List list = (List)this.objectMapper.readValue(jsonObject.getJSONArray("processes").toString(), (TypeReference)new TypeReference<List<AlphamoonProcessDto>>(){});
                    return list;
                }
                throw new AlphamoonException(this.buildExceptionMessage(response));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<AlphamoonOcrResultDto> getOCRData(String collectionId) {
        try {
            Request request = new Request.Builder().url("https://workspace.alphamoon.ai/api/v0.3/results/" + collectionId).addHeader("Authorization", BASIC + this.getEncodedApiKey()).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful()) {
                    String jsonResponse = Objects.requireNonNull(response.body()).string();
                    AlphamoonRootResponseDto root = (AlphamoonRootResponseDto)this.objectMapper.readValue(jsonResponse, AlphamoonRootResponseDto.class);
                    AlphamoonOcrResultDto ocrResult = this.mapResponse(root);
                    ocrResult.setJson(jsonResponse);
                    Optional<AlphamoonOcrResultDto> optional = Optional.of(ocrResult);
                    return optional;
                }
                throw new AlphamoonException(this.buildExceptionMessage(response));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    private AlphamoonOcrResultDto mapResponse(AlphamoonRootResponseDto root) {
        AlphamoonDocumentDto alphamoonDocumentDto = root.getResults().get(0).getDocuments().get(0);
        Map<String, List<AlphamoonExtractedDataFieldDto>> extractedData = alphamoonDocumentDto.getExtractedData();
        List<AlphamoonExtractedTableDto> invoiceTable = alphamoonDocumentDto.getExtractedTables().get("invoice_items_table");
        List<List<AlphamoonTableRowDto>> extractedTabularData = null;
        if (invoiceTable != null && !invoiceTable.isEmpty()) {
            extractedTabularData = invoiceTable.get(0).getRows();
        }
        Map<String, String> fieldsAndValuesMap = extractedData.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> Strings.nullToEmpty((String)((AlphamoonExtractedDataFieldDto)((List)entry.getValue()).get(0)).getValue())));
        AlphamoonOcrResultDto ocrResultDto = (AlphamoonOcrResultDto)this.objectMapper.convertValue(fieldsAndValuesMap, AlphamoonOcrResultDto.class);
        ocrResultDto.setStatus(alphamoonDocumentDto.getStatus().getStatus());
        ArrayList<AlphamoonItemsTableDto> rows = new ArrayList<AlphamoonItemsTableDto>();
        if (extractedTabularData != null) {
            for (List<AlphamoonTableRowDto> responseRow : extractedTabularData) {
                Map<String, String> rowValues = responseRow.stream().filter(entry -> entry.getHeaderLabel() != null && entry.getText() != null).collect(Collectors.toMap(AlphamoonTableRowDto::getHeaderLabel, AlphamoonTableRowDto::getText));
                AlphamoonItemsTableDto singleRow = (AlphamoonItemsTableDto)this.objectMapper.convertValue(rowValues, AlphamoonItemsTableDto.class);
                try {
                    singleRow.setAdditionalProperties(this.objectMapper.writeValueAsString(rowValues));
                }
                catch (JsonProcessingException e) {
                    log.error(e.getMessage());
                }
                rows.add(singleRow);
            }
        }
        try {
            ocrResultDto.setAdditionalProperties(this.objectMapper.writeValueAsString(fieldsAndValuesMap));
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
        }
        ocrResultDto.setRows(rows);
        return ocrResultDto;
    }

    @Override
    public void deleteDocument(String collectionId) {
        try {
            Request request = new Request.Builder().url("https://workspace.alphamoon.ai/api/v0.3/collections/" + collectionId).delete().addHeader("Authorization", BASIC + this.getEncodedApiKey()).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new AlphamoonException(this.buildExceptionMessage(response));
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String buildExceptionMessage(Response response) {
        String message = "Request to Alphamoon.ai was not successful. Error code: " + response.code();
        try {
            message = message + ", details: " + Objects.requireNonNull(response.body()).string();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return message;
    }

    private String getEncodedApiKey() throws AlphamoonException, IOException {
        OcrConfigurationDto ocrConfigurationDto = this.ocrConfigurationService.readConfigurationFile();
        String apiKey = ocrConfigurationDto.getAlphamoon().getApiKey();
        if (apiKey == null) {
            String message = "Alphamoon system properties are not filled!";
            log.error(message);
            throw new AlphamoonException(message);
        }
        return Base64Util.encode((String)apiKey);
    }
}

