PW.ScheduledTasks.register("plusocr-get-data", {
    buildParams: function (form) {
        form.addCombobox({
            id: "provider",
            values: [
                {id: "SKANUJ_TO", display: "Skanuj.to"},
                {id: "ALPHAMOON_AI", display: "[Deprecated] Alphamoon.ai"},
                {id: "SUNCODE_OCR", display: "Suncode OCR"}
            ],
            listeners: {
                change: function (field, newValue) {
                    if (newValue !== "SKANUJ_TO") {
                        form.hide("clientId");
                    } else {
                        form.show("clientId");
                    }

                    if (newValue === "SUNCODE_OCR") {
                        form.show("configurationIds");
                        form.hide("deleteDelay");
                        form.hide("deleteDocumentsFromTerminatedBufferTasks");
                    } else {
                        form.hide("configurationIds");
                        form.show("deleteDelay");
                        form.show("deleteDocumentsFromTerminatedBufferTasks");
                    }
                }
            },
        });

        form.addField("configurationIds");

        if (!form.getValue("provider")) {
            form.setValue("provider", "SKANUJ_TO");
        }

        form.setRequired("provider", true);
        form.addField("processDefId");
        form.addField("activityDefId");
        form.addField("clientId");

        if (form.getValue("provider") !== "SKANUJ_TO") {
            form.hide("clientId");
        }

        form.addField("deleteDelay");

        if (form.getValue("provider") === "SUNCODE_OCR") {
            form.hide("deleteDelay");
            form.hide("deleteDocumentsFromTerminatedBufferTasks");
        } else {
            form.hide("configurationIds");
        }

        form.addField("sActionName");
        form.addField("ignoreTerminatedBufferTasks");
        form.setRequired("ignoreTerminatedBufferTasks", true);
        form.addField("deleteDocumentsFromTerminatedBufferTasks");
        form.setRequired("deleteDocumentsFromTerminatedBufferTasks", true);
    },
});