/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.scheduled_tasks;

import com.azure.ai.documentintelligence.models.AnalyzeOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceOperationStatus;
import com.google.common.collect.Lists;
import com.plusmpm.database.dbspecific.NativeDatabase;
import com.suncode.plusocr.alphamoon.domain.AlphamoonItemsTable;
import com.suncode.plusocr.alphamoon.domain.AlphamoonOcrData;
import com.suncode.plusocr.alphamoon.dto.AlphamoonItemsTableDto;
import com.suncode.plusocr.alphamoon.dto.AlphamoonOcrResultDto;
import com.suncode.plusocr.alphamoon.rest.AlphamoonService;
import com.suncode.plusocr.alphamoon.services.AlphamoonItemsTableService;
import com.suncode.plusocr.alphamoon.services.AlphamoonOcrDataService;
import com.suncode.plusocr.common.BaseOcrDataService;
import com.suncode.plusocr.domain.OcrData;
import com.suncode.plusocr.domain.PositionRow;
import com.suncode.plusocr.invoicedata.OcrResult;
import com.suncode.plusocr.invoicedata.Position;
import com.suncode.plusocr.pluginconfigurationmanager.dto.OcrConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.dto.SuncodeOcrConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.services.OcrConfigurationService;
import com.suncode.plusocr.rest.SkanujToConnection;
import com.suncode.plusocr.services.OcrDataService;
import com.suncode.plusocr.services.PositionRowService;
import com.suncode.plusocr.suncodeocr.db.SuncodeOcrData;
import com.suncode.plusocr.suncodeocr.db.service.SuncodeOcrDataService;
import com.suncode.plusocr.suncodeocr.dto.ResponseWrapper;
import com.suncode.plusocr.suncodeocr.exception.ApiResponseFailedException;
import com.suncode.plusocr.suncodeocr.service.SuncodeOcrService;
import com.suncode.plusocr.utils.AlphamoonOcrDataMapper;
import com.suncode.plusocr.utils.OcrDataMapper;
import com.suncode.plusocr.utils.OcrProvider;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.search.sql.GroupSQLFilter;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteriaExecutor;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.support.hibernate.type.StandardBasicTypes;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.assignment.AssignmentService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessState;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@ScheduledTask
@ScheduledTaskScript(value="scripts/dynamic-pwe/scheduledtasks/get-ocr-data.js")
public class GetOCRdata {
    private static final Logger log = LoggerFactory.getLogger(GetOCRdata.class);
    private final AtomicInteger warningCounter = new AtomicInteger();
    private final AtomicInteger processedDocumentsCounter = new AtomicInteger();
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private SuncodeOcrDataService suncodeOcrDataService;
    @Autowired
    private SuncodeOcrService suncodeOcrService;
    @Autowired
    private AlphamoonOcrDataService alphamoonOcrDataService;
    @Autowired
    private AlphamoonService alphamoonService;
    @Autowired
    private AlphamoonItemsTableService alphamoonItemsTableService;
    @Autowired
    private OcrDataService ocrDataService;
    @Autowired
    private PositionRowService positionRowService;
    @Autowired
    private HibernateCriteriaExecutor hibernateCriteriaExecutor;
    @Autowired
    private OcrConfigurationService configurationService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusocr-get-data")).name("scheduledtask.plusocr.getdata")).description("scheduledtask.plusocr.getdata.desc")).parameter().id("provider").name("scheduledtask.plusocr.parameter.provider.name").description("scheduledtask.plusocr.parameter.provider.desc").type((Type)Types.STRING).defaultValue((Object)OcrProvider.SKANUJ_TO.name()).optional().create()).parameter().id("processDefId").name("scheduledtask.plusocr.parameter.processdefid.name").description("scheduledtask.plusocr.parameter.processdefid.desc").type((Type)Types.STRING).create()).parameter().id("activityDefId").name("scheduledtask.plusocr.parameter.activitydefid.name").description("scheduledtask.plusocr.parameter.activitydefid.desc").type((Type)Types.STRING).create()).parameter().id("clientId").name("scheduledtask.plusocr.parameter.clientid.name").description("scheduledtask.plusocr.parameter.clientid.desc").type((Type)Types.STRING).optional().create()).parameter().id("deleteDelay").name("scheduledtask.plusocr.parameter.deleteDelay.name").description("scheduledtask.plusocr.parameter.deleteDelay.desc").type((Type)Types.STRING).optional().defaultValue((Object)"").create()).parameter().id("sActionName").name("scheduledtask.plusocr.parameter.actionname.name").description("scheduledtask.plusocr.parameter.actionname.desc").type((Type)Types.STRING).optional().defaultValue((Object)"").create()).parameter().id("ignoreTerminatedBufferTasks").name("scheduledtask.plusocr.parameter.ignoreTerminatedBufferTasks.name").description("scheduledtask.plusocr.parameter.ignoreTerminatedBufferTasks.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).optional().create()).parameter().id("deleteDocumentsFromTerminatedBufferTasks").name("scheduledtask.plusocr.parameter.deleteDocumentsFromTerminatedBufferTasks.name").description("scheduledtask.plusocr.parameter.deleteDocumentsFromTerminatedBufferTasks.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).optional().create()).parameter().id("configurationIds").name("scheduledtask.plusocr.parameter.configurationIds.name").description("scheduledtask.plusocr.parameter.configurationIds.desc").type((Type)Types.STRING_ARRAY).optional().create();
    }

    public String execute(@Param String provider, @Param String processDefId, @Param String activityDefId, @Param String clientId, @Param String sActionName, @Param String deleteDelay, @Param Boolean ignoreTerminatedBufferTasks, @Param Boolean deleteDocumentsFromTerminatedBufferTasks, @Param String[] configurationIds, org.apache.log4j.Logger taskLog) throws Throwable {
        OcrProvider ocrProvider = OcrProvider.valueOf(provider);
        this.warningCounter.set(0);
        this.processedDocumentsCounter.set(0);
        switch (ocrProvider) {
            case SUNCODE_OCR: {
                return this.getOcrDataForSuncodeOcr(processDefId, activityDefId, sActionName, ignoreTerminatedBufferTasks, taskLog, configurationIds);
            }
            case SKANUJ_TO: {
                return this.getOcrDataForSkanujTo(processDefId, activityDefId, clientId, sActionName, deleteDelay, ignoreTerminatedBufferTasks, deleteDocumentsFromTerminatedBufferTasks, taskLog);
            }
            case ALPHAMOON_AI: {
                return this.getOcrDataForAlphamoon(processDefId, activityDefId, sActionName, deleteDelay, ignoreTerminatedBufferTasks, deleteDocumentsFromTerminatedBufferTasks, taskLog);
            }
        }
        return "";
    }

    private List<OcrConfigurationDto> getConfigurationDtoList(String[] configurationIds, org.apache.log4j.Logger taskLog) throws IOException {
        ArrayList<OcrConfigurationDto> configurationDtoList = new ArrayList<OcrConfigurationDto>();
        for (String configurationId : configurationIds) {
            try {
                taskLog.info((Object)String.format("Reading configuration file: %s...", configurationId));
                configurationDtoList.add(this.configurationService.readConfigurationFile(configurationId));
            }
            catch (IOException e) {
                taskLog.warn((Object)String.format("Missing configuration ID: %s", configurationId));
            }
        }
        if (configurationDtoList.isEmpty()) {
            taskLog.info((Object)"Reading default configuration file...");
            configurationDtoList.add(this.configurationService.readConfigurationFile());
        }
        return configurationDtoList;
    }

    private String getOcrDataForSuncodeOcr(String processDefId, String activityDefId, String sActionName, Boolean ignoreTerminatedBufferTasks, org.apache.log4j.Logger taskLog, String[] configurationIds) throws IOException {
        List<OcrConfigurationDto> configurationDtoList = this.getConfigurationDtoList(configurationIds, taskLog);
        configurationDtoList.stream().map(OcrConfigurationDto::getSuncodeOcr).forEach(suncodeConfigurationDto -> {
            Consumer<Activity> acceptConsumer = this.getSuncodeOcrAcceptConsumer(activityDefId, sActionName);
            this.acceptProcessedTasks(processDefId, activityDefId, acceptConsumer);
            List<SuncodeOcrData> unprocessedDocs = this.suncodeOcrDataService.getUnprocessed();
            unprocessedDocs.forEach(doc -> {
                Process process = this.processService.getProcess(doc.getProcessId(), new String[]{"processDefinition"});
                if (this.shouldProceed(process, processDefId)) {
                    if (process != null) {
                        List<Activity> terminatedBufferedTasks;
                        this.logProcessInfo(process);
                        if (Boolean.TRUE.equals(ignoreTerminatedBufferTasks) && !(terminatedBufferedTasks = this.getTerminatedBufferedTasks(activityDefId, doc.getProcessId())).isEmpty()) {
                            Runnable emptyDeleteDocumentAction = () -> {};
                            this.processTerminatedBufferTasks(this.suncodeOcrDataService, doc, emptyDeleteDocumentAction, false, taskLog, doc.getOcrRequestId());
                            return;
                        }
                    }
                    Supplier<Optional> ocrResultSupplier = () -> this.ocrResultSupplier((SuncodeOcrConfigurationDto)suncodeConfigurationDto, doc.getOcrRequestId());
                    Optional ocrData = this.fetchOcrData(doc.getOcrRequestId(), taskLog, ocrResultSupplier);
                    if (!ocrData.isPresent()) {
                        Runnable deleteOcrDataAction = () -> this.suncodeOcrDataService.delete(doc.getId());
                        this.handleMissingDocument(process, doc.getOcrRequestId(), taskLog, deleteOcrDataAction);
                        return;
                    }
                    this.processOcrResult(process, (AnalyzeOperationDetails)((ResponseWrapper)ocrData.get()).getBody(), (SuncodeOcrData)doc, activityDefId, sActionName, taskLog);
                }
            });
        });
        return this.getSummary(taskLog);
    }

    private Optional<ResponseWrapper<AnalyzeOperationDetails>> ocrResultSupplier(SuncodeOcrConfigurationDto configurationDto, String requestId) {
        try {
            return Optional.ofNullable(this.suncodeOcrService.getAnalyzeDocumentResult(configurationDto, requestId));
        }
        catch (ApiResponseFailedException | IOException e) {
            return Optional.empty();
        }
    }

    private String getOcrDataForSkanujTo(String processDefId, String activityDefId, String clientId, String sActionName, String deleteDelay, Boolean ignoreTerminatedBufferTasks, Boolean deleteDocumentsFromTerminatedBufferTasks, org.apache.log4j.Logger taskLog) throws Throwable {
        OcrConfigurationDto ocrConfigurationDto = this.configurationService.readConfigurationFile();
        SkanujToConnection skanujToConnectionObject = new SkanujToConnection(ocrConfigurationDto);
        if (skanujToConnectionObject.authorizeUser(ocrConfigurationDto)) {
            List openedActivities = this.findOpenActivitiesForId(processDefId, activityDefId).stream().filter(activity -> ProcessState.isOpen((ProcessState)this.processService.getProcess(activity.getProcessId(), new String[0]).getState())).collect(Collectors.toList());
            log.info("Open activities");
            for (Activity openedActivity : openedActivities) {
                log.info("Activity: " + openedActivity.getName());
                log.info("Process status: " + this.processService.getProcess(openedActivity.getProcessId(), new String[0]).getState());
                if (!openedActivity.getActivityDefinitionId().equalsIgnoreCase(activityDefId)) continue;
                OcrData data = this.ocrDataService.get(openedActivity.getProcessId());
                if (data != null) {
                    if (data.getProcessed() == null || !data.getProcessed().booleanValue()) continue;
                    try {
                        this.acceptTask(openedActivity.getProcessId(), activityDefId, sActionName);
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                    try {
                        if (deleteDelay == null) {
                            skanujToConnectionObject.deleteDocument(data.getDocId());
                            data.setIsDeleted(true);
                            this.ocrDataService.update(data);
                            continue;
                        }
                        log.info("Document deletion has been delayed.");
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                    continue;
                }
                log.warn("pominieto: " + openedActivity.getProcessId() + "; " + openedActivity.getActivityDefinitionId() + " " + openedActivity.getActivityId());
            }
            List<OcrData> docsList = this.ocrDataService.getUnprocessed();
            log.info("Get data from OCR service");
            for (OcrData e : docsList) {
                OcrResult ocrResult;
                String message;
                Process process = this.processService.getProcess(e.getProcessId(), new String[]{"processDefinition"});
                if (process != null && (!process.getProcessDefinition().getProcessDefinitionId().equalsIgnoreCase(processDefId) || !ProcessState.isOpen((ProcessState)process.getState()))) continue;
                if (process != null) {
                    List terminatedBufferTasks;
                    log.info("Process: " + process.getName());
                    log.info("Process status: " + process.getState());
                    if (Boolean.TRUE.equals(ignoreTerminatedBufferTasks) && CollectionUtils.isNotEmpty(terminatedBufferTasks = this.activityFinder.findByProcessId(e.getProcessId(), new String[]{"process"}).stream().filter(activity -> activity.getActivityDefinitionId().equals(activityDefId) && !activity.isOpen()).collect(Collectors.toList()))) {
                        message = "Ignoring document with id: [" + e.getDocId() + "] due to buffer task termination.";
                        log.info(message);
                        taskLog.info((Object)message);
                        e.setProcessed(true);
                        if (Boolean.TRUE.equals(deleteDocumentsFromTerminatedBufferTasks)) {
                            skanujToConnectionObject.deleteDocument(e.getDocId());
                            e.setIsDeleted(true);
                            message = "Document with id: [" + e.getDocId() + "] deleted.";
                            log.info(message);
                            taskLog.info((Object)message);
                        }
                        this.ocrDataService.update(e);
                        continue;
                    }
                }
                try {
                    ocrResult = skanujToConnectionObject.getOCRData(clientId, e.getDocId());
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    taskLog.error((Object)("Server error or invalid JSON returned from skanuj.to for document with id: [" + e.getDocId() + "]!"));
                    this.warningCounter.getAndIncrement();
                    continue;
                }
                if (ocrResult != null && ocrResult.getType() != -1) {
                    log.info("Document exists and has been processed by skanuj.to");
                    try {
                        this.storeOcrDataInDB(ocrResult, e);
                        if (process != null) {
                            this.acceptTask(e.getProcessId(), activityDefId, sActionName);
                            this.processedDocumentsCounter.getAndIncrement();
                        } else {
                            this.handleMissingProcess(e.getProcessId(), String.valueOf(e.getDocId()), taskLog);
                        }
                        if (deleteDelay == null) {
                            skanujToConnectionObject.deleteDocument(e.getDocId());
                            e.setIsDeleted(true);
                            this.ocrDataService.update(e);
                            continue;
                        }
                        log.info("Document deletion has been delayed.");
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                        taskLog.error((Object)ex.getMessage());
                        this.warningCounter.getAndIncrement();
                    }
                    continue;
                }
                message = ocrResult != null && ocrResult.getType() == -1 ? "Document with id: [" + e.getDocId() + "] is still proceeding... Skipping data retrieving." : "Document with id: [" + e.getDocId() + "] not found!";
                if (process != null && !ProcessState.isOpen((ProcessState)process.getState())) {
                    message = "Process is not open anymore. Deleting document from waiting for OCR...";
                    log.warn(message);
                    taskLog.warn((Object)message);
                    this.ocrDataService.delete(e.getId());
                }
                log.warn(message);
                taskLog.warn((Object)message);
                this.warningCounter.getAndIncrement();
            }
        }
        if (StringUtils.isNotBlank((String)deleteDelay)) {
            try {
                int deleteDelayInDays = Integer.parseInt(deleteDelay);
                List<OcrData> undeletedDocuments = this.ocrDataService.getUndeleted();
                for (OcrData e : undeletedDocuments) {
                    this.deleteDelayedDocument(deleteDelayInDays, e, skanujToConnectionObject);
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.getSummary(taskLog);
    }

    private String getOcrDataForAlphamoon(String processDefId, String activityDefId, String sActionName, String deleteDelay, Boolean ignoreTerminatedBufferTasks, Boolean deleteDocumentsFromTerminatedBufferTasks, org.apache.log4j.Logger taskLog) {
        Consumer<Activity> acceptConsumer = this.getAlphamoonAcceptConsumer(activityDefId, sActionName, deleteDelay);
        this.acceptProcessedTasks(processDefId, activityDefId, acceptConsumer);
        List<AlphamoonOcrData> docsList = this.alphamoonOcrDataService.getUnprocessed();
        docsList.forEach(ocrData -> {
            Process process = this.processService.getProcess(ocrData.getProcessId(), new String[]{"processDefinition"});
            if (this.shouldProceed(process, processDefId)) {
                if (process != null) {
                    List<Activity> terminatedBufferedTasks;
                    this.logProcessInfo(process);
                    if (Boolean.TRUE.equals(ignoreTerminatedBufferTasks) && !(terminatedBufferedTasks = this.getTerminatedBufferedTasks(activityDefId, ocrData.getProcessId())).isEmpty()) {
                        Runnable deleteDocumentAction = () -> this.alphamoonService.deleteDocument(ocrData.getCollectionId());
                        this.processTerminatedBufferTasks(this.alphamoonOcrDataService, ocrData, deleteDocumentAction, deleteDocumentsFromTerminatedBufferTasks, taskLog, ocrData.getCollectionId());
                        return;
                    }
                }
                Supplier<Optional> supplier = () -> this.alphamoonService.getOCRData(ocrData.getCollectionId());
                Optional alphamoonOcrResultDto = this.fetchOcrData(ocrData.getCollectionId(), taskLog, supplier);
                if (!alphamoonOcrResultDto.isPresent()) {
                    Runnable deleteAction = () -> this.alphamoonOcrDataService.delete(ocrData.getId());
                    this.handleMissingDocument(process, ocrData.getCollectionId(), taskLog, deleteAction);
                    return;
                }
                this.processOcrResult(process, (AlphamoonOcrResultDto)alphamoonOcrResultDto.get(), (AlphamoonOcrData)ocrData, activityDefId, sActionName, taskLog, deleteDelay);
            }
        });
        this.deleteOldDocuments(deleteDelay);
        return this.getSummary(taskLog);
    }

    private void logActivityInfo(Activity activity) {
        log.info("Activity: " + activity.getName());
        log.info("Process status: " + this.processService.getProcess(activity.getProcessId(), new String[0]).getState());
    }

    private void logProcessInfo(Process process) {
        log.info("Process: " + process.getName());
        log.info("Process status: " + process.getState());
    }

    private boolean shouldProceed(Process process, String processDefId) {
        return process == null || process.getProcessDefinition().getProcessDefinitionId().equalsIgnoreCase(processDefId) && ProcessState.isOpen((ProcessState)process.getState());
    }

    private String getSummary(org.apache.log4j.Logger taskLog) {
        taskLog.info((Object)(this.processedDocumentsCounter.get() + " documents processed."));
        return this.warningCounter.get() == 0 ? "Completed without any warnings!" : "Completed! " + this.warningCounter.get() + " warnings occurred.";
    }

    private void handleMissingProcess(String processId, String ocrId, org.apache.log4j.Logger taskLog) {
        String message = "\n\n===================================================================\nProcess with id " + processId + " does not exist!\nDeleting document " + ocrId + " from OCR...\n===================================================================\n\n";
        log.warn(message);
        taskLog.warn((Object)message);
        this.warningCounter.getAndIncrement();
    }

    private void processOcrResult(Process process, AlphamoonOcrResultDto result, AlphamoonOcrData ocrData, String activityDefId, String sActionName, org.apache.log4j.Logger taskLog, String deleteDelay) {
        block8: {
            if (!result.getStatus().equals("In Progress")) {
                try {
                    log.info("Document exists and has been processed by Alphamoon");
                    this.storeOcrDataInDB(result, ocrData);
                    if (process != null) {
                        this.acceptTask(ocrData.getProcessId(), activityDefId, sActionName);
                        this.processedDocumentsCounter.getAndIncrement();
                    } else {
                        this.handleMissingProcess(ocrData.getProcessId(), ocrData.getCollectionId(), taskLog);
                    }
                    if (deleteDelay == null) {
                        this.alphamoonService.deleteDocument(ocrData.getCollectionId());
                        ocrData.setIsDeleted(true);
                        this.alphamoonOcrDataService.update(ocrData);
                        break block8;
                    }
                    log.info("Document deletion has been delayed.");
                }
                catch (Exception e) {
                    this.handleProcessingError(e.getMessage(), e, taskLog);
                }
                break block8;
            }
            this.handleProcessingInProgress(ocrData.getCollectionId(), taskLog);
        }
    }

    private void processOcrResult(Process process, AnalyzeOperationDetails result, SuncodeOcrData ocrData, String activityDefId, String sActionName, org.apache.log4j.Logger taskLog) {
        block6: {
            if (result.getStatus().equals((Object)DocumentIntelligenceOperationStatus.SUCCEEDED)) {
                try {
                    this.storeOcrDataInDB(result, ocrData);
                    if (process != null) {
                        this.acceptTask(ocrData.getProcessId(), activityDefId, sActionName);
                        this.processedDocumentsCounter.getAndIncrement();
                        break block6;
                    }
                    this.handleMissingProcess(ocrData.getProcessId(), ocrData.getOcrRequestId(), taskLog);
                }
                catch (Exception e) {
                    this.handleProcessingError(e.getMessage(), e, taskLog);
                }
                break block6;
            }
            this.handleProcessingInProgress(ocrData.getOcrRequestId(), taskLog);
        }
    }

    private void handleProcessingError(String message, Exception e, org.apache.log4j.Logger taskLog) {
        log.error(message, (Throwable)e);
        taskLog.error((Object)e.getMessage());
        this.warningCounter.getAndIncrement();
    }

    private void handleProcessingInProgress(String ocrId, org.apache.log4j.Logger taskLog) {
        String message = "Document with id: [" + ocrId + "] is still processing. Skipping.";
        log.warn(message);
        taskLog.warn((Object)message);
        this.warningCounter.getAndIncrement();
    }

    private void handleMissingDocument(Process process, String ocrId, org.apache.log4j.Logger taskLog, Runnable deleteAction) {
        String message = "Document with id: [" + ocrId + "] not found!";
        if (process != null && !ProcessState.isOpen((ProcessState)process.getState())) {
            message = "Process is not open anymore. Deleting document from waiting for OCR...";
            log.warn(message);
            taskLog.warn((Object)message);
            deleteAction.run();
        }
        log.warn(message);
        taskLog.warn((Object)message);
        this.warningCounter.getAndIncrement();
    }

    private <T> T fetchOcrData(String ocrId, org.apache.log4j.Logger taskLog, Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            taskLog.error((Object)("Server error or invalid JSON returned from OCR service for document with request ID: [" + ocrId + "]!"));
            this.warningCounter.getAndIncrement();
            return (T)Optional.empty();
        }
    }

    private void deleteOldDocuments(String deleteDelay) {
        if (StringUtils.isNotBlank((String)deleteDelay)) {
            try {
                int deleteDelayInDays = Integer.parseInt(deleteDelay);
                List undeletedDocuments = this.alphamoonOcrDataService.getUndeleted();
                for (AlphamoonOcrData e : undeletedDocuments) {
                    this.deleteDelayedDocumentAlphamoon(deleteDelayInDays, e, this.alphamoonService);
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void acceptOpenedActivity(String processId, String activityDefId, String sActionName) {
        try {
            this.acceptTask(processId, activityDefId, sActionName);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private Consumer<Activity> getSuncodeOcrAcceptConsumer(String activityDefId, String sActionName) {
        return activity -> {
            SuncodeOcrData data = (SuncodeOcrData)this.suncodeOcrDataService.get(activity.getProcessId());
            if (data != null) {
                if (data.getProcessed() != null && data.getProcessed().booleanValue()) {
                    this.acceptOpenedActivity(activity.getProcessId(), activityDefId, sActionName);
                }
            } else {
                log.warn("Skipped: " + activity.getProcessId() + "; " + activity.getActivityDefinitionId() + " " + activity.getActivityId());
            }
        };
    }

    private Consumer<Activity> getAlphamoonAcceptConsumer(String activityDefId, String sActionName, String deleteDelay) {
        return activity -> {
            block6: {
                AlphamoonOcrData data = (AlphamoonOcrData)this.alphamoonOcrDataService.get(activity.getProcessId());
                if (data != null) {
                    if (data.getProcessed() != null && data.getProcessed().booleanValue()) {
                        this.acceptOpenedActivity(activity.getProcessId(), activityDefId, sActionName);
                        try {
                            if (deleteDelay == null) {
                                this.alphamoonService.deleteDocument(data.getCollectionId());
                                data.setIsDeleted(true);
                                this.alphamoonOcrDataService.update(data);
                                break block6;
                            }
                            log.info("Document deletion has been delayed.");
                        }
                        catch (Exception ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                } else {
                    log.warn("Skipped: " + activity.getProcessId() + "; " + activity.getActivityDefinitionId() + " " + activity.getActivityId());
                }
            }
        };
    }

    private void acceptProcessedTasks(String processDefId, String activityDefId, Consumer<Activity> acceptProcessedConsumer) {
        List<Activity> openedActivities = this.getOpenedActivities(processDefId, activityDefId);
        log.info("Opened activities");
        for (Activity openedActivity : openedActivities) {
            this.logActivityInfo(openedActivity);
            if (!openedActivity.getActivityDefinitionId().equalsIgnoreCase(activityDefId)) continue;
            acceptProcessedConsumer.accept(openedActivity);
        }
    }

    private List<Activity> getOpenedActivities(String processDefId, String activityDefId) {
        return this.findOpenActivitiesForId(processDefId, activityDefId).stream().filter(activity -> ProcessState.isOpen((ProcessState)this.processService.getProcess(activity.getProcessId(), new String[0]).getState())).collect(Collectors.toList());
    }

    private List<Activity> getTerminatedBufferedTasks(String activityDefId, String processId) {
        return this.activityFinder.findByProcessId(processId, new String[]{"process"}).stream().filter(activity -> activity.getActivityDefinitionId().equals(activityDefId) && !activity.isOpen()).collect(Collectors.toList());
    }

    private <T> void processTerminatedBufferTasks(BaseOcrDataService<T> ocrService, T ocrData, Runnable deleteDocumentAction, Boolean deleteDocumentsFromTerminatedBufferTasks, org.apache.log4j.Logger taskLog, String ocrId) {
        String message = "Ignoring document with id: [" + ocrId + "] due to buffer task termination.";
        log.info(message);
        taskLog.info((Object)message);
        ocrService.setProcessed(ocrData, true);
        if (Boolean.TRUE.equals(deleteDocumentsFromTerminatedBufferTasks)) {
            deleteDocumentAction.run();
            ocrService.setDeleted(ocrData, true);
            message = "Document with id: [" + ocrId + "] deleted.";
            log.info(message);
            taskLog.info((Object)message);
        }
        ocrService.update(ocrData);
    }

    @Transactional
    public void storeOcrDataInDB(AnalyzeOperationDetails ocrResult, SuncodeOcrData ocrData) throws IOException {
        ocrData.setJsonContent(ocrResult.toJsonString());
        ocrData.setProcessed(true);
        ocrData.setProcessedAt(new Date());
        ocrData.setPageCountFromSuncodeOcr(ocrResult.getAnalyzeResult().getPages().size());
        ocrData.setModelId(ocrResult.getAnalyzeResult().getModelId());
        this.suncodeOcrDataService.update(ocrData);
    }

    @Transactional
    public void storeOcrDataInDB(AlphamoonOcrResultDto ocrResultDto, AlphamoonOcrData ocrData) {
        AlphamoonOcrDataMapper.map(ocrResultDto, ocrData);
        this.alphamoonOcrDataService.update(ocrData);
        for (AlphamoonItemsTableDto rowDto : ocrResultDto.getRows()) {
            AlphamoonItemsTable tableRow = new AlphamoonItemsTable();
            tableRow.setUnit(rowDto.getTableItemsUnit());
            tableRow.setAmount(rowDto.getTableItemsAmount());
            tableRow.setPosition(rowDto.getTableItemsPosition());
            tableRow.setQuantity(rowDto.getTableItemsQuantity());
            tableRow.setTaxRate(rowDto.getTableItemsTaxRate());
            tableRow.setNetAmount(rowDto.getTableItemsNetAmount());
            tableRow.setTaxAmount(rowDto.getTableItemsTaxAmount());
            tableRow.setUnitPrice(rowDto.getTableItemsUnitPrice());
            tableRow.setDescription(rowDto.getTableItemsDescription());
            tableRow.setProductCode(rowDto.getTableItemsProductCode());
            tableRow.setNetUnitPrice(rowDto.getTableItemsNetUnitPrice());
            tableRow.setPurchaseOrderNumber(rowDto.getTableItemsPurchaseOrderNumber());
            tableRow.setExtraData(rowDto.getAdditionalProperties());
            tableRow.setOcrData(ocrData);
            this.alphamoonItemsTableService.save(tableRow);
        }
    }

    @Transactional
    public void storeOcrDataInDB(OcrResult data, OcrData ocrDataObject) {
        OcrDataMapper.map(data, ocrDataObject);
        this.ocrDataService.update(ocrDataObject);
        PositionRow row = new PositionRow();
        for (Position position : data.getPositions()) {
            row.setpBrutto(position.getBrutto() != null ? BigDecimal.valueOf(position.getBrutto()).setScale(2, RoundingMode.HALF_UP).toPlainString() : "");
            row.setpCena(position.getCena() != null ? BigDecimal.valueOf(position.getCena()).setScale(2, RoundingMode.HALF_UP).toPlainString() : "");
            row.setpIlosc(position.getIlosc() != null ? position.getIlosc().toString() : "");
            row.setpJednostka(position.getJednostka() != null ? position.getJednostka() : "");
            row.setpNazwa(position.getNazwa() != null ? position.getNazwa() : "");
            row.setpNetto(position.getNetto() != null ? BigDecimal.valueOf(position.getNetto()).setScale(2, RoundingMode.HALF_UP).toPlainString() : "");
            row.setpStawkaVAT(position.getStawkaVAT() != null ? position.getStawkaVAT().toString() : "");
            row.setpVAT(position.getVat() != null ? BigDecimal.valueOf(position.getVat()).setScale(2, RoundingMode.HALF_UP).toPlainString() : "");
            row.setData(ocrDataObject);
            this.positionRowService.save(row);
        }
    }

    private void acceptTask(String processId, String activityDefId, String sActionName) {
        String approverLogin = SystemProperties.getString((String)"Bufor.username");
        ActivityService activityService = ServiceFactory.getActivityService();
        AssignmentService assignmentService = ServiceFactory.getAssignmentService();
        List activities = this.activityFinder.findOpenedActivities(processId);
        for (Activity activity : activities) {
            if (activity.getActivityDefinitionId().equalsIgnoreCase(activityDefId)) {
                String activityId = activity.getActivityId();
                String actionName = StringUtils.isNotBlank((String)sActionName) ? sActionName : activity.getName();
                assignmentService.assignActivityToUser(processId, activityId, approverLogin);
                AcceptationDefinition acceptation = new AcceptationDefinition(processId, activityId, approverLogin, actionName);
                acceptation.setIgnoreOwnerShip(Boolean.valueOf(true));
                activityService.acceptActivity(acceptation);
                continue;
            }
            throw new Exception("Activity '" + activityDefId + "' not found!");
        }
    }

    private void deleteDelayedDocument(int days, OcrData e, SkanujToConnection obj) throws Exception {
        if (e == null || e.getProcessedAt() == null) {
            return;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(e.getProcessedAt());
        c.add(5, days);
        if (new Date().after(c.getTime())) {
            obj.deleteDocument(e.getDocId());
            e.setIsDeleted(true);
            this.ocrDataService.update(e);
            log.info("Document " + e.getDocId() + " deleted.");
        }
    }

    private void deleteDelayedDocumentAlphamoon(int days, AlphamoonOcrData ocrData, AlphamoonService alphamoonService) {
        if (ocrData == null || ocrData.getProcessedAt() == null) {
            return;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(ocrData.getProcessedAt());
        c.add(5, days);
        if (new Date().after(c.getTime())) {
            alphamoonService.deleteDocument(ocrData.getCollectionId());
            ocrData.setIsDeleted(true);
            this.alphamoonOcrDataService.update(ocrData);
            log.info("Document " + ocrData.getCollectionId() + " deleted.");
        }
    }

    @Transactional(readOnly=true)
    public List<Activity> findOpenActivitiesForId(String processDefId, String activityDefId) {
        SQLFinder finder = FinderFactory.getSQLFinder();
        String query = "select activities.id from activities inner join processes on activities.processid = processes.id inner join processdefinitions on processes.pdefname = processdefinitions.name";
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery(query);
        builder.addScalar("id", StandardBasicTypes.STRING);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("activities.activitydefinitionid", (Object)activityDefId, FilterOperator.EQ));
        GroupSQLFilter stateFilter = new GroupSQLFilter(LogicOperator.OR);
        stateFilter.addFilter(new SQLFilter[]{new SimpleSQLFilter("activities.state", (Object)1000001L, FilterOperator.EQ)});
        stateFilter.addFilter(new SQLFilter[]{new SimpleSQLFilter("activities.state", (Object)1000003L, FilterOperator.EQ)});
        builder.addFilter((SQLFilter)stateFilter);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("processdefinitions.processdefinitionid", (Object)processDefId, FilterOperator.EQ));
        log.debug("Query parameters: " + activityDefId + ", " + 1000001L + ", " + 1000003L + ", " + processDefId);
        List activitiesWaitingForOcr = finder.find(builder).stream().map(idWrapper -> (String)idWrapper.get("id")).collect(Collectors.toList());
        if (activitiesWaitingForOcr.isEmpty()) {
            return Collections.emptyList();
        }
        int maxNumberOfInClauseParameters = NativeDatabase.getImplementation().getMaxNumberOfInClauseParameters();
        if (activitiesWaitingForOcr.size() > maxNumberOfInClauseParameters) {
            List partitions = Lists.partition(activitiesWaitingForOcr, (int)maxNumberOfInClauseParameters);
            return partitions.stream().map(partition -> {
                HibernateCriteria criteria = HibernateCriteria.forClass(Activity.class);
                criteria.add(Restrictions.in((String)"activityId", (Collection)partition));
                return this.hibernateCriteriaExecutor.findByCriteria(criteria);
            }).flatMap(Collection::stream).collect(Collectors.toList());
        }
        HibernateCriteria criteria = HibernateCriteria.forClass(Activity.class);
        criteria.add(Restrictions.in((String)"activityId", activitiesWaitingForOcr));
        return this.hibernateCriteriaExecutor.findByCriteria(criteria);
    }
}

