/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.watermark.hook;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.MediaType;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.watermark.configuration.dto.AddWatermarkConfigDto;
import com.suncode.plugin.watermark.configuration.dto.WatermarkBarcodeDto;
import com.suncode.plugin.watermark.configuration.dto.WatermarkDto;
import com.suncode.plugin.watermark.configuration.enums.ErrorHandling;
import com.suncode.plugin.watermark.configuration.enums.WatermarkType;
import com.suncode.plugin.watermark.hook.exception.WatermarkException;
import com.suncode.plugin.watermark.hook.exception.message.ErrorMessage;
import com.suncode.plugin.watermark.service.WatermarkPDFModifier;
import com.suncode.plugin.watermark.service.WatermarkService;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.hook.annotation.Hook;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.support.OpenedFileContext;
import com.suncode.pwfl.workflow.support.ReadFileHookAdapter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Hook
public class AddWatermarkToDocumentHook
extends ReadFileHookAdapter {
    private static final Logger log = LoggerFactory.getLogger(AddWatermarkToDocumentHook.class);
    public static final String READABLE_FILE_ID = "config";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private WatermarkService watermarkService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private WatermarkPDFModifier pdfModifier;
    @Autowired
    private ConfigurationFileService configurationFileService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private Plugin plugin;

    public OpenedFileContext execute(OpenedFileContext fileContext) {
        byte[] bytes = IOUtils.toByteArray((InputStream)fileContext.getInputStream());
        ErrorHandling errorHandling = ErrorHandling.BLOCK;
        try {
            fileContext.setInputStream((InputStream)new ByteArrayInputStream(bytes));
            List<AddWatermarkConfigDto> watermarkConfigList = this.readHookConfigurations();
            UserInfo user = UserContext.isActive() ? UserContext.current().getUser() : null;
            WfFile wfFile = fileContext.getWfFile();
            Long documentClassId = wfFile.getDocumentClass().getId();
            WfDocument document = this.documentService.getDocument(Long.valueOf(wfFile.getId()));
            for (AddWatermarkConfigDto config : watermarkConfigList) {
                boolean hasUserPermissions = this.isUserPermitted(user, config);
                if (!documentClassId.equals(config.getDocumentClassId()) || !hasUserPermissions || !fileContext.getMimeType().equals(MediaType.PDF.toString()) || !this.displayWatermarkOnCurrentTask(fileContext, config)) continue;
                this.validateConfiguration(config);
                errorHandling = config.getErrorHandling();
                this.addWatermarkToDocument(fileContext, document, config);
            }
        }
        catch (Exception e) {
            log.error("An error occurred while adding a watermark in the file with id: " + fileContext.getWfFile().getId() + ", activity id: " + fileContext.getActivityId() + ", process id: " + fileContext.getProcessId(), (Throwable)e);
            switch (errorHandling) {
                case BLOCK: {
                    this.loadHtmlErrorPage(fileContext, e);
                    break;
                }
                case DISPLAY_ORIGINAL: {
                    fileContext.setInputStream((InputStream)new ByteArrayInputStream(bytes));
                }
            }
        }
        return fileContext;
    }

    private void addWatermarkToDocument(OpenedFileContext fileContext, WfDocument document, AddWatermarkConfigDto config) throws WatermarkException {
        WatermarkDto watermark = config.getWatermark();
        String textValue = this.watermarkService.resolveValueToEncode(document, watermark.getText(), fileContext.getProcessId(), fileContext.getActivityId());
        this.watermarkService.resolveWatermarkPageSelection(watermark);
        config.getWatermark().setText(textValue);
        String fileName = fileContext.getWfFile().getFileName();
        WatermarkType type = watermark.getType();
        InputStream modifiedStream = null;
        switch (type) {
            case BARCODE: {
                this.updateTextUnderBarcode(config);
                this.watermarkService.resolveBarcodeRotationMechanism(watermark);
                modifiedStream = this.pdfModifier.addBarcodeToDocument(fileContext.getInputStream(), watermark, fileName, config.getRemovePDFSecurity());
                fileContext.setInputStream(modifiedStream);
                break;
            }
            case TEXT: {
                modifiedStream = this.pdfModifier.addTextToDocument(fileContext.getInputStream(), watermark, fileName, config.getRemovePDFSecurity());
            }
        }
        fileContext.setInputStream(modifiedStream);
        IOUtils.closeQuietly(modifiedStream);
    }

    private void validateConfiguration(AddWatermarkConfigDto config) throws WatermarkException {
        try {
            Assert.notNull((Object)config.getDocumentClassId(), (String)"DocumentClassId cannot be null");
            Assert.notNull((Object)((Object)config.getErrorHandling()), (String)"ErrorHandling cannot be null");
            WatermarkDto watermark = config.getWatermark();
            Assert.notNull((Object)((Object)watermark.getType()), (String)"Parameter type cannot be null");
            Assert.hasLength((String)watermark.getText(), (String)"Parameter text cannot be null or empty string");
            Assert.notNull((Object)watermark.getPositionX(), (String)"Parameter positionX% cannot be null");
            Assert.isTrue((watermark.getPositionX() >= 0 && watermark.getPositionX() <= 100 ? 1 : 0) != 0, (String)"Parameter positionX% value must be between 0 and 100");
            Assert.notNull((Object)watermark.getPositionY(), (String)"PositionY% cannot be null");
            Assert.isTrue((watermark.getPositionY() >= 0 && watermark.getPositionY() <= 100 ? 1 : 0) != 0, (String)"Parameter positionY% value must be between 0 and 100");
            Assert.notNull((Object)watermark.getOpacity(), (String)"Parameter opacity cannot be null");
            Assert.notNull((Object)watermark.getClockwiseAngle(), (String)"Parameter clockwiseAngle cannot be null");
            Assert.notNull((Object)watermark.getAlignment(), (String)"Parameter alignment cannot be null");
            Assert.notNull((Object)watermark.getAnchor(), (String)"Parameter anchor cannot be null");
            if (watermark.getType().equals((Object)WatermarkType.BARCODE)) {
                Assert.notNull((Object)watermark.getWatermarkBarcode().getFormat(), (String)"Parameter format cannot be null");
                Assert.notNull((Object)watermark.getWatermarkBarcode().getCodeWidth(), (String)"Parameter codeWidth cannot be null");
                Assert.notNull((Object)watermark.getWatermarkBarcode().getCodeHeight(), (String)"Parameter codeHeight cannot be null");
                Assert.notNull((Object)watermark.getWatermarkBarcode().getTextUnderBarcode(), (String)"Parameter textUnderBarcode cannot be null");
            } else if (watermark.getType().equals((Object)WatermarkType.TEXT)) {
                Assert.notNull((Object)watermark.getWatermarkText().getFontSize(), (String)"Parameter fontSize cannot be null");
                Assert.notNull((Object)watermark.getWatermarkText().getEncoding(), (String)"Parameter encoding cannot be null");
                Assert.notNull((Object)watermark.getWatermarkText().getFontType(), (String)"Parameter fontType cannot be null");
                Assert.notNull((Object)watermark.getWatermarkText().getFontColor(), (String)"Parameter fontColor cannot be null");
            }
        }
        catch (IllegalArgumentException iae) {
            throw new WatermarkException(ErrorMessage.INCORRECT_JSON_CONFIGURATION, "Incorrect JSON configuration", iae);
        }
    }

    private boolean isUserPermitted(UserInfo user, AddWatermarkConfigDto config) {
        if (user == null || config.getPermissions() == null || config.getPermissions().getGroups() == null) {
            return true;
        }
        return config.getPermissions().getGroups().stream().anyMatch(groupName -> user.getGroups().stream().anyMatch(groupInfo -> groupInfo.getName().equals(groupName)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AddWatermarkConfigDto> readHookConfigurations() throws WatermarkException {
        try (InputStream in = this.configurationFileService.readFile(this.plugin.getKey(), READABLE_FILE_ID);){
            String hookConfigurations = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isBlank((String)hookConfigurations)) {
                ArrayList<AddWatermarkConfigDto> arrayList = new ArrayList<AddWatermarkConfigDto>();
                return arrayList;
            }
            List list = (List)objectMapper.readValue(hookConfigurations, (TypeReference)new TypeReference<List<AddWatermarkConfigDto>>(){});
            return list;
        }
        catch (IOException e) {
            throw new WatermarkException(ErrorMessage.INCORRECT_JSON_CONFIGURATION, "Incorrect JSON configuration", e);
        }
    }

    private void updateTextUnderBarcode(AddWatermarkConfigDto config) {
        WatermarkBarcodeDto watermark = config.getWatermark().getWatermarkBarcode();
        boolean textUnderBarcode = watermark.getTextUnderBarcode() != null && watermark.getTextUnderBarcode() != false;
        config.getWatermark().getWatermarkBarcode().setTextUnderBarcode(textUnderBarcode);
    }

    private void loadHtmlErrorPage(OpenedFileContext fileContext, Exception e) {
        ErrorMessage errorMessage = ErrorMessage.UNEXPECTED_ERROR;
        if (e instanceof WatermarkException) {
            WatermarkException we = (WatermarkException)e;
            errorMessage = we.getErrorType();
        }
        ClassLoader classLoader = AddWatermarkToDocumentHook.class.getClassLoader();
        try (InputStream stream = classLoader.getResourceAsStream("template/hook_error_message_page.html");){
            String contentFile = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            contentFile = errorMessage.name().equals(ErrorMessage.INCORRECT_JSON_CONFIGURATION.name()) ? contentFile.replace("@message@", errorMessage.getNameWithExceptionCause(e.getCause().getMessage())) : contentFile.replace("@message@", errorMessage.getName());
            ByteArrayInputStream modifiedStream = new ByteArrayInputStream(contentFile.getBytes());
            fileContext.setInputStream((InputStream)modifiedStream);
            fileContext.setMimeType(MediaType.HTML_UTF_8.toString());
            IOUtils.closeQuietly((InputStream)modifiedStream);
        }
    }

    private boolean displayWatermarkOnCurrentTask(OpenedFileContext fileContext, AddWatermarkConfigDto config) {
        if (config.getWatermarkVisibilityTasks() == null) {
            return true;
        }
        Activity activity = this.activityService.getActivity(fileContext.getProcessId(), fileContext.getActivityId(), new String[]{"process"});
        if (activity == null) {
            return config.getWatermarkVisibilityTasks().stream().anyMatch(task -> task.getProcessDefId().equals("*") && task.getActivityDefId().equals("*"));
        }
        String activityDefinitionId = activity.getActivityDefinitionId();
        String processDefinitionId = activity.getProcess().getProcessDefinition().getProcessDefinitionId();
        return config.getWatermarkVisibilityTasks().stream().anyMatch(task -> !(!task.getProcessDefId().equals("*") && !task.getProcessDefId().equals(processDefinitionId) || !task.getActivityDefId().equals("*") && !task.getActivityDefId().equals(activityDefinitionId)));
    }
}

