/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.watermark.configuration.controller;

import com.suncode.plugin.watermark.configuration.dto.ComboBoxElementDto;
import com.suncode.plugin.watermark.configuration.enums.Alignment;
import com.suncode.plugin.watermark.configuration.enums.Anchor;
import com.suncode.plugin.watermark.configuration.enums.ElementColor;
import com.suncode.plugin.watermark.configuration.enums.ElementParam;
import com.suncode.plugin.watermark.configuration.enums.Encoding;
import com.suncode.plugin.watermark.configuration.enums.FontType;
import com.suncode.plugin.watermark.configuration.enums.PageSelection;
import com.suncode.plugin.watermark.configuration.enums.RotationMechanism;
import com.suncode.plugin.watermark.configuration.enums.WatermarkBarcodeFormat;
import com.suncode.pwfl.search.CountedResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/config"})
public class WatermarkConfigurationController {
    @RequestMapping(value={"alignments"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getAlignmentList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.getElementList(query, start, limit, Alignment.values());
    }

    @RequestMapping(value={"anchors"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getAnchorList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.getElementList(query, start, limit, Anchor.values());
    }

    @RequestMapping(value={"barcodeFormats"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getBarcodeFormatList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.getElementList(query, start, limit, WatermarkBarcodeFormat.values());
    }

    @RequestMapping(value={"rotationMechanism"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getRotationMechanismList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.getElementList(query, start, limit, RotationMechanism.values());
    }

    @RequestMapping(value={"fontTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getFontTypeList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.getElementList(query, start, limit, FontType.values());
    }

    @RequestMapping(value={"colors"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getColorList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.getElementList(query, start, limit, ElementColor.values());
    }

    @RequestMapping(value={"encodings"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getEncodingList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.getElementList(query, start, limit, Encoding.values());
    }

    @RequestMapping(value={"pageSelections"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getPageSelectionList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.getElementList(query, start, limit, PageSelection.values());
    }

    private CountedResult<ComboBoxElementDto> getElementList(String query, Integer start, Integer limit, ElementParam[] enumList) {
        List elementsDto = Arrays.stream(enumList).map(element -> element.build()).collect(Collectors.toList());
        ArrayList result = new ArrayList();
        for (int i = start.intValue(); i < elementsDto.size() && i < limit; ++i) {
            if (((ComboBoxElementDto)elementsDto.get(i)).getName().isEmpty()) {
                if (!StringUtils.isBlank((String)query) && !((ComboBoxElementDto)elementsDto.get(i)).getValue().toLowerCase().contains(query.toLowerCase())) continue;
                result.add(elementsDto.get(i));
                continue;
            }
            if (!StringUtils.isBlank((String)query) && !((ComboBoxElementDto)elementsDto.get(i)).getName().toLowerCase().contains(query.toLowerCase()) && !((ComboBoxElementDto)elementsDto.get(i)).getValue().toLowerCase().contains(query.toLowerCase())) continue;
            result.add(elementsDto.get(i));
        }
        return new CountedResult((long)elementsDto.size(), result);
    }
}

