PWE.integrationComponent.registerApplication('watermark.add-watermark-to-document-app', {
    apiVersion: 2,
    buildForm: function (form) {
        addFilesSourceSettings(form);
        form.addCombobox({
            id: "watermarkType",
            values: [
                {id: "BARCODE", display: Watermark.t("watermark.add-watermark-to-document-app.barcode")},
                {id: "TEXT", display: Watermark.t("watermark.add-watermark-to-document-app.text")}
            ],
            listeners: {
                change: function (value) {
                    if (value === "BARCODE") {
                        form.setNotEmpty("format", true);
                        form.setNotEmpty("barcodeWidth", true);
                        form.setNotEmpty("barcodeHeight", true);
                        form.setNotEmpty("textUnderBarcode", true);
                        form.show("barcode-settings-fs");
                        form.setNotEmpty("fontSize", false);
                        form.setNotEmpty("fontType", false);
                        form.setNotEmpty("fontColor", false);
                        form.setNotEmpty("encoding", false);
                        form.hide("text-settings-fs");
                    } else if (value === "TEXT") {
                        form.setNotEmpty("fontSize", true);
                        form.setNotEmpty("fontType", true);
                        form.setNotEmpty("fontColor", true);
                        form.setNotEmpty("encoding", true);
                        form.show("text-settings-fs");
                        form.setNotEmpty("format", false);
                        form.setNotEmpty("barcodeWidth", false);
                        form.setNotEmpty("barcodeHeight", false);
                        form.setNotEmpty("textUnderBarcode", false);
                        form.hide("barcode-settings-fs");
                    } else if (form.hasFunctionValue("watermarkType") || form.hasVariableValue("watermarkType")) {
                        form.setNotEmpty("fontSize", false);
                        form.setNotEmpty("fontType", false);
                        form.setNotEmpty("fontColor", false);
                        form.setNotEmpty("encoding", false);
                        form.show("text-settings-fs");
                        form.setNotEmpty("format", false);
                        form.setNotEmpty("barcodeWidth", false);
                        form.setNotEmpty("barcodeHeight", false);
                        form.setNotEmpty("textUnderBarcode", false);
                        form.show("barcode-settings-fs");
                    } else {
                        form.setNotEmpty("format", false);
                        form.setNotEmpty("barcodeWidth", false);
                        form.setNotEmpty("barcodeHeight", false);
                        form.setNotEmpty("textUnderBarcode", false);
                        form.hide("barcode-settings-fs");
                        form.setNotEmpty("fontSize", false);
                        form.setNotEmpty("fontType", false);
                        form.setNotEmpty("fontColor", false);
                        form.setNotEmpty("encoding", false);
                        form.hide("text-settings-fs");
                    }
                }
            }
        });
        form.addField("text");
        Watermark.addComboboxAlignmentList("alignment", form, null);
        Watermark.addComboboxAnchorList("anchor", form, null);
        form.addField("positionX");
        form.addField("positionY");
        form.addField("opacity");
        form.addField("rotation");
        form.addField("removeFileSecurity");
        addBarcodeSettings(form);
        addTextSettings(form);
        afterFormLoad(form);
    },
    validateForm: function (api) {
        var positionX = api.getValue("positionX");
        if (positionX < 0 || positionX > 100) {
            api.markError("positionX");
            api.showErrorMessage(Watermark.t("watermark.add-watermark-to-document-app.error-position-percent"));
            return false;
        }
        var positionY = api.getValue("positionY");
        if (positionY < 0 || positionY > 100) {
            api.markError("positionY");
            api.showErrorMessage(Watermark.t("watermark.add-watermark-to-document-app.error-position-percent"));
            return false;
        }
    }
});

function addBarcodeSettings(form) {
    var barcodeSettings = form.addFieldSet({
        id: "barcode-settings-fs",
        collapsible: false,
        collapsed: false,
        title: Watermark.t("watermark.add-watermark-to-document-app.barcode-settings")
    });
    Watermark.addComboboxBarcodeFormatList("format", barcodeSettings, null);
    barcodeSettings.addField("barcodeWidth");
    barcodeSettings.addField("barcodeHeight");
    barcodeSettings.addField("textUnderBarcode");
    Watermark.addComboboxRotationMechanismList("rotationMechanism", barcodeSettings, null);
};

function addTextSettings(form) {
    var textSettings = form.addFieldSet({
        id: "text-settings-fs",
        collapsible: false,
        collapsed: false,
        title: Watermark.t("watermark.add-watermark-to-document-app.text-settings")
    });
    textSettings.addField("fontSize");
    Watermark.addComboboxFontTypeList("fontType", textSettings, null);
    Watermark.addComboboxColorList("fontColor", textSettings, null);
    Watermark.addComboboxEncodingList("encoding", textSettings, null);
    Watermark.addComboboxColorList("textBackgroundColor", textSettings, null);
};

function addFilesSourceSettings(form) {
    let filesSourceSettings = form.addFieldSet({
        id: "files-source-settings-fs",
        collapsible: false,
        collapsed: false,
        title: Watermark.t("watermark.add-watermark-to-document-app.files-source-settings")
    });
    filesSourceSettings.addCombobox({
        id: "filesSource",
        values: [
            {id: "DOCUMENTCLASS", display: Watermark.t("watermark.add-watermark-to-document-app.files-source.option.document-class")},
            {id: "FILEIDS", display: Watermark.t("watermark.add-watermark-to-document-app.files-source.option.file-ids")},
            {id: "DOCUMENTIDS", display: Watermark.t("watermark.add-watermark-to-document-app.files-source.option.document-ids")}
        ],
        listeners: {
            change: function (value) {
                if (value === "DOCUMENTCLASS") {
                    toggleFieldsWhenFilesSourceIsDocumentClass(filesSourceSettings);
                } else if (value === "FILEIDS") {
                    toggleFieldsWhenFilesSourceIsFileIds(filesSourceSettings);
                } else if (value === "DOCUMENTIDS") {
                    toggleFieldsWhenFilesSourceIsDocumentIds(filesSourceSettings);
                } else if (filesSourceSettings.hasVariableValue("filesSource") || filesSourceSettings.hasFunctionValue("filesSource")) {
                    toggleFieldsWhenFilesSourceIsVariableOrFunction(filesSourceSettings);
                } else {
                    toggleFieldsWhenFilesSourceIsUndefined(filesSourceSettings);
                }
            }
        }
    });
    Watermark.addComboboxClassList("documentClass", filesSourceSettings, null);
    filesSourceSettings.addField("fileIds");
    Watermark.addComboboxClassList("documentClassDocumentIds", filesSourceSettings, null);
    filesSourceSettings.addField("documentIds");
    afterFilesSourceSettingsLoad(filesSourceSettings);
}

function toggleFieldsWhenFilesSourceIsDocumentClass(form) {
    form.setNotEmpty("documentClass", true);
    form.show("documentClass");
    form.setNotEmpty("fileIds", false);
    form.hide("fileIds");
    form.setNotEmpty("documentClassDocumentIds", false);
    form.hide("documentClassDocumentIds");
    form.setNotEmpty("documentIds", false);
    form.hide("documentIds");
}

function toggleFieldsWhenFilesSourceIsFileIds(form) {
    form.setNotEmpty("fileIds", true);
    form.show("fileIds");
    form.setNotEmpty("documentClass", false);
    form.hide("documentClass");
    form.setNotEmpty("documentClassDocumentIds", false);
    form.hide("documentClassDocumentIds");
    form.setNotEmpty("documentIds", false);
    form.hide("documentIds");
}

function toggleFieldsWhenFilesSourceIsDocumentIds(form) {
    form.setNotEmpty("documentClassDocumentIds", true);
    form.show("documentClassDocumentIds");
    form.setNotEmpty("documentIds", true);
    form.show("documentIds");
    form.setNotEmpty("documentClass", false);
    form.hide("documentClass");
    form.setNotEmpty("fileIds", false);
    form.hide("fileIds");
}

function toggleFieldsWhenFilesSourceIsVariableOrFunction(form) {
    form.setNotEmpty("documentClassDocumentIds", false);
    form.show("documentClassDocumentIds");
    form.setNotEmpty("documentIds", false);
    form.show("documentIds");
    form.setNotEmpty("documentClass", false);
    form.show("documentClass");
    form.setNotEmpty("fileIds", false);
    form.show("fileIds");
}

function toggleFieldsWhenFilesSourceIsUndefined(form) {
    form.setNotEmpty("documentClassDocumentIds", false);
    form.hide("documentClassDocumentIds");
    form.setNotEmpty("documentIds", false);
    form.hide("documentIds");
    form.setNotEmpty("documentClass", false);
    form.hide("documentClass");
    form.setNotEmpty("fileIds", false);
    form.hide("fileIds");
}

function afterFilesSourceSettingsLoad(form) {
    if (form.getValue("filesSource") === "DOCUMENTCLASS") {
        toggleFieldsWhenFilesSourceIsDocumentClass(form);
    } else if (form.getValue("filesSource") === "FILEIDS") {
        toggleFieldsWhenFilesSourceIsFileIds(form);
    } else if (form.getValue("filesSource") === "DOCUMENTIDS") {
        toggleFieldsWhenFilesSourceIsDocumentIds(form);
    } else if (form.hasVariableValue("filesSource") || form.hasFunctionValue("filesSource")) {
        toggleFieldsWhenFilesSourceIsVariableOrFunction(form);
    } else {
        toggleFieldsWhenFilesSourceIsUndefined(form);
    }
}

function afterFormLoad(form) {
    if (form.getValue("watermarkType") === "BARCODE") {
        form.setNotEmpty("format", true);
        form.setNotEmpty("barcodeWidth", true);
        form.setNotEmpty("barcodeHeight", true);
        form.setNotEmpty("textUnderBarcode", true);
        form.show("barcode-settings-fs");
        form.setNotEmpty("fontSize", false);
        form.setNotEmpty("fontType", false);
        form.setNotEmpty("fontColor", false);
        form.setNotEmpty("encoding", false);
        form.hide("text-settings-fs");
    } else if (form.getValue("watermarkType") === "TEXT") {
        form.setNotEmpty("fontSize", true);
        form.setNotEmpty("fontType", true);
        form.setNotEmpty("fontColor", true);
        form.setNotEmpty("encoding", true);
        form.show("text-settings-fs");
        form.setNotEmpty("format", false);
        form.setNotEmpty("barcodeWidth", false);
        form.setNotEmpty("barcodeHeight", false);
        form.setNotEmpty("textUnderBarcode", false);
        form.hide("barcode-settings-fs");
    } else if (form.hasFunctionValue("watermarkType") || form.hasVariableValue("watermarkType")) {
        form.setNotEmpty("fontSize", false);
        form.setNotEmpty("fontType", false);
        form.setNotEmpty("fontColor", false);
        form.setNotEmpty("encoding", false);
        form.show("text-settings-fs");
        form.setNotEmpty("format", false);
        form.setNotEmpty("barcodeWidth", false);
        form.setNotEmpty("barcodeHeight", false);
        form.setNotEmpty("textUnderBarcode", false);
        form.show("barcode-settings-fs");
    } else {
        form.setNotEmpty("format", false);
        form.setNotEmpty("barcodeWidth", false);
        form.setNotEmpty("barcodeHeight", false);
        form.setNotEmpty("textUnderBarcode", false);
        form.hide("barcode-settings-fs");
        form.setNotEmpty("fontSize", false);
        form.setNotEmpty("fontType", false);
        form.setNotEmpty("fontColor", false);
        form.setNotEmpty("encoding", false);
        form.hide("text-settings-fs");
    }
}