/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.watermark.document.service.impl;

import com.suncode.plugin.watermark.document.dto.DocumentClassDto;
import com.suncode.plugin.watermark.document.service.WatermarkDocumentService;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WatermarkDocumentServiceImpl
implements WatermarkDocumentService {
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentClassService docClassService;
    @Autowired
    private FileService fileService;

    @Override
    public void addDocumentAsNewVersion(WfDocument document, InputStream stream, ApplicationContext context) throws Exception {
        DocumentDefinition definition = this.createNewDocumentDefinition(document, stream, context);
        Long originalDocumentFileId = document.getFile().getId();
        String currentDocState = this.fileService.getVersionForFile(originalDocumentFileId).getState();
        if (currentDocState.equals(WfFileVersion.State.STATE_EDIT.toString())) {
            this.fileService.cancelCheckOut(originalDocumentFileId);
        }
        this.fileService.checkOut(originalDocumentFileId, UserContext.current().getUser().getUserName());
        this.fileService.checkIn(definition, originalDocumentFileId, "");
    }

    @Override
    public List<WfDocument> getDocumentsFromProcessAndClass(String docClassName, ApplicationContext context) {
        List allDocumentsFromProcess = this.documentFinder.getDocumentsFromActivity(context.getProcessId(), context.getActivityId(), new String[]{"documentClass"});
        DocumentClass documentClass = this.docClassService.getDocumentClass(docClassName, new String[0]);
        return allDocumentsFromProcess.stream().filter(document -> document.getDocumentClassId().equals(documentClass.getId())).collect(Collectors.toList());
    }

    @Override
    public CountedResult<DocumentClassDto> getDocumentClasses(String query, Integer start, Integer limit) {
        if (StringUtils.isNumeric((CharSequence)query)) {
            DocumentClass documentClass2 = (DocumentClass)this.docClassService.get((Serializable)Long.valueOf(Long.parseLong(query)));
            if (documentClass2 != null) {
                DocumentClassDto documentClassDto = DocumentClassDto.builder().id(documentClass2.getId()).name(documentClass2.getName()).build();
                return new CountedResult(1L, Collections.singletonList(documentClassDto));
            }
            return new CountedResult();
        }
        List documentClasses = this.docClassService.getAll(new String[0]).stream().filter(documentClass -> documentClass.getName().toLowerCase().contains(query.toLowerCase())).sorted(Comparator.comparing(DocumentClass::getName)).collect(Collectors.toList());
        List documentClassesDto = documentClasses.stream().map(documentClass -> new DocumentClassDto(documentClass.getId(), documentClass.getName())).collect(Collectors.toList());
        CountedResult result = new CountedResult();
        if (documentClassesDto.size() >= start) {
            result.setData(documentClassesDto.subList(start, Integer.min(start + limit, documentClassesDto.size())));
        } else {
            result.setData(Collections.emptyList());
        }
        result.setTotal((long)documentClassesDto.size());
        return result;
    }

    private DocumentDefinition createNewDocumentDefinition(WfDocument document, InputStream stream, ApplicationContext appContext) {
        WfFile file = document.getFile();
        DocumentDefinition definition = new DocumentDefinition();
        definition.setDocumentClassId(document.getDocumentClassId());
        definition.setFileName(file.getFileName());
        definition.setDescription(file.getDescription());
        definition.setUserName(file.getUploader());
        definition.setIndexes(this.getIndexes(document));
        definition.setInputStream(stream);
        definition.setProcessId(appContext.getProcessId());
        definition.setSaveAsNewVersion(true);
        return definition;
    }

    private Map<Long, Object> getIndexes(WfDocument document) {
        return document.getIndexes().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(IndexInfo::getId, IndexInfo::getValue));
    }
}

