/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.watermark.upgrade;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.watermark.configuration.dto.AddWatermarkConfigDto;
import com.suncode.plugin.watermark.configuration.enums.ElementColor;
import com.suncode.plugin.watermark.configuration.enums.ErrorHandling;
import com.suncode.plugin.watermark.configuration.enums.WatermarkType;
import com.suncode.plugin.watermark.util.PlusWatermarkSpringContext;
import com.suncode.upgrader.change.task.Task;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class PCMJsonConfigUpdater
implements Task {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private List<AddWatermarkConfigDto> configurations = new ArrayList<AddWatermarkConfigDto>();

    public void run() throws Exception {
        Plugin plugin;
        ConfigurationFileService configurationFileService = PlusWatermarkSpringContext.getBean(ConfigurationFileService.class);
        String configurationText = this.readJsonConfiguration(configurationFileService, plugin = PlusWatermarkSpringContext.getBean(Plugin.class));
        if (StringUtils.isBlank((String)configurationText)) {
            return;
        }
        this.configurations = (List)objectMapper.readValue(configurationText, (TypeReference)new TypeReference<List<AddWatermarkConfigDto>>(){});
        this.updateConfigurationFields();
        this.saveJsonConfiguration(configurationFileService, plugin);
    }

    public void rollback() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readJsonConfiguration(ConfigurationFileService configurationFileService, Plugin plugin) {
        try (InputStream stream = configurationFileService.readFile(plugin.getKey(), "config");){
            String string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    private void updateConfigurationFields() {
        this.configurations = this.configurations.stream().map(configuration -> {
            WatermarkType type = configuration.getWatermark().getType();
            if (type.equals((Object)WatermarkType.BARCODE)) {
                configuration.getWatermark().setClockwiseAngle(Float.valueOf(0.0f));
                configuration.getWatermark().getWatermarkBarcode().setTextUnderBarcode(false);
            } else if (type.equals((Object)WatermarkType.TEXT)) {
                Float clockwiseAngle = configuration.getWatermark().getWatermarkText().getClockwiseAngle();
                configuration.getWatermark().getWatermarkText().setClockwiseAngle(null);
                configuration.getWatermark().setClockwiseAngle(clockwiseAngle);
                Float fontSize = configuration.getWatermark().getWatermarkText().getSize();
                configuration.getWatermark().getWatermarkText().setSize(null);
                configuration.getWatermark().getWatermarkText().setFontSize(fontSize);
                ElementColor fontColor = configuration.getWatermark().getWatermarkText().getColor();
                configuration.getWatermark().getWatermarkText().setColor(null);
                configuration.getWatermark().getWatermarkText().setFontColor(fontColor);
            }
            configuration.setErrorHandling(ErrorHandling.BLOCK);
            return configuration;
        }).collect(Collectors.toList());
    }

    private void saveJsonConfiguration(ConfigurationFileService configurationFileService, Plugin plugin) {
        String configurationText = objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL).writerWithDefaultPrettyPrinter().writeValueAsString(this.configurations);
        configurationFileService.saveFile(plugin.getKey(), "config", (InputStream)new ByteArrayInputStream(configurationText.getBytes(StandardCharsets.UTF_8)));
    }
}

