/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.watermark.service;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.suncode.pdfutils.PdfUtils;
import com.suncode.pdfutils.support.ElementAlignment;
import com.suncode.pdfutils.support.ElementAnchor;
import com.suncode.pdfutils.support.RotationMechanism;
import com.suncode.pdfutils.support.TemporaryFile;
import com.suncode.pdfutils.watermark.WatermarkImage;
import com.suncode.pdfutils.watermark.WatermarkText;
import com.suncode.plugin.watermark.configuration.dto.TextSizeDimensionsDto;
import com.suncode.plugin.watermark.configuration.dto.WatermarkDto;
import com.suncode.plugin.watermark.configuration.enums.ElementColor;
import com.suncode.plugin.watermark.configuration.enums.Encoding;
import com.suncode.plugin.watermark.configuration.enums.FontType;
import com.suncode.plugin.watermark.configuration.enums.Keywords;
import com.suncode.plugin.watermark.hook.exception.WatermarkException;
import com.suncode.plugin.watermark.hook.exception.message.ErrorMessage;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.WfDocument;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.springframework.stereotype.Service;

@Service
public class WatermarkService {
    private static final int TEXT_SIZE_UNDER_BARCODE = 11;

    public WatermarkImage createWatermarkImage(WatermarkDto watermark, String barcodeImagePath, Boolean removePDFSecurity) {
        WatermarkImage watermarkBarcodeImage = new WatermarkImage(barcodeImagePath);
        watermarkBarcodeImage.setOpacity(watermark.getOpacity());
        watermarkBarcodeImage.setPercentagePositionX(watermark.getPositionX());
        watermarkBarcodeImage.setPercentagePositionY(watermark.getPositionY());
        watermarkBarcodeImage.setAlignment(ElementAlignment.valueOf((String)watermark.getAlignment().name()));
        watermarkBarcodeImage.setRotationMechanism(RotationMechanism.valueOf((String)watermark.getWatermarkBarcode().getRotationMechanism().name()));
        watermarkBarcodeImage.setRotation(watermark.getClockwiseAngle());
        watermarkBarcodeImage.setAnchor(ElementAnchor.valueOf((String)watermark.getAnchor().name()));
        watermarkBarcodeImage.setRemovePDFSecurity(this.checkRemovePDFSecurity(removePDFSecurity));
        return watermarkBarcodeImage;
    }

    public WatermarkText createWatermarkText(WatermarkDto watermark, Boolean removePDFSecurity) {
        WatermarkText watermarkText = new WatermarkText(watermark.getText());
        watermarkText.setPercentagePositionX(watermark.getPositionX());
        watermarkText.setPercentagePositionY(watermark.getPositionY());
        watermarkText.setAlignment(ElementAlignment.valueOf((String)watermark.getAlignment().name()));
        watermarkText.setSize(watermark.getWatermarkText().getFontSize());
        watermarkText.setOpacity(watermark.getOpacity());
        watermarkText.setColor(this.getColorName(watermark.getWatermarkText().getFontColor()));
        watermarkText.setFontType(this.getBaseFontType(watermark.getWatermarkText().getFontType()));
        watermarkText.setRotation(Float.valueOf(-watermark.getClockwiseAngle().floatValue()));
        watermarkText.setEncoding(this.getEncoding(watermark.getWatermarkText().getEncoding()));
        watermarkText.setAnchor(ElementAnchor.valueOf((String)watermark.getAnchor().name()));
        watermarkText.setBackgroundColor(this.checkElementColor(watermark.getWatermarkText().getBackgroundColor()));
        watermarkText.setRemovePDFSecurity(this.checkRemovePDFSecurity(removePDFSecurity));
        return watermarkText;
    }

    public String createBarcodeImage(BarcodeFormat format, String code, int sizeX, int sizeY, boolean textUnderBarcode) throws WriterException, IOException {
        MultiFormatWriter barcodeWriter = new MultiFormatWriter();
        HashMap<EncodeHintType, Integer> hashMap = new HashMap<EncodeHintType, Integer>();
        hashMap.put(EncodeHintType.MARGIN, 10);
        BitMatrix barcodeBitMatrix = barcodeWriter.encode(code, format, sizeX, sizeY, hashMap);
        String homePath = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY);
        Path barcodePath = Paths.get(homePath, UUID.randomUUID().toString() + ".png");
        if (textUnderBarcode) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)barcodeBitMatrix, (String)"png", (OutputStream)outputStream);
            ByteArrayInputStream in = new ByteArrayInputStream(outputStream.toByteArray());
            BufferedImage barcodeImage = ImageIO.read(in);
            TextSizeDimensionsDto textSizeDimensions = this.createTextSizeDimensionsDto(code);
            int canvasWidth = Math.max(barcodeImage.getWidth(), textSizeDimensions.getWidth());
            int canvasHeight = barcodeImage.getHeight() + textSizeDimensions.getHeight();
            BufferedImage barcodeWithTextImage = new BufferedImage(canvasWidth, canvasHeight, 2);
            Graphics graphics = barcodeWithTextImage.getGraphics();
            graphics.setColor(new Color(255, 255, 255, 1));
            graphics.setFont(new Font("Times-Roman", 0, 11));
            FontMetrics metrics = graphics.getFontMetrics();
            graphics.fillRect(0, 0, canvasWidth, canvasHeight);
            int xCordinate = (canvasWidth - barcodeImage.getWidth()) / 2;
            graphics.drawImage(barcodeImage, xCordinate, 0, barcodeImage.getWidth(), barcodeImage.getHeight(), null);
            graphics.setColor(Color.BLACK);
            graphics.drawString(code, canvasWidth / 2 - metrics.stringWidth(code) / 2, barcodeImage.getHeight() + 11);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)barcodeWithTextImage, "png", baos);
            baos.flush();
            byte[] bytes = baos.toByteArray();
            baos.close();
            try (FileOutputStream fos = new FileOutputStream(barcodePath.toString());){
                fos.write(bytes);
            }
        } else {
            MatrixToImageWriter.writeToPath((BitMatrix)barcodeBitMatrix, (String)"png", (Path)barcodePath);
        }
        return barcodePath.toFile().getAbsolutePath();
    }

    public InputStream addBarcode(InputStream stream, WatermarkImage watermark, String fileName) throws Exception {
        String temporaryFileName = "temp_" + DateTime.now().getMillis() + "_" + fileName;
        TemporaryFile temporaryFile = new TemporaryFile(SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY), temporaryFileName);
        return PdfUtils.addWatermarkAsImage((InputStream)stream, (WatermarkImage)watermark, (TemporaryFile)temporaryFile);
    }

    public InputStream addText(InputStream stream, WatermarkText watermarkText, String fileName) throws Exception {
        String temporaryFileName = "temp_" + DateTime.now().getMillis() + "_" + fileName;
        TemporaryFile temporaryFile = new TemporaryFile(SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY), temporaryFileName);
        return PdfUtils.addWatermarkAsText((InputStream)stream, (WatermarkText)watermarkText, (TemporaryFile)temporaryFile);
    }

    public String resolveValueToEncode(WfDocument document, String text, String processId, String activityId) throws WatermarkException {
        String textWithResolvedDocumentIndices = this.resolveDocumentIndicesInText(document, text);
        return this.updateTextWithKeywords(textWithResolvedDocumentIndices, processId, activityId);
    }

    public void resolveBarcodeRotationMechanism(WatermarkDto watermark) {
        if (Objects.isNull(watermark.getWatermarkBarcode().getRotationMechanism())) {
            watermark.getWatermarkBarcode().setRotationMechanism(com.suncode.plugin.watermark.configuration.enums.RotationMechanism.METHOD_1);
        }
    }

    private String resolveDocumentIndicesInText(WfDocument document, String text) throws WatermarkException {
        List<Long> indicesIds;
        List documentIndices = document.getIndexes();
        if (!this.existIndicesInDocumentClass(documentIndices, indicesIds = this.getIndicesIdsFromText(text))) {
            throw new WatermarkException(ErrorMessage.NON_EXISTING_INDICES_ID, "An entered index/indexes id in JSON configuration do not belong to the document class of the opened file");
        }
        String textValue = this.createWatermarkTextToPut(indicesIds, document, text);
        if (StringUtils.isBlank((CharSequence)textValue)) {
            throw new WatermarkException(ErrorMessage.EMPTY_WATERMARK_TEXT, "Watermark text cannot be empty, null or contain only whitespaces");
        }
        return textValue;
    }

    private String updateTextWithKeywords(String text, String processId, String activityId) {
        StringBuilder builder = new StringBuilder(text);
        this.replaceAllMatchingStringValues(builder, Keywords.CURRENT_DATE.getKeywordPattern(), LocalDate.now().toString(DateTimeFormat.forPattern((String)"yyyy-MM-dd")));
        this.replaceAllMatchingStringValues(builder, Keywords.CURRENT_DATE_AND_TIME.getKeywordPattern(), LocalDateTime.now().toString(DateTimeFormat.forPattern((String)"yyyy-MM-dd HH-mm-ss")));
        this.replaceAllMatchingStringValues(builder, Keywords.PROCESS_ID.getKeywordPattern(), processId == null || processId.equals("null") ? "" : processId);
        this.replaceAllMatchingStringValues(builder, Keywords.ACTIVITY_ID.getKeywordPattern(), activityId == null || activityId.equals("null") ? "" : activityId);
        this.replaceAllMatchingStringValues(builder, Keywords.USER_NAME.getKeywordPattern(), UserContext.current().getUser().getUserName());
        this.replaceAllMatchingStringValues(builder, Keywords.USER_EMAIL.getKeywordPattern(), UserContext.current().getUser().getEmail());
        this.replaceAllMatchingStringValues(builder, Keywords.USER_FULL_NAME.getKeywordPattern(), UserContext.current().getUser().getFullName());
        this.replaceAllMatchingStringValues(builder, Keywords.USER_FIRST_NAME.getKeywordPattern(), UserContext.current().getUser().getFirstName());
        this.replaceAllMatchingStringValues(builder, Keywords.USER_LAST_NAME.getKeywordPattern(), UserContext.current().getUser().getLastName());
        this.replaceAllMatchingStringValues(builder, Keywords.USER_NUMBER.getKeywordPattern(), UserContext.current().getUser().getNumber());
        return builder.toString();
    }

    private void replaceAllMatchingStringValues(StringBuilder builder, String find, String replace) {
        Matcher matcher = Pattern.compile(find).matcher(builder);
        int startIndex = 0;
        while (matcher.find(startIndex)) {
            builder.replace(matcher.start(), matcher.end(), replace);
            startIndex = matcher.start() + replace.length();
        }
    }

    private List<Long> getIndicesIdsFromText(String text) throws WatermarkException {
        try {
            ArrayList<String> indicesIds = new ArrayList<String>();
            Pattern pattern = Pattern.compile("\\{([0-9]+)}");
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                indicesIds.add(matcher.group().substring(matcher.group().indexOf(123) + 1, matcher.group().indexOf(125)));
            }
            return indicesIds.stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
        }
        catch (NumberFormatException nfe) {
            throw new WatermarkException(ErrorMessage.INCORRECT_INDICES_ID_FORMAT, "Incorrect indices ids format", nfe);
        }
    }

    private String createWatermarkTextToPut(List<Long> indicesIds, WfDocument document, String text) {
        Map<Long, Object> configIndices = this.getIndicesIdsAndValues(indicesIds, document);
        String modifiedText = text;
        for (Map.Entry<Long, Object> entry : configIndices.entrySet()) {
            String stringValue = entry.getValue() != null ? entry.getValue().toString() : "";
            modifiedText = modifiedText.replaceAll("\\{" + entry.getKey() + "\\}", stringValue);
        }
        return modifiedText;
    }

    private boolean existIndicesInDocumentClass(List<IndexInfo> documentIndices, List<Long> indicesIds) {
        return indicesIds.isEmpty() || indicesIds.stream().allMatch(indexId -> documentIndices.stream().anyMatch(IndexInfo2 -> IndexInfo2.getId().equals(indexId)));
    }

    private Map<Long, Object> getIndicesIdsAndValues(List<Long> indicesIds, WfDocument document) {
        HashMap<Long, Object> indices = new HashMap<Long, Object>();
        for (Long index : indicesIds) {
            Object indexValue = document.getIndexValue(index);
            indices.put(index, indexValue);
        }
        return indices;
    }

    private Color getColorName(ElementColor color) {
        switch (color) {
            case WHITE: {
                return Color.WHITE;
            }
            case LIGHT_GRAY: {
                return Color.LIGHT_GRAY;
            }
            case GRAY: {
                return Color.GRAY;
            }
            case DARK_GRAY: {
                return Color.DARK_GRAY;
            }
            case BLACK: {
                return Color.BLACK;
            }
            case RED: {
                return Color.RED;
            }
            case PINK: {
                return Color.PINK;
            }
            case ORANGE: {
                return Color.ORANGE;
            }
            case YELLOW: {
                return Color.YELLOW;
            }
            case GREEN: {
                return Color.GREEN;
            }
            case MAGENTA: {
                return Color.MAGENTA;
            }
            case CYAN: {
                return Color.CYAN;
            }
            case BLUE: {
                return Color.BLUE;
            }
        }
        throw new RuntimeException("Wrong a watermark's element color");
    }

    private String getBaseFontType(FontType type) {
        switch (type) {
            case COURIER: {
                return "Courier";
            }
            case COURIER_BOLD: {
                return "Courier-Bold";
            }
            case COURIER_OBLIQUE: {
                return "Courier-Oblique";
            }
            case COURIER_BOLDOBLIQUE: {
                return "Courier-BoldOblique";
            }
            case HELVETICA: {
                return "Helvetica";
            }
            case HELVETICA_BOLD: {
                return "Helvetica-Bold";
            }
            case HELVETICA_OBLIQUE: {
                return "Helvetica-Oblique";
            }
            case HELVETICA_BOLDOBLIQUE: {
                return "Helvetica-BoldOblique";
            }
            case SYMBOL: {
                return "Symbol";
            }
            case TIMES_ROMAN: {
                return "Times-Roman";
            }
            case TIMES_BOLD: {
                return "Times-Bold";
            }
            case TIMES_ITALIC: {
                return "Times-Italic";
            }
            case TIMES_BOLDITALIC: {
                return "Times-BoldItalic";
            }
            case ZAPFDINGBATS: {
                return "ZapfDingbats";
            }
        }
        throw new RuntimeException("Wrong a watermark's font type");
    }

    private String getEncoding(Encoding type) {
        switch (type) {
            case CP1250: {
                return "Cp1250";
            }
            case CP1252: {
                return "Cp1252";
            }
            case CP1257: {
                return "Cp1257";
            }
            case MACROMAN: {
                return "MacRoman";
            }
        }
        throw new RuntimeException("Wrong a watermark's encoding type");
    }

    private TextSizeDimensionsDto createTextSizeDimensionsDto(String code) {
        BufferedImage text = new BufferedImage(1, 1, 2);
        Graphics2D textGraphics = text.createGraphics();
        FontMetrics fm = textGraphics.getFontMetrics();
        textGraphics.dispose();
        return new TextSizeDimensionsDto(fm.stringWidth(code), fm.getHeight());
    }

    private Color checkElementColor(ElementColor color) {
        return color == null ? null : this.getColorName(color);
    }

    private Boolean checkRemovePDFSecurity(Boolean removePDFSecurity) {
        return removePDFSecurity == null ? false : removePDFSecurity;
    }
}

