/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.watermark.service;

import com.google.zxing.BarcodeFormat;
import com.suncode.pdfutils.watermark.WatermarkImage;
import com.suncode.pdfutils.watermark.WatermarkText;
import com.suncode.plugin.watermark.configuration.dto.WatermarkDto;
import com.suncode.plugin.watermark.hook.exception.WatermarkException;
import com.suncode.plugin.watermark.hook.exception.message.ErrorMessage;
import com.suncode.plugin.watermark.service.WatermarkService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WatermarkPDFModifier {
    private static final Logger log = LoggerFactory.getLogger(WatermarkPDFModifier.class);
    @Autowired
    private WatermarkService watermarkService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream addBarcodeToDocument(InputStream stream, WatermarkDto watermark, String fileName, Boolean removePDFSecurity) throws WatermarkException {
        InputStream inputStream;
        BarcodeFormat barcodeFormat = watermark.getWatermarkBarcode().getFormat().getInternalFormat();
        String barcodeImagePath = this.watermarkService.createBarcodeImage(barcodeFormat, watermark.getText(), watermark.getWatermarkBarcode().getCodeWidth(), watermark.getWatermarkBarcode().getCodeHeight(), watermark.getWatermarkBarcode().getTextUnderBarcode());
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)stream);
            log.debug("Temp barcode image has been created and is stored in: " + barcodeImagePath);
            WatermarkImage watermarkBarcode = this.watermarkService.createWatermarkImage(watermark, barcodeImagePath, removePDFSecurity);
            InputStream barcodeStream = this.watermarkService.addBarcode(new ByteArrayInputStream(bytes), watermarkBarcode, fileName);
            log.debug("Barcode image has been added to the PDF document");
            inputStream = barcodeStream;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)stream);
                FileUtils.deleteQuietly((File)new File(barcodeImagePath));
                log.debug("Temp barcode file has been successfully removed from disk");
                throw throwable;
            }
            catch (Throwable ex) {
                throw new WatermarkException(ErrorMessage.WATERMARK_BARCODE_ERROR, "Watermark barcode error", ex);
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        FileUtils.deleteQuietly((File)new File(barcodeImagePath));
        log.debug("Temp barcode file has been successfully removed from disk");
        return inputStream;
    }

    public InputStream addTextToDocument(InputStream stream, WatermarkDto watermark, String fileName, Boolean removePDFSecurity) throws WatermarkException {
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)stream);
            WatermarkText watermarkText = this.watermarkService.createWatermarkText(watermark, removePDFSecurity);
            InputStream textStream = this.watermarkService.addText(new ByteArrayInputStream(bytes), watermarkText, fileName);
            log.debug("Watermark text has been added to the PDF document");
            return textStream;
        }
        catch (Throwable ex) {
            IOUtils.closeQuietly((InputStream)stream);
            throw new WatermarkException(ErrorMessage.WATERMARK_TEXT_ERROR, "Watermark text error", ex);
        }
    }
}

