/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.watermark.application;

import com.suncode.plugin.watermark.application.params.AddWatermarkToDocumentAppParams;
import com.suncode.plugin.watermark.category.Categories;
import com.suncode.plugin.watermark.configuration.dto.WatermarkBarcodeDto;
import com.suncode.plugin.watermark.configuration.dto.WatermarkDto;
import com.suncode.plugin.watermark.configuration.dto.WatermarkTextDto;
import com.suncode.plugin.watermark.configuration.enums.Alignment;
import com.suncode.plugin.watermark.configuration.enums.Anchor;
import com.suncode.plugin.watermark.configuration.enums.ElementColor;
import com.suncode.plugin.watermark.configuration.enums.Encoding;
import com.suncode.plugin.watermark.configuration.enums.FontType;
import com.suncode.plugin.watermark.configuration.enums.RotationMechanism;
import com.suncode.plugin.watermark.configuration.enums.WatermarkBarcodeFormat;
import com.suncode.plugin.watermark.configuration.enums.WatermarkType;
import com.suncode.plugin.watermark.document.dto.NewDocumentVersionDto;
import com.suncode.plugin.watermark.document.service.impl.WatermarkDocumentServiceImpl;
import com.suncode.plugin.watermark.hook.exception.WatermarkException;
import com.suncode.plugin.watermark.hook.exception.message.ErrorMessage;
import com.suncode.plugin.watermark.service.WatermarkPDFModifier;
import com.suncode.plugin.watermark.service.WatermarkService;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="scripts/dpwe/add-watermark-to-document-app-form.js")
public class AddWatermarkToDocumentApp {
    private static final Logger log = LoggerFactory.getLogger(AddWatermarkToDocumentApp.class);
    @Autowired
    private WatermarkService watermarkService;
    @Autowired
    private WatermarkPDFModifier pdfModifier;
    @Autowired
    private WatermarkDocumentServiceImpl documentService;
    @Autowired
    private FileService fileService;
    private static final String ADMINISTRATOR_LOGIN = "admin";

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("watermark.add-watermark-to-document-app")).name("watermark.add-watermark-to-document-app.name")).description("watermark.add-watermark-to-document-app.desc")).category(new Category[]{Categories.WATERMARK})).icon((Icon)SilkIconPack.IMAGE_ADD)).parameter().id("watermarkType").name("watermark.add-watermark-to-document-app.watermark-type.name").description("watermark.add-watermark-to-document-app.watermark-type.desc").type((Type)Types.STRING).create()).parameter().id("filesSource").name("watermark.add-watermark-to-document-app.files-source.name").description("watermark.add-watermark-to-document-app.files-source.desc").type((Type)Types.STRING).defaultValue((Object)"DOCUMENTCLASS").create()).parameter().id("fileIds").name("watermark.add-watermark-to-document-app.file-ids.name").description("watermark.add-watermark-to-document-app.file-ids.desc").type((Type)Types.INTEGER_ARRAY).optional().create()).parameter().id("documentClassDocumentIds").name("watermark.add-watermark-to-document-app.document-class-document-ids.name").description("watermark.add-watermark-to-document-app.document-class-document-ids.desc").type((Type)Types.STRING).optional().create()).parameter().id("documentIds").name("watermark.add-watermark-to-document-app.document-ids.name").description("watermark.add-watermark-to-document-app.document-ids.desc").type((Type)Types.INTEGER_ARRAY).optional().create()).parameter().id("documentClass").name("watermark.add-watermark-to-document-app.document-class.name").description("watermark.add-watermark-to-document-app.document-class.desc").type((Type)Types.STRING).optional().create()).parameter().id("text").name("watermark.add-watermark-to-document-app.text.name").description("watermark.add-watermark-to-document-app.text.desc").type((Type)Types.STRING).create()).parameter().id("alignment").name("watermark.add-watermark-to-document-app.alignment.name").description("watermark.add-watermark-to-document-app.alignment.desc").type((Type)Types.STRING).defaultValue((Object)"TOP_LEFT").create()).parameter().id("anchor").name("watermark.add-watermark-to-document-app.anchor.name").description("watermark.add-watermark-to-document-app.anchor.desc").type((Type)Types.STRING).defaultValue((Object)"BOTTOM_LEFT").create()).parameter().id("positionX").name("watermark.add-watermark-to-document-app.position-x.name").description("watermark.add-watermark-to-document-app.position-x.desc").type((Type)Types.INTEGER).defaultValue((Object)5).create()).parameter().id("positionY").name("watermark.add-watermark-to-document-app.position-y.name").description("watermark.add-watermark-to-document-app.position-y.desc").type((Type)Types.INTEGER).defaultValue((Object)10).create()).parameter().id("opacity").name("watermark.add-watermark-to-document-app.opacity.name").description("watermark.add-watermark-to-document-app.opacity.desc").type((Type)Types.FLOAT).defaultValue((Object)Float.valueOf(1.0f)).create()).parameter().id("rotation").name("watermark.add-watermark-to-document-app.rotation.name").description("watermark.add-watermark-to-document-app.rotation.desc").type((Type)Types.FLOAT).defaultValue((Object)Float.valueOf(0.0f)).create()).parameter().id("removeFileSecurity").name("watermark.add-watermark-to-document-app.remove-file-security.name").description("watermark.add-watermark-to-document-app.remove-file-security.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("format").name("watermark.add-watermark-to-document-app.format.name").description("watermark.add-watermark-to-document-app.format.desc").type((Type)Types.STRING).defaultValue((Object)"CODE_128").optional().create()).parameter().id("barcodeWidth").name("watermark.add-watermark-to-document-app.barcode-width.name").description("watermark.add-watermark-to-document-app.barcode-width.desc").type((Type)Types.INTEGER).optional().defaultValue((Object)40).create()).parameter().id("barcodeHeight").name("watermark.add-watermark-to-document-app.barcode-height.name").description("watermark.add-watermark-to-document-app.barcode-height.desc").type((Type)Types.INTEGER).optional().defaultValue((Object)15).create()).parameter().id("textUnderBarcode").name("watermark.add-watermark-to-document-app.text-under-barcode.name").description("watermark.add-watermark-to-document-app.text-under-barcode.desc").type((Type)Types.BOOLEAN).optional().defaultValue((Object)false).create()).parameter().id("rotationMechanism").name("watermark.add-watermark-to-document-app.rotation-mechanism.name").description("watermark.add-watermark-to-document-app.rotation-mechanism.desc").type((Type)Types.STRING).optional().create()).parameter().id("fontSize").name("watermark.add-watermark-to-document-app.font-size.name").description("watermark.add-watermark-to-document-app.font-size.desc").type((Type)Types.FLOAT).optional().defaultValue((Object)Float.valueOf(15.0f)).create()).parameter().id("fontType").name("watermark.add-watermark-to-document-app.font-type.name").description("watermark.add-watermark-to-document-app.font-type.desc").type((Type)Types.STRING).optional().defaultValue((Object)"HELVETICA").create()).parameter().id("fontColor").name("watermark.add-watermark-to-document-app.font-color.name").description("watermark.add-watermark-to-document-app.font-color.desc").type((Type)Types.STRING).optional().defaultValue((Object)"LIGHT_GRAY").create()).parameter().id("encoding").name("watermark.add-watermark-to-document-app.encoding.name").description("watermark.add-watermark-to-document-app.encoding.desc").type((Type)Types.STRING).optional().defaultValue((Object)"CP1250").create()).parameter().id("textBackgroundColor").name("watermark.add-watermark-to-document-app.text-background-color.name").description("watermark.add-watermark-to-document-app.text-background-color.desc").type((Type)Types.STRING).optional().create();
    }

    public void execute(ApplicationContext context, Parameters parameters) throws Exception {
        if (!UserContext.isActive()) {
            UserContext.activate((String)ADMINISTRATOR_LOGIN);
        }
        AddWatermarkToDocumentAppParams appParams = new AddWatermarkToDocumentAppParams(parameters);
        List<WfDocument> documents = this.resolveTargetDocuments(appParams, context);
        LinkedList<NewDocumentVersionDto> documentVersions = new LinkedList<NewDocumentVersionDto>();
        for (WfDocument document : documents) {
            WfFile wfFile = document.getFile();
            String fileName = wfFile.getFileName();
            if (!this.isDocumentPDFFormat(fileName)) continue;
            String textValue = this.watermarkService.resolveValueToEncode(document, appParams.getText(), context.getProcessId(), context.getActivityId());
            InputStream stream = this.fileService.getFileInputStream(Long.valueOf(wfFile.getId()));
            Throwable throwable = null;
            try {
                InputStream modifiedStream = this.addWatermarkToFile(appParams, fileName, textValue, stream);
                Throwable throwable2 = null;
                try {
                    NewDocumentVersionDto documentVersion = NewDocumentVersionDto.builder().document(document).stream(modifiedStream).build();
                    documentVersions.add(documentVersion);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (modifiedStream == null) continue;
                    if (throwable2 != null) {
                        try {
                            modifiedStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    modifiedStream.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                stream.close();
            }
        }
        this.addNewDocumentVersions(documentVersions, context);
    }

    private List<WfDocument> resolveTargetDocuments(AddWatermarkToDocumentAppParams appParams, ApplicationContext context) throws WatermarkException {
        switch (appParams.getFilesSource()) {
            case "FILEIDS": {
                return this.getDocumentsByFileIds(appParams.getFileIds(), context);
            }
            case "DOCUMENTIDS": {
                return this.getDocumentsByDocumentIds(appParams.getDocumentClassDocumentIds(), appParams.getDocumentIds(), context);
            }
            case "DOCUMENTCLASS": {
                return this.getDocumentsFromDocumentClass(appParams.getDocumentClass(), context);
            }
        }
        throw new WatermarkException(ErrorMessage.UNEXPECTED_ERROR, "Parameter filesSource is invalid: " + appParams.getFilesSource());
    }

    private List<WfDocument> getDocumentsByFileIds(Long[] fileIds, ApplicationContext context) throws WatermarkException {
        if (fileIds == null || fileIds.length == 0) {
            throw new WatermarkException(ErrorMessage.UNEXPECTED_ERROR, "Parameter fileIds must contain at least one identifier when the filesSource paramter is set to FILEIDS.");
        }
        LinkedHashSet requestedFileIds = Arrays.stream(fileIds).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        List<WfDocument> documentsFromProcess = this.documentService.getDocumentsFromProcess(context);
        Map<Long, WfDocument> documentsByFileId = documentsFromProcess.stream().collect(Collectors.toMap(document -> document.getFile().getId(), document -> document));
        LinkedList<WfDocument> resolvedDocuments = new LinkedList<WfDocument>();
        for (Long fileId : requestedFileIds) {
            WfDocument document2 = documentsByFileId.get(fileId);
            if (document2 == null) {
                throw new WatermarkException(ErrorMessage.UNEXPECTED_ERROR, "File with id '" + fileId + "' is not attached to the current process.");
            }
            resolvedDocuments.add(document2);
        }
        return resolvedDocuments;
    }

    private List<WfDocument> getDocumentsByDocumentIds(String documentClass, Long[] documentIds, ApplicationContext context) throws WatermarkException {
        if (StringUtils.isBlank((String)documentClass)) {
            throw new WatermarkException(ErrorMessage.UNEXPECTED_ERROR, "Parameter documentClassDocumentIds must be provided when the filesSource parameter is set to DOCUMENTIDS.");
        }
        if (documentIds == null || documentIds.length == 0) {
            throw new WatermarkException(ErrorMessage.UNEXPECTED_ERROR, "Parameter documentIds must contain at least one identifier when the filesSource parameter is set to DOCUMENTIDS.");
        }
        LinkedHashSet requestedDocumentIds = Arrays.stream(documentIds).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        List<WfDocument> documentsFromClass = this.documentService.getDocumentsFromProcessAndClass(documentClass, context);
        Map<Long, WfDocument> documentsByIdMap = documentsFromClass.stream().collect(Collectors.toMap(WfDocument::getId, document -> document));
        LinkedList<WfDocument> resolvedDocuments = new LinkedList<WfDocument>();
        for (Long documentId : requestedDocumentIds) {
            WfDocument document2 = documentsByIdMap.get(documentId);
            if (document2 == null) {
                throw new WatermarkException(ErrorMessage.UNEXPECTED_ERROR, "Document with id '" + documentId + "' with set document class '" + documentClass + "' is not attached to the current process.");
            }
            resolvedDocuments.add(document2);
        }
        return resolvedDocuments;
    }

    private List<WfDocument> getDocumentsFromDocumentClass(String documentClass, ApplicationContext context) throws WatermarkException {
        if (StringUtils.isBlank((String)documentClass)) {
            throw new WatermarkException(ErrorMessage.UNEXPECTED_ERROR, "Parameter documentClass must be provided when the filesSource paramter uses document class.");
        }
        return this.documentService.getDocumentsFromProcessAndClass(documentClass, context);
    }

    private InputStream addWatermarkToFile(AddWatermarkToDocumentAppParams appParams, String fileName, String textValue, InputStream stream) throws WatermarkException {
        switch (WatermarkType.valueOf(appParams.getWatermarkType())) {
            case BARCODE: {
                WatermarkDto barcodeConfig = this.buildWatermarkBarcodeDto(appParams, textValue);
                return this.pdfModifier.addBarcodeToDocument(stream, barcodeConfig, fileName, appParams.getRemoveFileSecurity());
            }
            case TEXT: {
                WatermarkDto textConfig = this.buildWatermarkTextDto(appParams, textValue);
                return this.pdfModifier.addTextToDocument(stream, textConfig, fileName, appParams.getRemoveFileSecurity());
            }
        }
        throw new WatermarkException(ErrorMessage.UNEXPECTED_ERROR, "Invalid watermark type '" + appParams.getWatermarkType() + "'");
    }

    private WatermarkDto buildWatermarkBarcodeDto(AddWatermarkToDocumentAppParams appParams, String textValue) {
        return WatermarkDto.builder().text(textValue).alignment(Alignment.valueOf(appParams.getAlignment())).anchor(Anchor.valueOf(appParams.getAnchor())).positionX(appParams.getPositionX()).positionY(appParams.getPositionY()).opacity(appParams.getOpacity()).clockwiseAngle(appParams.getRotation()).watermarkBarcode(WatermarkBarcodeDto.builder().format(WatermarkBarcodeFormat.valueOf(appParams.getFormat())).codeWidth(appParams.getBarcodeWidth()).codeHeight(appParams.getBarcodeHeight()).textUnderBarcode(appParams.getTextUnderBarcode()).rotationMechanism(StringUtils.isEmpty((String)appParams.getRotationMechanism()) ? RotationMechanism.METHOD_1 : RotationMechanism.valueOf(appParams.getRotationMechanism())).build()).build();
    }

    private WatermarkDto buildWatermarkTextDto(AddWatermarkToDocumentAppParams appParams, String textValue) {
        return WatermarkDto.builder().text(textValue).alignment(Alignment.valueOf(appParams.getAlignment())).anchor(Anchor.valueOf(appParams.getAnchor())).positionX(appParams.getPositionX()).positionY(appParams.getPositionY()).opacity(appParams.getOpacity()).clockwiseAngle(appParams.getRotation()).watermarkText(WatermarkTextDto.builder().fontSize(appParams.getFontSize()).encoding(Encoding.valueOf(appParams.getEncoding())).fontType(FontType.valueOf(appParams.getFontType())).fontColor(ElementColor.valueOf(appParams.getFontColor())).backgroundColor(StringUtils.isEmpty((String)appParams.getTextBackgroundColor()) ? null : ElementColor.valueOf(appParams.getTextBackgroundColor())).build()).build();
    }

    private boolean isDocumentPDFFormat(String fileName) {
        return FilenameUtils.getExtension((String)fileName).equalsIgnoreCase("pdf");
    }

    private void addNewDocumentVersions(List<NewDocumentVersionDto> documentVersions, ApplicationContext context) throws Exception {
        for (NewDocumentVersionDto documentVersion : documentVersions) {
            log.debug("Adding a new file version to '" + documentVersion.getDocument().getFile().getFileName() + "' document");
            this.documentService.addDocumentAsNewVersion(documentVersion.getDocument(), documentVersion.getStream(), context);
        }
    }
}

