/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.sso.authenticator.configuration.saml;

import com.coveo.saml.SamlException;
import com.plusmpm.security.DesEncrypter;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.sso.authenticator.configuration.saml.KeyStoreConfigDto;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Component
public class SamlHelper {
    public static final String ENCRYPTED_DATA_PREFIX = "enc:";
    @Autowired
    private Plugin plugin;
    @Autowired
    private ConfigurationFileService fileConfigurationService;
    private final DesEncrypter desEncrypter = new DesEncrypter();
    private KeyStore keyStore;

    public PrivateKey getPrivateKeyFromKeyStore(KeyStoreConfigDto keyStoreConfig) {
        try {
            KeyStore keyStore = this.loadKeyStore(keyStoreConfig);
            KeyStore.PasswordProtection param = new KeyStore.PasswordProtection(this.desEncrypter.decrypt(keyStoreConfig.getPrivateKeyPassword().replace(ENCRYPTED_DATA_PREFIX, "")).toCharArray());
            KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyStoreConfig.getAlias(), param);
            return pkEntry.getPrivateKey();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public X509Certificate getX509FromKeyStore(KeyStoreConfigDto keyStoreConfig) {
        try {
            KeyStore keyStore = this.loadKeyStore(keyStoreConfig);
            Certificate[] chain = keyStore.getCertificateChain(keyStoreConfig.getAlias());
            return (X509Certificate)chain[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private KeyStore loadKeyStore(KeyStoreConfigDto keyStoreConfig) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        KeyStore keyStoreInstance = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = this.desEncrypter.decrypt(keyStoreConfig.getKeyStorePassword().replace(ENCRYPTED_DATA_PREFIX, "")).toCharArray();
        try (FileInputStream fis = new FileInputStream(keyStoreConfig.getKeyStorePath());){
            keyStoreInstance.load(fis, password);
        }
        this.keyStore = keyStoreInstance;
        return this.keyStore;
    }

    public Reader getIdPCertificateReader() {
        try {
            return new StringReader(IOUtils.toString((InputStream)this.fileConfigurationService.readFile(this.plugin.getKey(), "Entity Descriptor"), (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public EntityDescriptor getEntityDescriptorForIdP() throws SamlException {
        DOMMetadataResolver metadataResolver = SamlHelper.createMetadataResolver(SamlHelper.skipBom(this.getIdPCertificateReader()));
        return SamlHelper.getEntityDesc(metadataResolver);
    }

    public String getIdPSingleLogInUrl() throws SamlException {
        EntityDescriptor entityDescriptor = this.getEntityDescriptorForIdP();
        IDPSSODescriptor idpDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (idpDescriptor != null) {
            List singleSignOnServices = idpDescriptor.getSingleSignOnServices();
            for (SingleSignOnService sso : singleSignOnServices) {
                if (!sso.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
                return sso.getLocation();
            }
        } else {
            System.out.println("No IDPSSODescriptor found");
        }
        return null;
    }

    public SingleLogoutConfig getIdPSingleLogOutConfig() throws SamlException {
        EntityDescriptor entityDescriptor = this.getEntityDescriptorForIdP();
        IDPSSODescriptor idpDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (idpDescriptor != null) {
            List singleLogoutServices = idpDescriptor.getSingleLogoutServices();
            Iterator iterator = singleLogoutServices.iterator();
            if (iterator.hasNext()) {
                SingleLogoutService sls = (SingleLogoutService)iterator.next();
                if (sls.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
                    return new SingleLogoutConfig(sls.getLocation(), "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
                }
                if (sls.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                    return new SingleLogoutConfig(sls.getLocation(), "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                }
                throw new IllegalArgumentException("Unsupported HTTP method type for SingleLogout: " + sls.getBinding());
            }
        } else {
            System.out.println("No IDPSSODescriptor found");
        }
        return null;
    }

    public String getRequestIdParameter(String encodedSamlRequest) throws ParserConfigurationException, IOException, SAXException, UnmarshallingException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(Base64.decodeBase64((byte[])encodedSamlRequest.getBytes(StandardCharsets.UTF_8))));
        Element element = document.getDocumentElement();
        RequestAbstractType request = (RequestAbstractType)XMLObjectSupport.getUnmarshaller((Element)element).unmarshall(element);
        return request.getID();
    }

    private static EntityDescriptor getEntityDesc(DOMMetadataResolver metadata) throws SamlException {
        ArrayList entityDescriptors = new ArrayList();
        metadata.forEach(entityDescriptors::add);
        if (entityDescriptors.size() != 1) {
            throw new SamlException("Bad entity descriptor count: " + entityDescriptors.size());
        }
        return (EntityDescriptor)entityDescriptors.get(0);
    }

    private static DOMMetadataResolver createMetadataResolver(InputStream metadata) throws SamlException {
        try {
            BasicParserPool parser = SamlHelper.createDOMParser();
            Document metadataDocument = parser.parse(metadata);
            DOMMetadataResolver resolver = new DOMMetadataResolver(metadataDocument.getDocumentElement());
            resolver.setId("componentId");
            resolver.initialize();
            return resolver;
        }
        catch (ComponentInitializationException | XMLParserException ex) {
            throw new SamlException("Cannot load identity provider metadata", ex);
        }
    }

    private static InputStream skipBom(Reader metadata) throws SamlException {
        try {
            InputStream metadataInputStream = IOUtils.toInputStream((String)IOUtils.toString((Reader)metadata), (Charset)StandardCharsets.UTF_8);
            return new BOMInputStream(metadataInputStream, false);
        }
        catch (IOException e) {
            throw new SamlException("Couldn't read metadata", (Throwable)e);
        }
    }

    private static BasicParserPool createDOMParser() throws SamlException {
        BasicParserPool basicParserPool = new BasicParserPool();
        try {
            basicParserPool.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new SamlException("Failed to create an XML parser");
        }
        return basicParserPool;
    }

    public record SingleLogoutConfig(String singleLogoutUrl, String method) {
    }
}

