/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.sso.authenticator.configuration.extraverifiers;

import com.suncode.pwfl.security.extraverifiers.ExtraAuthVerifier;
import com.suncode.pwfl.security.extraverifiers.ExtraAuthVerifierDataSourceValueProvider;
import com.suncode.pwfl.security.extraverifiers.ExtraAuthVerifierDataSourceValueProviderInputValueType;
import com.suncode.pwfl.security.extraverifiers.ExtraAuthVerifierExternalAuthAttributeValueProvider;
import com.suncode.pwfl.security.extraverifiers.ExtraAuthVerifierStaticValueProvider;
import com.suncode.pwfl.security.extraverifiers.ExtraAuthVerifierValueProvider;
import com.suncode.sso.authenticator.configuration.PostAuthHandlersConfigDto;
import com.suncode.sso.authenticator.configuration.extraverifiers.ConfigurationExtraAuthVerifier;
import com.suncode.sso.authenticator.configuration.extraverifiers.ConfigurationExtraAuthVerifierValueProvider;
import com.suncode.sso.authenticator.configuration.extraverifiers.ConfigurationExtraAuthVerifierValueProviderType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class ExtraAuthVerifiersFactory {
    public List<ExtraAuthVerifier> generateExtraVerifiers(PostAuthHandlersConfigDto configuration) {
        if (configuration == null) {
            return new ArrayList<ExtraAuthVerifier>();
        }
        ArrayList<ExtraAuthVerifier> verifiers = new ArrayList<ExtraAuthVerifier>();
        List<ConfigurationExtraAuthVerifier> configuredExtraVerifiers = configuration.getExtraAuthVerifiers();
        if (CollectionUtils.isNotEmpty(configuredExtraVerifiers)) {
            for (ConfigurationExtraAuthVerifier extraVerifierFromConfig : configuredExtraVerifiers) {
                ExtraAuthVerifierValueProvider firstValueProvider = this.getExtraAuthVerifierValueProvider(extraVerifierFromConfig.getFirstVerifierValueProvider());
                ExtraAuthVerifierValueProvider secondValueProvider = this.getExtraAuthVerifierValueProvider(extraVerifierFromConfig.getSecondVerifierValueProvider());
                ExtraAuthVerifier extraAuthVerifier = new ExtraAuthVerifier(firstValueProvider, secondValueProvider, extraVerifierFromConfig.isIgnoreCase());
                verifiers.add(extraAuthVerifier);
            }
        }
        return verifiers;
    }

    private ExtraAuthVerifierValueProvider getExtraAuthVerifierValueProvider(ConfigurationExtraAuthVerifierValueProvider extraAuthVerifierValueProviderFromConfig) {
        return switch (extraAuthVerifierValueProviderFromConfig.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigurationExtraAuthVerifierValueProviderType.STATIC_VALUE -> new ExtraAuthVerifierStaticValueProvider(extraAuthVerifierValueProviderFromConfig.getParam());
            case ConfigurationExtraAuthVerifierValueProviderType.AUTHENTICATION_RESULT_ATTRIBUTE -> new ExtraAuthVerifierExternalAuthAttributeValueProvider(extraAuthVerifierValueProviderFromConfig.getParam());
            case ConfigurationExtraAuthVerifierValueProviderType.VALUE_FROM_DATA_SOURCE_WITH_PWFL_USERNAME_AS_INPUT_VALUE -> new ExtraAuthVerifierDataSourceValueProvider(extraAuthVerifierValueProviderFromConfig.getParam(), ExtraAuthVerifierDataSourceValueProviderInputValueType.USERNAME);
            case ConfigurationExtraAuthVerifierValueProviderType.VALUE_FROM_DATA_SOURCE_WITH_SSO_USERNAME_AS_INPUT_VALUE -> new ExtraAuthVerifierDataSourceValueProvider(extraAuthVerifierValueProviderFromConfig.getParam(), ExtraAuthVerifierDataSourceValueProviderInputValueType.USERNAME_FROM_EXTERNAL_AUTHENTICATOR);
        };
    }
}

