/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.sso.authenticator.configuration;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.initconfiguration.InitConfigurationDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.initconfiguration.InitConfigurationProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.model.FileType;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitConfigurationProviderImpl
implements InitConfigurationProvider {
    private static final String CONFIG_FILE_NAME = "/config.json";
    private static final String ENTITY_DESCRIPTOR_FILE_NAME = "/entityDescriptor.xml";
    private static final String POST_AUTH_HANDLERS_FILE_NAME = "/postAuthHandlers.json";
    @Autowired
    private Plugin plugin;
    @Autowired
    private ConfigurationFileService configurationFileService;

    public List<InitConfigurationDto> getInitConfigurations() {
        ArrayList<InitConfigurationDto> configs = new ArrayList<InitConfigurationDto>();
        configs.add(new InitConfigurationDto("SSO Config", FileType.JSON, this.getConfigTemplate()));
        configs.add(new InitConfigurationDto("Entity Descriptor", FileType.XML, this.getEntityDescriptorTemplate()));
        configs.add(new InitConfigurationDto("Post auth handlers", FileType.JSON, this.getPostAuthHandlersTemplate()));
        return configs;
    }

    private InputStream getConfigTemplate() {
        return this.getClass().getResourceAsStream(CONFIG_FILE_NAME);
    }

    private InputStream getEntityDescriptorTemplate() {
        return this.getClass().getResourceAsStream(ENTITY_DESCRIPTOR_FILE_NAME);
    }

    private InputStream getPostAuthHandlersTemplate() {
        return this.getClass().getResourceAsStream(POST_AUTH_HANDLERS_FILE_NAME);
    }
}

