/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.sso.authenticator;

import com.coveo.saml.BrowserUtils;
import com.coveo.saml.SamlException;
import com.coveo.saml.SamlLogoutResponse;
import com.coveo.saml.SamlResponse;
import com.google.gson.Gson;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.pwfl.administration.authentication.AuthenticationInterceptorService;
import com.suncode.pwfl.administration.authentication.LoginType;
import com.suncode.pwfl.security.AuthenticationButton;
import com.suncode.pwfl.security.AuthenticationResult;
import com.suncode.pwfl.security.Authenticator;
import com.suncode.pwfl.security.CustomRedirectInfo;
import com.suncode.pwfl.security.RedirectEvent;
import com.suncode.pwfl.security.SSOLogoutStatusCode;
import com.suncode.pwfl.security.SSORedirectType;
import com.suncode.pwfl.security.UserCreationStrategyDuringAuthentication;
import com.suncode.pwfl.security.extraverifiers.ExtraAuthVerifier;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.sso.authenticator.configuration.ConfigurationDto;
import com.suncode.sso.authenticator.configuration.PostAuthHandlersConfigDto;
import com.suncode.sso.authenticator.configuration.extraverifiers.ExtraAuthVerifiersFactory;
import com.suncode.sso.authenticator.configuration.redirections.ConfigCustomRedirect;
import com.suncode.sso.authenticator.configuration.saml.SamlClient;
import com.suncode.sso.authenticator.configuration.saml.SamlHelper;
import com.suncode.sso.authenticator.configuration.saml.SamlRequest;
import com.suncode.sso.authenticator.exception.SsoConfigurationMissingException;
import com.suncode.sso.authenticator.exception.UnsupportedAuthenticationSolutionException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SsoAuthenticator
implements Authenticator {
    private static final Logger log = LoggerFactory.getLogger(SsoAuthenticator.class);
    public static final String CONFIG_FILE_ID = "SSO Config";
    public static final String ENTITY_DESCRIPTOR_FILE_ID = "Entity Descriptor";
    public static final String POST_AUTH_HANDLERS = "Post auth handlers";
    private static final String SSO_SESSION_INDEX_KEY = "SSOSessionIndex";
    private static final String RELAY_STATE_KEY = "RelayState";
    private Translator translator;
    private final Gson gson = new Gson();
    private ConfigurationDto configuration;
    private PostAuthHandlersConfigDto postAuthHandlersConfiguration;
    @Autowired
    private Plugin plugin;
    @Autowired
    private ConfigurationFileService fileConfigurationService;
    @Autowired
    private SamlHelper samlHelper;
    @Autowired
    private ExtraAuthVerifiersFactory extraAuthVerifiersFactory;
    @Autowired
    private AuthenticationInterceptorService authenticationInterceptorService;
    private SamlClient client;
    private List<ExtraAuthVerifier> extraAuthVerifiers;

    @PostConstruct
    private void init() {
        this.translator = Translators.get(SsoAuthenticator.class);
    }

    private SamlClient getClient() throws SamlException {
        if (this.client == null) {
            this.client = SamlClient.fromMetadata(this.getConfiguration().getSamlConfig().getIssuer(), this.getConfiguration().getSamlConfig().getAssertionConsumerServiceURL(), this.samlHelper.getIdPCertificateReader());
            if (this.getConfiguration().getKeyStore() != null) {
                PrivateKey privateKey = this.samlHelper.getPrivateKeyFromKeyStore(this.getConfiguration().getKeyStore());
                X509Certificate cer = this.samlHelper.getX509FromKeyStore(this.getConfiguration().getKeyStore());
                this.client.setSPKeys(cer, privateKey);
            }
        }
        return this.client;
    }

    public String getName() {
        this.validateSooConfiguration();
        return this.getConfiguration().getSolution().name();
    }

    public AuthenticationResult authenticate(HttpServletRequest request) {
        try {
            this.validateSooConfiguration();
            SamlResponse samlResponse = this.getSamlResponse(request);
            String userName = samlResponse.getNameID();
            AuthenticationResult authenticationResult = new AuthenticationResult(true, userName);
            authenticationResult.setAttributes(SsoAuthenticator.extractSamlAttributes(samlResponse.getAssertion().getAttributeStatements()));
            return authenticationResult;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new AuthenticationResult(false, null);
        }
    }

    public AuthenticationButton authenticationButtonDefinition() {
        if (this.getConfiguration() == null || !this.getConfiguration().isActive()) {
            return null;
        }
        try {
            this.getClient();
            String providerSsoUrl = this.samlHelper.getIdPSingleLogInUrl();
            Map<String, String> postParameters = this.generatePostParameters();
            return AuthenticationButton.builder().name(this.translator.getMessage("sso.authenticator.buttonName", new Object[]{this.getName()})).redirectType(SSORedirectType.POST).url(providerSsoUrl).autoLogin(this.getConfiguration().isAutoLogin()).postParameters(postParameters).styles(this.buttonStyles()).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.generateErrorButton();
        }
    }

    @Nullable
    public UserCreationStrategyDuringAuthentication getUserCreationStrategyDuringAuthentication() {
        PostAuthHandlersConfigDto postAuthHandlersConfiguration = this.getPostAuthHandlersConfiguration();
        if (postAuthHandlersConfiguration == null) {
            return null;
        }
        String createUserFromDataSourceId = this.getPostAuthHandlersConfiguration().getCreateUserFromDataSourceId();
        if (StringUtils.isBlank((CharSequence)createUserFromDataSourceId)) {
            return null;
        }
        ArrayList defaultGroupNames = this.getPostAuthHandlersConfiguration().getDefaultGroupNames() != null ? Arrays.asList(this.getPostAuthHandlersConfiguration().getDefaultGroupNames().split(";")) : new ArrayList();
        return new UserCreationStrategyDuringAuthentication(createUserFromDataSourceId, defaultGroupNames);
    }

    public String getLogoutRequest(HttpServletRequest request) {
        return request.getParameter("SAMLRequest");
    }

    public boolean validLogoutRequest(HttpServletRequest request, HttpServletResponse response, String encodedRequest, String userName) throws Exception {
        LogoutRequest decodedRequest = this.getClient().decodeSamlLogoutRequest(encodedRequest);
        this.getClient().validateSamlLogoutRequest(decodedRequest);
        return true;
    }

    public String getNameIdFromLogoutRequest(String encodedRequest) throws Exception {
        LogoutRequest decodedRequest = this.getClient().decodeSamlLogoutRequest(encodedRequest);
        return decodedRequest.getNameID().getValue();
    }

    public String getLogoutResponse(HttpServletRequest request) {
        return request.getParameter("SAMLResponse");
    }

    public boolean validLogoutResponse(HttpServletRequest request, HttpServletResponse response, String logoutResponse) throws Exception {
        String requestId = this.getRequestIdFromRealState(request);
        SamlLogoutResponse logoutResponseStatus = this.getClient().decodeAndValidateSamlLogoutResponse(logoutResponse, requestId);
        if (logoutResponseStatus.isNotValid()) {
            log.error("SSO Logout Response is invalid: {}", (Object)logoutResponseStatus.getMessage());
            return false;
        }
        return true;
    }

    public void sendLogoutResponse(HttpServletRequest request, HttpServletResponse response, String logoutRequest, SSOLogoutStatusCode status) throws Exception {
        SamlHelper.SingleLogoutConfig singleLogoutConfig = this.samlHelper.getIdPSingleLogOutConfig();
        if (singleLogoutConfig.method().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            String requestId = this.samlHelper.getRequestIdParameter(logoutRequest);
            String encodedResponse = this.getClient().getSamlLogoutResponse(status.toString(), null, requestId, true, false);
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("SAMLResponse", encodedResponse);
            BrowserUtils.postUsingBrowser((String)singleLogoutConfig.singleLogoutUrl(), (HttpServletResponse)response, values);
        } else {
            LogoutRequest logoutRequestObject = this.getClient().decodeSamlLogoutRequest(logoutRequest);
            String encodedResponse = this.getClient().getSamlLogoutResponse(status.toString(), null, logoutRequestObject.getID(), false, true);
            String redirectUrl = singleLogoutConfig.singleLogoutUrl() + "?SAMLResponse=" + URLEncoder.encode(encodedResponse, "UTF-8");
            response.sendRedirect(redirectUrl);
        }
    }

    public boolean sendLogoutRequest(HttpServletRequest request, HttpServletResponse response, String userName) throws Exception {
        if (this.getConfiguration().isDisableSingleLogOut()) {
            return false;
        }
        SamlHelper.SingleLogoutConfig singleLogOutConfig = this.samlHelper.getIdPSingleLogOutConfig();
        if (singleLogOutConfig == null) {
            log.warn("Single log out url for SSO not exist");
            return false;
        }
        log.info("Sending logout request to url: " + singleLogOutConfig.singleLogoutUrl());
        HttpSession session = request.getSession(false);
        String sessionIndex = (String)session.getAttribute(SSO_SESSION_INDEX_KEY);
        userName = this.authenticationInterceptorService.runReverseBeforeSystemLogin(userName, LoginType.SSO);
        if (singleLogOutConfig.method().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            SamlRequest logoutRequest = this.getClient().getLogoutRequest(userName.toUpperCase(), sessionIndex, true, false);
            String encodedRequest = logoutRequest.getEncodedSamlRequest();
            String relayState = Base64.getEncoder().encodeToString(logoutRequest.getRequestId().getBytes());
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("SAMLRequest", encodedRequest);
            if (StringUtils.isNotEmpty((CharSequence)relayState)) {
                values.put(RELAY_STATE_KEY, relayState);
            }
            BrowserUtils.postUsingBrowser((String)singleLogOutConfig.singleLogoutUrl(), (HttpServletResponse)response, values);
            return true;
        }
        if (singleLogOutConfig.method().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
            SamlRequest logoutRequest = this.getClient().getLogoutRequest(userName.toUpperCase(), sessionIndex, false, true);
            String encodedRequest = logoutRequest.getEncodedSamlRequest();
            String relayState = Base64.getEncoder().encodeToString(logoutRequest.getRequestId().getBytes());
            String redirectUrl = singleLogOutConfig.singleLogoutUrl() + "?SAMLRequest=" + URLEncoder.encode(encodedRequest, StandardCharsets.UTF_8);
            if (StringUtils.isNotEmpty((CharSequence)relayState)) {
                redirectUrl = redirectUrl + "&RelayState=" + URLEncoder.encode(relayState, StandardCharsets.UTF_8);
            }
            response.sendRedirect(redirectUrl);
            return true;
        }
        return false;
    }

    public boolean allowExternalLogout() {
        return !this.getConfiguration().isDisableSingleLogOut();
    }

    public void afterSuccessLogIn(HttpServletRequest request) throws SamlException {
        String encodedResponse = request.getParameter("SAMLResponse");
        String requestId = this.getRequestIdFromRealState(request);
        SamlResponse response = this.getClient().decodeAndValidateSamlResponse(encodedResponse, requestId, "POST");
        if (CollectionUtils.isNotEmpty((Collection)response.getAssertion().getAuthnStatements())) {
            String sessionIndex = ((AuthnStatement)response.getAssertion().getAuthnStatements().get(0)).getSessionIndex();
            request.getSession(false).setAttribute(SSO_SESSION_INDEX_KEY, (Object)sessionIndex);
        }
    }

    public Map<RedirectEvent, CustomRedirectInfo> getRedirections() {
        CustomRedirectInfo automaticLogout;
        CustomRedirectInfo manualLogout;
        HashMap<RedirectEvent, CustomRedirectInfo> map = new HashMap<RedirectEvent, CustomRedirectInfo>();
        PostAuthHandlersConfigDto postAuthHandlersConfiguration = this.getPostAuthHandlersConfiguration();
        if (postAuthHandlersConfiguration == null) {
            return map;
        }
        CustomRedirectInfo authFailed = this.createRedirectInfo(this.getPostAuthHandlersConfiguration().getAuthenticationFailedRedirect());
        if (authFailed != null) {
            map.put(RedirectEvent.AUTHENTICATION_FAILED, authFailed);
        }
        if ((manualLogout = this.createRedirectInfo(this.getPostAuthHandlersConfiguration().getManualLogOutRedirect())) != null) {
            map.put(RedirectEvent.MANUAL_LOGOUT, manualLogout);
        }
        if ((automaticLogout = this.createRedirectInfo(this.getPostAuthHandlersConfiguration().getAutomaticLogOutRedirect())) != null) {
            map.put(RedirectEvent.AUTOMATIC_LOGOUT, automaticLogout);
        }
        return map;
    }

    private CustomRedirectInfo createRedirectInfo(ConfigCustomRedirect config) {
        Map<String, String> localizedValues;
        if (config == null) {
            return null;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)config.getValue())) {
            values.put(CustomRedirectInfo.DEFAULT_LOCALE_KEY, config.getValue());
        }
        if ((localizedValues = config.getLocalizedValue()) != null && !localizedValues.isEmpty()) {
            localizedValues.forEach((key, value) -> {
                if (StringUtils.isBlank((CharSequence)key)) {
                    throw new IllegalArgumentException("Localized value for redirection cannot have an empty key");
                }
                values.put((String)key, (String)value);
            });
        }
        return new CustomRedirectInfo(config.getRedirectType(), values);
    }

    private ConfigurationDto getConfiguration() {
        if (this.configuration == null) {
            try {
                String config = IOUtils.toString((InputStream)this.fileConfigurationService.readFile(this.plugin.getKey(), CONFIG_FILE_ID), (Charset)Charset.defaultCharset());
                this.configuration = (ConfigurationDto)this.gson.fromJson(config, ConfigurationDto.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.configuration;
    }

    public void refreshConfig() {
        this.configuration = null;
        this.getConfiguration();
    }

    private PostAuthHandlersConfigDto getPostAuthHandlersConfiguration() {
        if (this.postAuthHandlersConfiguration == null) {
            try {
                String config = IOUtils.toString((InputStream)this.fileConfigurationService.readFile(this.plugin.getKey(), POST_AUTH_HANDLERS), (Charset)Charset.defaultCharset());
                this.postAuthHandlersConfiguration = (PostAuthHandlersConfigDto)this.gson.fromJson(config, PostAuthHandlersConfigDto.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.postAuthHandlersConfiguration;
    }

    public List<ExtraAuthVerifier> getExtraAuthVerifiers() {
        if (CollectionUtils.isEmpty(this.extraAuthVerifiers)) {
            this.extraAuthVerifiers = this.extraAuthVerifiersFactory.generateExtraVerifiers(this.getPostAuthHandlersConfiguration());
        }
        return this.extraAuthVerifiers;
    }

    private static Map<String, List<String>> extractSamlAttributes(List<AttributeStatement> attributeStatements) {
        return attributeStatements.stream().flatMap(statement -> statement.getAttributes().stream()).collect(Collectors.toMap(Attribute::getName, attr -> attr.getAttributeValues().stream().map(value -> value.getDOM().getTextContent()).collect(Collectors.toList()), (existing, replacement) -> {
            existing.addAll(replacement);
            return existing;
        }));
    }

    private AuthenticationButton generateErrorButton() {
        return AuthenticationButton.builder().name(this.translator.getMessage("sso.authenticator.buttonNameError")).styles(this.buttonErrorStyles()).build();
    }

    private Map<String, String> generatePostParameters() {
        this.validateSooConfiguration();
        if (this.getConfiguration().getSolution().isSamlSolution()) {
            SamlRequest samlRequest = this.generateSamlRequest();
            String relayState = Base64.getEncoder().encodeToString(samlRequest.getRequestId().getBytes());
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("SAMLRequest", samlRequest.getEncodedSamlRequest());
            parameters.put(RELAY_STATE_KEY, relayState);
            return parameters;
        }
        throw new UnsupportedAuthenticationSolutionException(this.getConfiguration().getSolution());
    }

    private SamlRequest generateSamlRequest() {
        try {
            return this.getClient().getSamlRequest();
        }
        catch (SamlException e) {
            throw new RuntimeException(e);
        }
    }

    private SamlResponse getSamlResponse(HttpServletRequest request) throws Exception {
        if (this.getConfiguration().getSolution().isSamlSolution()) {
            String encodedResponse = request.getParameter("SAMLResponse");
            String requestId = this.getRequestIdFromRealState(request);
            return this.getClient().decodeAndValidateSamlResponse(encodedResponse, requestId, "POST");
        }
        throw new UnsupportedAuthenticationSolutionException(this.getConfiguration().getSolution());
    }

    private String getRequestIdFromRealState(HttpServletRequest request) {
        String relayState = request.getParameter(RELAY_STATE_KEY);
        if (relayState == null) {
            return null;
        }
        return new String(Base64.getDecoder().decode(relayState));
    }

    private void validateSooConfiguration() {
        if (this.getConfiguration() == null || this.getConfiguration().getSolution() == null) {
            throw new SsoConfigurationMissingException();
        }
    }

    private Map<String, String> buttonStyles() {
        HashMap<String, String> styles = new HashMap<String, String>();
        styles.put("color", "white");
        styles.put("background", "linear-gradient(#007dc1,#0073b2)");
        styles.put("border-color", "#004b75");
        return styles;
    }

    private Map<String, String> buttonErrorStyles() {
        HashMap<String, String> styles = new HashMap<String, String>();
        styles.put("color", "white");
        styles.put("background", "linear-gradient(#EB6262,#EF7272)");
        styles.put("border-color", "#FF2D2D");
        return styles;
    }
}

