/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.sso.authenticator.configuration.saml;

import com.coveo.saml.SamlException;
import com.coveo.saml.SamlLogoutResponse;
import com.coveo.saml.SamlResponse;
import com.coveo.saml.XMLHelper;
import com.suncode.sso.authenticator.configuration.saml.SamlRequest;
import com.suncode.sso.authenticator.configuration.saml.ValidatorUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.opensaml.saml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.saml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml.saml2.core.impl.StatusMessageBuilder;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.impl.ChainingKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.CollectionKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.impl.SignatureBuilder;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlClient {
    private static final Logger log = LoggerFactory.getLogger(SamlClient.class);
    public static final String HTTP_REQ_SAML_PARAM = "SAMLRequest";
    public static final String HTTP_RESP_SAML_PARAM = "SAMLResponse";
    private static boolean initializedOpenSaml = false;
    private final BasicParserPool domParser;
    private final String relyingPartyIdentifier;
    private final String assertionConsumerServiceUrl;
    private final String identityProviderUrl;
    private final String responseIssuer;
    private final List<Credential> credentials;
    private final long notBeforeSkew;
    private final SamlIdpBinding samlBinding;
    private BasicX509Credential spCredential;
    private final List<Credential> additionalSpCredentials = new ArrayList<Credential>();

    public SamlClient(String relyingPartyIdentifier, String assertionConsumerServiceUrl, String identityProviderUrl, String responseIssuer, List<X509Certificate> certificates, SamlIdpBinding samlBinding) throws SamlException {
        this.notBeforeSkew = 0L;
        SamlClient.ensureOpenSamlIsInitialized();
        if (relyingPartyIdentifier == null) {
            throw new IllegalArgumentException("relyingPartyIdentifier");
        }
        if (identityProviderUrl == null) {
            throw new IllegalArgumentException("identityProviderUrl");
        }
        if (responseIssuer == null) {
            throw new IllegalArgumentException("responseIssuer");
        }
        if (certificates == null || certificates.isEmpty()) {
            throw new IllegalArgumentException("certificates");
        }
        this.relyingPartyIdentifier = relyingPartyIdentifier;
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
        this.identityProviderUrl = identityProviderUrl;
        this.responseIssuer = responseIssuer;
        this.credentials = certificates.stream().map(SamlClient::getCredential).collect(Collectors.toList());
        this.samlBinding = samlBinding;
        this.domParser = SamlClient.createDOMParser();
    }

    public SamlResponse decodeAndValidateSamlResponse(String encodedResponse, String requestId, String method) throws SamlException {
        Response response = (Response)this.parseResponse(encodedResponse, method);
        if (requestId != null && !response.getInResponseTo().equals(requestId)) {
            throw new SamlException("The response 'inResponseTo' value didn't match the expected value");
        }
        try {
            this.decodeEncryptedAssertion(response);
        }
        catch (DecryptionException ex) {
            throw new SamlException("Cannot decrypt the assertion", (Throwable)ex);
        }
        ValidatorUtils.validate(response, this.responseIssuer, this.credentials, DateTime.now(), this.notBeforeSkew);
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        return new SamlResponse(assertion);
    }

    public static SamlClient fromMetadata(String relyingPartyIdentifier, String assertionConsumerServiceUrl, Reader metadata) throws SamlException {
        return SamlClient.fromMetadata(relyingPartyIdentifier, assertionConsumerServiceUrl, metadata, SamlIdpBinding.POST);
    }

    public static SamlClient fromMetadata(String relyingPartyIdentifier, String assertionConsumerServiceUrl, Reader metadata, SamlIdpBinding samlBinding) throws SamlException {
        return SamlClient.fromMetadata(relyingPartyIdentifier, assertionConsumerServiceUrl, metadata, samlBinding, null);
    }

    public static SamlClient fromMetadata(String relyingPartyIdentifier, String assertionConsumerServiceUrl, Reader metadata, SamlIdpBinding samlBinding, List<X509Certificate> certificates) throws SamlException {
        SamlClient.ensureOpenSamlIsInitialized();
        DOMMetadataResolver metadataResolver = SamlClient.createMetadataResolver(SamlClient.skipBom(metadata));
        EntityDescriptor entityDescriptor = SamlClient.getEntityDescriptor(metadataResolver);
        IDPSSODescriptor idpSsoDescriptor = SamlClient.getIDPSSODescriptor(entityDescriptor);
        SingleSignOnService idpBinding = null;
        if (idpSsoDescriptor.getSingleSignOnServices() != null && !idpSsoDescriptor.getSingleSignOnServices().isEmpty()) {
            idpBinding = SamlClient.getIdpBinding(idpSsoDescriptor, samlBinding);
        }
        List<X509Certificate> x509Certificates = SamlClient.getCertificates(idpSsoDescriptor);
        boolean isOkta = entityDescriptor.getEntityID().contains(".okta.com");
        if (relyingPartyIdentifier == null) {
            if (!isOkta) {
                throw new IllegalArgumentException("relyingPartyIdentifier");
            }
            relyingPartyIdentifier = entityDescriptor.getEntityID();
        }
        if (idpBinding != null && assertionConsumerServiceUrl == null && isOkta) {
            assertionConsumerServiceUrl = idpBinding.getLocation();
        }
        if (certificates != null) {
            x509Certificates.addAll(certificates);
        }
        if (idpBinding == null) {
            throw new SamlException("Cannot find identity provider url in idp entity descriptor (bindings:HTTP)");
        }
        String identityProviderUrl = idpBinding.getLocation();
        String responseIssuer = entityDescriptor.getEntityID();
        return new SamlClient(relyingPartyIdentifier, assertionConsumerServiceUrl, identityProviderUrl, responseIssuer, x509Certificates, samlBinding);
    }

    private static InputStream skipBom(Reader metadata) throws SamlException {
        try {
            InputStream metadataInputStream = IOUtils.toInputStream((String)IOUtils.toString((Reader)metadata), (Charset)StandardCharsets.UTF_8);
            return new BOMInputStream(metadataInputStream, false);
        }
        catch (IOException ex) {
            throw new SamlException("Couldn't read metadata", (Throwable)ex);
        }
    }

    private static ByteArrayInputStream decode(String encodedResponse) {
        return new ByteArrayInputStream(Base64.decodeBase64((String)encodedResponse));
    }

    private static Reader inflate(ByteArrayInputStream decodedResponse) {
        InflaterInputStream afterInflate = new InflaterInputStream(decodedResponse, new Inflater(true));
        return new InputStreamReader((InputStream)afterInflate, StandardCharsets.UTF_8);
    }

    private static synchronized void ensureOpenSamlIsInitialized() throws SamlException {
        if (!initializedOpenSaml) {
            try {
                InitializationService.initialize();
                initializedOpenSaml = true;
            }
            catch (Throwable ex) {
                throw new SamlException("Error while initializing the Open SAML library", ex);
            }
        }
    }

    private static BasicParserPool createDOMParser() throws SamlException {
        BasicParserPool basicParserPool = new BasicParserPool();
        try {
            basicParserPool.initialize();
            return basicParserPool;
        }
        catch (ComponentInitializationException ex) {
            throw new SamlException("Failed to create an XML parser");
        }
    }

    private static DOMMetadataResolver createMetadataResolver(InputStream metadata) throws SamlException {
        try {
            BasicParserPool parser = SamlClient.createDOMParser();
            Document metadataDocument = parser.parse(metadata);
            if (metadataDocument.getDocumentElement() == null) {
                throw new SamlException("Id Provider Entity Descriptor is empty");
            }
            DOMMetadataResolver resolver = new DOMMetadataResolver(metadataDocument.getDocumentElement());
            resolver.setId("componentId");
            resolver.initialize();
            return resolver;
        }
        catch (ComponentInitializationException | XMLParserException ex) {
            throw new SamlException("Cannot load identity provider metadata", ex);
        }
    }

    private static EntityDescriptor getEntityDescriptor(DOMMetadataResolver metadata) throws SamlException {
        ArrayList entityDescriptors = new ArrayList();
        Objects.requireNonNull(entityDescriptors);
        metadata.forEach(entityDescriptors::add);
        if (entityDescriptors.size() != 1) {
            throw new SamlException("Bad entity descriptor count: " + entityDescriptors.size());
        }
        return (EntityDescriptor)entityDescriptors.get(0);
    }

    private static IDPSSODescriptor getIDPSSODescriptor(EntityDescriptor entityDescriptor) throws SamlException {
        IDPSSODescriptor idpssoDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (idpssoDescriptor == null) {
            throw new SamlException("Cannot retrieve IDP SSO descriptor");
        }
        return idpssoDescriptor;
    }

    private static SingleSignOnService getIdpBinding(IDPSSODescriptor idpSsoDescriptor, SamlIdpBinding samlBinding) throws SamlException {
        return idpSsoDescriptor.getSingleSignOnServices().stream().filter(x -> x.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-" + samlBinding.toString())).findAny().orElseThrow(() -> new SamlException("Cannot find HTTP-POST SSO binding in metadata"));
    }

    private static List<X509Certificate> getCertificates(IDPSSODescriptor idpSsoDescriptor) throws SamlException {
        try {
            return idpSsoDescriptor.getKeyDescriptors().stream().filter(x -> x.getUse() == UsageType.SIGNING).flatMap(SamlClient::getDatasWithCertificates).map(SamlClient::getFirstCertificate).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw new SamlException("Exception in getCertificates", (Throwable)ex);
        }
    }

    private static Stream<X509Data> getDatasWithCertificates(KeyDescriptor descriptor) {
        return descriptor.getKeyInfo().getX509Datas().stream().filter(d -> d.getX509Certificates().size() > 0);
    }

    private static X509Certificate getFirstCertificate(X509Data data) {
        try {
            org.opensaml.xmlsec.signature.X509Certificate cert = data.getX509Certificates().stream().findFirst().orElse(null);
            if (cert != null) {
                return KeyInfoSupport.getCertificate((org.opensaml.xmlsec.signature.X509Certificate)cert);
            }
        }
        catch (CertificateException ex) {
            log.error("Exception in getFirstCertificate", (Throwable)ex);
        }
        return null;
    }

    private static Credential getCredential(X509Certificate certificate) {
        BasicX509Credential credential = new BasicX509Credential(certificate);
        credential.setCRLs(Collections.emptyList());
        return credential;
    }

    public SamlLogoutResponse decodeAndValidateSamlLogoutResponse(String encodedResponse, String requestId) throws SamlException {
        LogoutResponse logoutResponse = (LogoutResponse)this.parseLogOutResponse(encodedResponse);
        if (requestId != null && !logoutResponse.getInResponseTo().equals(requestId)) {
            throw new SamlException("The response 'inResponseTo' value didn't match the expected value");
        }
        ValidatorUtils.validate(logoutResponse, this.responseIssuer, this.credentials);
        return new SamlLogoutResponse(logoutResponse.getStatus());
    }

    public LogoutRequest decodeSamlLogoutRequest(String encodedRequest) throws SamlException {
        return (LogoutRequest)this.parseLogOutResponse(encodedRequest);
    }

    public void validateSamlLogoutRequest(LogoutRequest decodedRequest) throws SamlException {
        ValidatorUtils.validate(decodedRequest, this.responseIssuer, this.credentials);
    }

    public void setSPKeys(String publicKey, String privateKey) throws SamlException {
        this.spCredential = this.generateBasicX509Credential(publicKey, privateKey);
    }

    private BasicX509Credential generateBasicX509Credential(String publicKey, String privateKey) throws SamlException {
        if (publicKey != null && privateKey != null) {
            PrivateKey pk = this.loadPrivateKey(privateKey);
            X509Certificate cert = this.loadCertificate(publicKey);
            return new BasicX509Credential(cert, pk);
        }
        throw new SamlException("No credentials provided");
    }

    public void setSPKeys(X509Certificate certificate, PrivateKey privateKey) throws SamlException {
        if (certificate == null || privateKey == null) {
            throw new SamlException("No credentials provided");
        }
        this.spCredential = new BasicX509Credential(certificate, privateKey);
    }

    private RequestAbstractType getBasicSamlRequest(QName defaultElementName) {
        RequestAbstractType request = (RequestAbstractType)SamlClient.buildSamlObject(defaultElementName);
        request.setID("z" + UUID.randomUUID().toString());
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIssueInstant(DateTime.now());
        Issuer issuer = (Issuer)SamlClient.buildSamlObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(this.relyingPartyIdentifier);
        request.setIssuer(issuer);
        return request;
    }

    private String marshall(SignableSAMLObject request) throws SamlException {
        StringWriter stringWriter;
        try {
            stringWriter = this.marshallXmlObject((XMLObject)request);
        }
        catch (MarshallingException ex) {
            throw new SamlException("Error while marshalling SAML request to XML", (Throwable)ex);
        }
        log.trace("Issuing SAML request: {}", (Object)stringWriter.toString());
        return stringWriter.toString();
    }

    public SamlRequest getSamlRequest() throws SamlException {
        AuthnRequest request = (AuthnRequest)this.getBasicSamlRequest(AuthnRequest.DEFAULT_ELEMENT_NAME);
        request.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-" + this.samlBinding.toString());
        request.setDestination(this.identityProviderUrl);
        request.setAssertionConsumerServiceURL(this.assertionConsumerServiceUrl);
        NameIDPolicy nameIDPolicy = (NameIDPolicy)SamlClient.buildSamlObject(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        request.setNameIDPolicy(nameIDPolicy);
        this.signSAMLObject((SignableSAMLObject)request);
        String marshall = this.marshall((SignableSAMLObject)request);
        String encodedRequest = Base64.encodeBase64String((byte[])marshall.getBytes(StandardCharsets.UTF_8));
        return new SamlRequest(encodedRequest, request.getID());
    }

    public SamlRequest getLogoutRequest(String nameId, String sessionIndex, boolean sign, boolean deflate) throws Exception {
        LogoutRequest request = (LogoutRequest)this.getBasicSamlRequest(LogoutRequest.DEFAULT_ELEMENT_NAME);
        NameID nid = (NameID)SamlClient.buildSamlObject(NameID.DEFAULT_ELEMENT_NAME);
        nid.setValue(nameId);
        request.setNameID(nid);
        if (StringUtils.isNotBlank((CharSequence)sessionIndex)) {
            SessionIndexBuilder sessionIndexBuilder = (SessionIndexBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(SessionIndex.DEFAULT_ELEMENT_NAME);
            SessionIndex sessionIndexElement = sessionIndexBuilder.buildObject();
            sessionIndexElement.setSessionIndex(sessionIndex);
            request.getSessionIndexes().add(sessionIndexElement);
        }
        if (sign) {
            this.signSAMLObject((SignableSAMLObject)request);
        }
        String marshall = this.marshall((SignableSAMLObject)request);
        String encodedRequest = deflate ? SamlClient.deflateAndBase64Encode(marshall) : Base64.encodeBase64String((byte[])marshall.getBytes(StandardCharsets.UTF_8));
        return new SamlRequest(encodedRequest, request.getID());
    }

    private static String deflateAndBase64Encode(String xml) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(8, true);
        try (DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);){
            deflaterOutputStream.write(xml.getBytes(StandardCharsets.UTF_8));
        }
        return java.util.Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
    }

    public String getSamlLogoutResponse(String status, String statMsg, String inResponseT, boolean sign, boolean deflate) throws Exception {
        LogoutResponse response = (LogoutResponse)SamlClient.buildSamlObject(LogoutResponse.DEFAULT_ELEMENT_NAME);
        response.setID("z" + UUID.randomUUID());
        response.setVersion(SAMLVersion.VERSION_20);
        response.setIssueInstant(DateTime.now());
        response.setInResponseTo(inResponseT);
        Issuer issuer = (Issuer)SamlClient.buildSamlObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(this.relyingPartyIdentifier);
        response.setIssuer(issuer);
        Status stat = (Status)SamlClient.buildSamlObject(Status.DEFAULT_ELEMENT_NAME);
        StatusCode statCode = new StatusCodeBuilder().buildObject();
        statCode.setValue(status);
        stat.setStatusCode(statCode);
        if (statMsg != null) {
            StatusMessage statMessage = new StatusMessageBuilder().buildObject();
            statMessage.setMessage(statMsg);
            stat.setStatusMessage(statMessage);
        }
        response.setStatus(stat);
        if (sign) {
            this.signSAMLObject((SignableSAMLObject)response);
        }
        String marshal = this.marshall((SignableSAMLObject)response);
        log.trace("Issuing SAML Logout request: {}", (Object)marshal);
        if (deflate) {
            return SamlClient.deflateAndBase64Encode(marshal);
        }
        return Base64.encodeBase64String((byte[])marshal.getBytes(StandardCharsets.UTF_8));
    }

    private static XMLObject buildSamlObject(QName qname) {
        return XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(qname).buildObject(qname);
    }

    private void decodeEncryptedAssertion(Response response) throws DecryptionException {
        if (response.getEncryptedAssertions().size() != 0) {
            for (EncryptedAssertion encryptedAssertion : response.getEncryptedAssertions()) {
                ArrayList<Object> resolverChain = new ArrayList<Object>();
                if (this.spCredential != null) {
                    resolverChain.add(new StaticKeyInfoCredentialResolver((Credential)this.spCredential));
                }
                if (!this.additionalSpCredentials.isEmpty()) {
                    resolverChain.add(new CollectionKeyInfoCredentialResolver(this.additionalSpCredentials));
                }
                Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)new ChainingKeyInfoCredentialResolver(resolverChain), (EncryptedKeyResolver)new InlineEncryptedKeyResolver());
                decrypter.setRootInNewDocument(true);
                Assertion decryptedAssertion = decrypter.decrypt(encryptedAssertion);
                response.getAssertions().add(decryptedAssertion);
            }
        }
    }

    private X509Certificate loadCertificate(String filename) throws SamlException {
        try {
            X509Certificate var5;
            try (FileInputStream fis = new FileInputStream(filename);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                var5 = (X509Certificate)cf.generateCertificate(bis);
            }
            return var5;
        }
        catch (FileNotFoundException ex) {
            throw new SamlException("Public key file doesn't exist", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new SamlException("Couldn't load public key", (Throwable)ex);
        }
    }

    private PrivateKey loadPrivateKey(String filename) throws SamlException {
        try {
            PrivateKey var6;
            try (RandomAccessFile raf = new RandomAccessFile(filename, "r");){
                byte[] buf = new byte[(int)raf.length()];
                raf.readFully(buf);
                PKCS8EncodedKeySpec kspec = new PKCS8EncodedKeySpec(buf);
                KeyFactory kf = KeyFactory.getInstance("RSA");
                var6 = kf.generatePrivate(kspec);
            }
            return var6;
        }
        catch (FileNotFoundException ex) {
            throw new SamlException("Private key file doesn't exist", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new SamlException("Couldn't load private key", (Throwable)ex);
        }
    }

    private StringWriter marshallXmlObject(XMLObject object) throws MarshallingException {
        StringWriter stringWriter = new StringWriter();
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(object);
        Element dom = marshaller.marshall(object);
        XMLHelper.writeNode((Node)dom, (Writer)stringWriter);
        return stringWriter;
    }

    private SAMLObject parseResponse(String encodedResponse, String method) throws SamlException {
        log.trace("Validating SAML response {}", (Object)encodedResponse);
        try {
            Document responseDocument;
            ByteArrayInputStream decodedResponse = SamlClient.decode(encodedResponse);
            if (HttpMethod.GET.matches(method)) {
                Reader afterInflate = SamlClient.inflate(decodedResponse);
                responseDocument = this.domParser.parse(afterInflate);
            } else {
                responseDocument = this.domParser.parse((Reader)new InputStreamReader((InputStream)decodedResponse, StandardCharsets.UTF_8));
            }
            return (SAMLObject)XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(responseDocument.getDocumentElement()).unmarshall(responseDocument.getDocumentElement());
        }
        catch (XMLParserException | UnmarshallingException ex) {
            throw new SamlException("Cannot decode xml encoded response", ex);
        }
    }

    private SAMLObject parseLogOutResponse(String encodedResponse) throws SamlException {
        log.trace("Validating SAML response {}", (Object)encodedResponse);
        try {
            ByteArrayInputStream decodedResponse = SamlClient.decode(encodedResponse);
            Reader afterInflate = SamlClient.inflate(decodedResponse);
            Document responseDocument = this.domParser.parse(afterInflate);
            return (SAMLObject)XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(responseDocument.getDocumentElement()).unmarshall(responseDocument.getDocumentElement());
        }
        catch (XMLParserException | UnmarshallingException ex) {
            throw new SamlException("Cannot decode xml encoded response", ex);
        }
    }

    private void signSAMLObject(SignableSAMLObject samlObject) throws SamlException {
        if (this.spCredential != null) {
            try {
                SignatureBuilder signer = new SignatureBuilder();
                Signature signature = (Signature)signer.buildObject(Signature.DEFAULT_ELEMENT_NAME);
                signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
                X509KeyInfoGeneratorFactory x509Factory = new X509KeyInfoGeneratorFactory();
                x509Factory.setEmitEntityCertificate(true);
                x509Factory.setEmitPublicKeyValue(true);
                KeyInfoGenerator x509instance = x509Factory.newInstance();
                signature.setKeyInfo(x509instance.generate((Credential)this.spCredential));
                signature.setSigningCredential((Credential)this.spCredential);
                samlObject.setSignature(signature);
                SignatureSigningParameters signingParameters = new SignatureSigningParameters();
                signingParameters.setSigningCredential((Credential)this.spCredential);
                signingParameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                signingParameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
                signingParameters.setKeyInfoGenerator(x509instance);
                SignatureSupport.signObject((SignableXMLObject)samlObject, (SignatureSigningParameters)signingParameters);
            }
            catch (MarshallingException | SecurityException | SignatureException ex) {
                throw new SamlException("Failed to sign request", ex);
            }
        }
    }

    public static enum SamlIdpBinding {
        POST,
        Redirect;

    }
}

