window.vfgFileSchema = {
  fields: [
    {
      type: "checkbox",
      label: "Active",
      model: "active",
    },
    {
      type: "checkbox",
      label: "Auto login",
      model: "autoLogin",
    },
    {
      type: "select",
      inputType: "text",
      label: "Solution",
      model: "solution",
      required: true,
      validator: "string",
      values: function () {
        let data;
        jQuery.ajax({
          url: "plugin/com.suncode.plugin-plus-sso-authenticator/config/solution/supported",
          success: function (result) {
            data = result;
          },
          async: false,
        });
        return data;
      },
    },
    {
      type: "checkbox",
      label: "Disable SingLogOut",
      model: "disableSingleLogOut",
    },
  ],
  groups: [
    {
      legend: "Parameters",
      fields: [
        {
          type: "input",
          inputType: "text",
          label: "Version",
          model: "samlConfig.version",
          validator: "string",
          visible: function (model) {
            return model.solution == "Azure" || model.solution == "SAP";
          },
        },
        {
          type: "input",
          inputType: "text",
          label: "Issue instant date format",
          model: "samlConfig.issueInstantDateFormat",
          required: true,
          validator: "string"
        },
        {
          type: "input",
          inputType: "text",
          label: "Issuer",
          model: "samlConfig.issuer",
          required: true,
          validator: "string"
        },
        {
          type: "input",
          inputType: "text",
          label: "Assertion Consumer Service URL",
          model: "samlConfig.assertionConsumerServiceURL",
          visible: function (model) {
            return model.solution != "Azure";
          },
        },
        {
          type: "input",
          inputType: "text",
          label: "Force Authn",
          model: "samlConfig.forceAuthn",
          visible: function (model) {
            return model.solution != "WAC";
          },
        },
        {
          type: "input",
          inputType: "text",
          label: "Is Passive",
          model: "samlConfig.isPassive",
          visible: function (model) {
            return model.solution != "WAC";
          },
        },
      ],
      visible: function (model) {
        return model.solution != "WAC";
      },
    },
    {
      legend: "Key Store",
      fields: [
        {
          type: "input",
          inputType: "text",
          label: "Path",
          model: "keyStore.keyStorePath",
          required: false,
          validator: "string",
          visible: function (model) {
            return model.solution != "WAC";
          },
        },{
          type: "input",
          inputType: "text",
          label: "Alias",
          model: "keyStore.alias",
          required: false,
          validator: "string",
          visible: function (model) {
            return model.solution != "WAC";
          },
        },
        {
          type: "input",
          inputType: "text",
          label: "Key store password",
          model: "keyStore.keyStorePassword",
          required: false,
          validator: "string",
          visible: function (model) {
            return model.solution != "WAC";
          },
        },{
          type: "input",
          inputType: "text",
          label: "Private Key Password",
          model: "keyStore.privateKeyPassword",
          required: false,
          validator: "string",
          visible: function (model) {
            return model.solution != "WAC";
          },
        },
      ],
      visible: function (model) {
        return model.solution != "WAC";
      },
    },
  ],
};
