/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.sso.authenticator.configuration;

import com.google.gson.Gson;
import com.plusmpm.security.DesEncrypter;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.beforesave.BeforeSaveConfigModifierProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.model.FileType;
import com.suncode.sso.authenticator.configuration.ConfigurationDto;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class BeforeSaveConfigModifierProviderImpl
implements BeforeSaveConfigModifierProvider {
    private final Gson gson = new Gson();
    private final DesEncrypter desEncrypter = new DesEncrypter();

    public InputStream modifyConfig(InputStream config, String readableFileId, FileType fileType) {
        if (readableFileId.equalsIgnoreCase("SSO Config")) {
            try {
                String configurationString = IOUtils.toString((InputStream)config, (Charset)Charset.defaultCharset());
                ConfigurationDto configurationDto = (ConfigurationDto)this.gson.fromJson(configurationString, ConfigurationDto.class);
                if (configurationDto.getKeyStore() != null && !configurationDto.getKeyStore().getKeyStorePassword().startsWith("enc:")) {
                    configurationDto.getKeyStore().setKeyStorePassword("enc:" + this.desEncrypter.encrypt(configurationDto.getKeyStore().getKeyStorePassword()));
                }
                if (configurationDto.getKeyStore() != null && !configurationDto.getKeyStore().getPrivateKeyPassword().startsWith("enc:")) {
                    configurationDto.getKeyStore().setPrivateKeyPassword("enc:" + this.desEncrypter.encrypt(configurationDto.getKeyStore().getPrivateKeyPassword()));
                }
                InputStream inputStream = IOUtils.toInputStream((String)this.gson.toJson((Object)configurationDto), (Charset)Charset.defaultCharset());
                return inputStream;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    config.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return config;
    }
}

