/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.utils;

import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.dto.DomesticBankTransferDto;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.dto.ForeignBankTransferDto;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.dto.PlaBankTransferDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Formatter {
    public static final String CHARS = "A-Za-z";
    public static final String NUMERIC_CHARS = "0-9";
    private static final String SEMICOLON = ";";
    private static final String END_LINE = "\r\n";
    private static final String NEW_LINE_REGEXP = "\\\\n";
    private static final String NEW_LINE = "\n";
    private static final int MAX_MULTILINES = 4;
    private static final int MAX_LINE_LENGTH = 35;

    public static String writeHeaderLine(List<String> headerLine) {
        return String.join((CharSequence)SEMICOLON, headerLine) + END_LINE;
    }

    public static String bankTransfer(List<String> line) {
        return String.join((CharSequence)SEMICOLON, line) + END_LINE;
    }

    public static String substringAndReplace(String value, int length, String ... accept) {
        if (accept.length > 0) {
            value = value.replaceAll("^[^" + String.join((CharSequence)"", accept) + "]+", "");
        }
        return value.length() > length ? value.substring(0, length) : value;
    }

    private String splitLines(String ... parts) {
        StringBuilder sb = new StringBuilder();
        ArrayList lines = new ArrayList();
        for (String part : parts) {
            String[] split = part.split(NEW_LINE_REGEXP);
            Collections.addAll(lines, split);
        }
        int lineCounter = Math.min(lines.size(), 4);
        for (int i = 0; i < lineCounter; ++i) {
            String line = StringUtils.substring((String)((String)lines.get(i)), (int)0, (int)35);
            sb.append(line).append(NEW_LINE);
        }
        int lastNewLine = sb.lastIndexOf(NEW_LINE);
        if (lastNewLine >= 0) {
            sb.delete(lastNewLine, sb.length());
        }
        return sb.toString();
    }

    public String domesticBankTransfer(DomesticBankTransferDto domesticBankTransfer) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(domesticBankTransfer.getAmount()).append(SEMICOLON).append(domesticBankTransfer.getBeneficiaryName()).append(SEMICOLON).append(domesticBankTransfer.getBeneficiaryAccountNumber()).append(SEMICOLON).append(domesticBankTransfer.getPrincipalAccountNumber()).append(SEMICOLON).append(domesticBankTransfer.getPaymentDetails()).append(SEMICOLON).append(domesticBankTransfer.getExecutionDate()).append(SEMICOLON).append(domesticBankTransfer.getIgnoreField()).append(SEMICOLON).append(domesticBankTransfer.getBeneficiaryCityName()).append(SEMICOLON).append(domesticBankTransfer.getSignature()).append(SEMICOLON).append(domesticBankTransfer.getProcessingType()).append(SEMICOLON).append(domesticBankTransfer.getBeneficiaryStreetName()).append(SEMICOLON).append(domesticBankTransfer.getConfirmationEmailAddress()).append(SEMICOLON).append(domesticBankTransfer.getConfirmationSmsNumber()).append(END_LINE);
        return stringBuilder.toString();
    }

    public String foreignBankTransfer(ForeignBankTransferDto foreignBankTransfer) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(foreignBankTransfer.getBeneficiaryBankCountryCode()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryCountryCode()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryBankSwiftCode()).append(SEMICOLON).append(foreignBankTransfer.getAmount()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryCityName()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryName()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryAccountNumber()).append(SEMICOLON).append(foreignBankTransfer.getPrincipalAccountNumber()).append(SEMICOLON).append(foreignBankTransfer.getPaymentDetails()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryStreetName()).append(SEMICOLON).append(foreignBankTransfer.getCurrency()).append(SEMICOLON).append(foreignBankTransfer.getAnnotations()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryBankAddress()).append(SEMICOLON).append(foreignBankTransfer.getExecutionDate()).append(SEMICOLON).append(foreignBankTransfer.getIgnoreField()).append(SEMICOLON).append(foreignBankTransfer.getStatisticsCode()).append(SEMICOLON).append(foreignBankTransfer.getPaymentMethod()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryBankName()).append(SEMICOLON).append(foreignBankTransfer.getContactPerson()).append(SEMICOLON).append(foreignBankTransfer.getCostAccountingAccountNumber()).append(SEMICOLON).append(foreignBankTransfer.getCostAccountingMethod()).append(SEMICOLON).append(foreignBankTransfer.getSignature()).append(SEMICOLON).append(foreignBankTransfer.getEndToEndId()).append(SEMICOLON).append(foreignBankTransfer.getContactPhoneNumber()).append(SEMICOLON).append(foreignBankTransfer.getPaymentMode()).append(SEMICOLON).append(foreignBankTransfer.getContractorType()).append(SEMICOLON).append(foreignBankTransfer.getPrincipalBicId()).append(SEMICOLON).append(foreignBankTransfer.getPrincipalOrganizationId()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryBicId()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryOrganizationId()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryOtherId()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryDateOfBirth()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryBirthCityName()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryBirthDistrictName()).append(SEMICOLON).append(foreignBankTransfer.getBeneficiaryBirthCountryCode()).append(SEMICOLON).append(foreignBankTransfer.getConfirmationEmailAddress()).append(SEMICOLON).append(foreignBankTransfer.getConfirmationSmsNumber()).append(END_LINE);
        return stringBuilder.toString();
    }

    public String plaTransferHeader(PlaBankTransferDto.PlaTransferHeaderDto header, String decimalSeparator) {
        return "\r\n:01:" + header.getReference() + END_LINE + ":02:" + header.getTotalAmount().toString().replace(".", decimalSeparator) + END_LINE + ":03:" + header.getTransferCount() + END_LINE + ":04:" + header.getPrincipalBankSwiftCode() + END_LINE + ":05:" + this.splitLines(header.getPrincipalName(), header.getPrincipalAddress()) + END_LINE + ":07:" + header.getFilename();
    }

    public String plaTransfer(PlaBankTransferDto.PlaTransferDto transfer, String decimalSeparator) {
        String beneficiaryBankData = StringUtils.isNotBlank((CharSequence)transfer.getBeneficiaryBankSwiftCode()) ? "\r\n:57A:" + transfer.getBeneficiaryBankSwiftCode() : "\r\n:57D:" + this.splitLines(transfer.getBeneficiaryBankName(), transfer.getBeneficiaryBankAddress());
        String feesData = "00 00 00 00";
        if (StringUtils.isNotBlank((CharSequence)transfer.getExtraData())) {
            feesData = feesData + END_LINE + this.splitLines(transfer.getExtraData());
        }
        String beneficiaryBankIdentifier = StringUtils.isNotBlank((CharSequence)transfer.getBeneficiaryBankNumber()) ? transfer.getBeneficiaryBankNumber() : transfer.getBeneficiaryBankSwiftCode();
        return "\r\n{:F01" + String.format("%1$-12s", transfer.getPrincipalBankSwiftCode()).replace(' ', 'X') + transfer.getShipmentNumber() + transfer.getTransferNumber() + "}{2:I100" + String.format("%1$-12s", beneficiaryBankIdentifier).replace(' ', 'X') + transfer.getTransferType() + "1}{4:" + END_LINE + ":20:" + transfer.getSignature() + END_LINE + ":32A:" + transfer.getTransferDate().toString("yyMMdd") + transfer.getCurrency() + transfer.getAmount().toString().replace(".", decimalSeparator) + END_LINE + ":50:" + this.splitLines(transfer.getPrincipalName(), transfer.getPrincipalAddress()) + END_LINE + ":52D:" + transfer.getPrincipalAccountNumber() + END_LINE + transfer.getFeesAccountNumber() + END_LINE + transfer.getReferenceCurrencyCode() + transfer.getReferenceCurrencyAmount().toString().replace(".", decimalSeparator) + END_LINE + String.join((CharSequence)"", Collections.nCopies(15, " ")) + transfer.getBeneficiaryCountryCode() + " " + transfer.getBeneficiaryBankCountryCode() + END_LINE + beneficiaryBankData + END_LINE + ":59:/" + transfer.getBeneficiaryAccountNumber() + END_LINE + this.splitLines(transfer.getBeneficiaryName(), transfer.getBeneficiaryAddress()) + END_LINE + ":70:" + this.splitLines(transfer.getPaymentDetails()) + END_LINE + ":71A:" + transfer.getFeesPaymentMode() + END_LINE + ":72:" + feesData + END_LINE + "-}";
    }
}

