/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.services;

import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.dto.DomesticBankTransferDto;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.dto.ForeignBankTransferDto;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.dto.PlaBankTransferDto;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.enums.BankTransferKey;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.services.ElixirService;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.utils.Formatter;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.utils.TypeConverter;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.stereotype.Service;

@Service
public class ElixirServiceImpl
implements ElixirService {
    private static final Formatter FORMATTER = new Formatter();

    @Override
    public void createBankTransferFile(Map<String, List<?>> transfers, boolean fileHeaderLine, File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        if (Boolean.TRUE.equals(fileHeaderLine)) {
            lines.add(Formatter.writeHeaderLine(new ArrayList<String>(transfers.keySet())));
        }
        IntStream.range(0, transfers.values().stream().findFirst().map(List::size).orElse(0)).forEach(index -> {
            LinkedList<String> line = new LinkedList<String>();
            transfers.values().forEach(item -> line.add(String.valueOf(item.get(index))));
            lines.add(Formatter.bankTransfer(line));
        });
        this.writeLines(lines, file);
    }

    @Override
    public void writeToFileDomesticTransfer(List<DomesticBankTransferDto> bankTransfers, File file) throws IOException {
        List<String> linesToWrite = bankTransfers.stream().map(FORMATTER::domesticBankTransfer).collect(Collectors.toList());
        this.writeLines(linesToWrite, file);
    }

    @Override
    public void writeToFileForeignTransfer(List<ForeignBankTransferDto> bankTransfers, File file) throws IOException {
        List<String> linesToWrite = bankTransfers.stream().map(FORMATTER::foreignBankTransfer).collect(Collectors.toList());
        this.writeLines(linesToWrite, file);
    }

    private void writeLines(List<String> lines, File file) throws IOException {
        try (OutputStreamWriter outputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8);){
            for (String line : lines) {
                outputStream.write(line);
            }
        }
    }

    private List<?> convertObjectToList(Object obj) {
        List<Object> list = new ArrayList();
        if (obj.getClass().isArray()) {
            list = Arrays.asList((Object[])obj);
        } else if (obj instanceof Collection) {
            list = new ArrayList((Collection)obj);
        }
        return list;
    }

    @Override
    public Map<String, List<?>> convertFromRawData(Map<String, Variable> mappings) {
        return mappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.convertObjectToList(TypeConverter.fromRawData(((Variable)e.getValue()).getValue(), ((Variable)e.getValue()).getType(), ((Variable)e.getValue()).getType().javaType())), (prev, next) -> next, LinkedHashMap::new));
    }

    @Override
    public void validate(Map<String, List<?>> parameters) throws IllegalArgumentException {
        try {
            parameters.forEach((s, objects) -> {
                BankTransferKey key = Arrays.stream(BankTransferKey.values()).filter(e -> e.getKey().equals(s)).findFirst().orElseThrow(() -> new IllegalArgumentException("Transfer key not found"));
                objects.forEach(o -> key.getValidator().accept(o, key.getKey()));
            });
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Validation failed: " + e.getMessage());
        }
    }

    @Override
    public void createPlaTransferFile(PlaBankTransferDto dto, File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(FORMATTER.plaTransferHeader(dto.getHeader(), dto.getDecimalSeparator()));
        dto.getTransfers().stream().map(transferDto -> FORMATTER.plaTransfer((PlaBankTransferDto.PlaTransferDto)transferDto, dto.getDecimalSeparator())).forEach(lines::add);
        this.writeLines(lines, file);
    }
}

